/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.X509CertImpl;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

class CertificateRequestKeyItemImpl
extends CertificateRequestItemImpl
implements CertificateRequestKeyItem {
    private PrivateKey privateKey;

    protected CertificateRequestKeyItemImpl(String label, CertificationRequest req, PrivateKey key) throws KeyManagerException {
        super(label, req);
        this.privateKey = key;
    }

    public X509Certificate toCertificate(Extension extension, String provider) throws KeyManagerException {
        String sigOID = this.getSignatureAlgorithm().getOID();
        AlgorithmId signatureAlgorithm = KeymanUtil.getSignatureAlgorithm(sigOID);
        X509CertImpl impl = (X509CertImpl)this.createCertificate(this.getSubjectDN().getX500Name(), 1, null, signatureAlgorithm, extension, provider);
        try {
            impl.sign(this.getPrivateKey(), sigOID, provider);
        }
        catch (InvalidKeyException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_KEY_FOR_SIGNING, (Throwable)e, this.getLabel());
        }
        catch (CertificateException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_PROVIDER, (Throwable)e, provider);
        }
        catch (SignatureException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.SIGNATURE_ERROR, (Throwable)e, this.getLabel());
        }
        return impl;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

