/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

class CertificateKeyItemImpl
extends CertificateItemImpl
implements CertificateKeyItem {
    protected final PrivateKey key;
    protected final Certificate[] certChain;

    protected CertificateKeyItemImpl(String label, PrivateKey key, Certificate[] chain) throws KeyManagerException {
        super(label, (X509Certificate)chain[0]);
        this.key = key;
        this.certChain = chain;
    }

    public CertificateRequestKeyItem toCertRequest(String provider) throws KeyManagerException {
        KeyPair pair = new KeyPair(this.getCert().getPublicKey(), this.key);
        CertificateRequestKeyItem item = EntryFactory.newCertificateRequestItem(this, pair, provider);
        item.setDisplayer(this.getDisplayer());
        return item;
    }

    public KeyStore.Entry toKeyStoreEntry() {
        return new KeyStore.PrivateKeyEntry(this.key, this.certChain);
    }

    public PrivateKey getPrivateKey() {
        return this.key;
    }
}

