/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui.panels;

import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxTree
extends JTree {
    private JCheckBoxRenderer renderer;

    public CheckBoxTree(TreeModel model) {
        super(model);
        this.setSelectionPath(new TreePath(model.getRoot()));
        this.renderer = new JCheckBoxRenderer();
        this.setCellRenderer(this.renderer);
        MouseKeyHandler handler = new MouseKeyHandler();
        this.addKeyListener(handler);
        this.addMouseListener(handler);
    }

    public void resetFields() {
        KeymanTree.KeymanTreeNode root = (KeymanTree.KeymanTreeNode)this.getModel().getRoot();
        this.resetNode(root);
        this.repaint();
    }

    private void resetNode(TreeNode node) {
        KeymanTree.KeymanTreeNode treeNode;
        if (node instanceof KeymanTree.KeymanTreeNode && (treeNode = (KeymanTree.KeymanTreeNode)node).getValue() instanceof KeymanTree.KeymanTreeNode.SelectableNode) {
            KeymanTree.KeymanTreeNode.SelectableNode data = (KeymanTree.KeymanTreeNode.SelectableNode)treeNode.getValue();
            data.setSecond(false);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.resetNode(node.getChildAt(i));
        }
    }

    public Collection<String> getSelectedLeaves() {
        Collection<KeymanTree.KeymanTreeNode> leaves = ((KeymanTree)this.getModel()).getLeaves();
        ArrayList<String> returnList = new ArrayList<String>();
        for (KeymanTree.KeymanTreeNode leaf : leaves) {
            KeymanTree.KeymanTreeNode.SelectableNode node;
            if (!(leaf.getValue() instanceof KeymanTree.KeymanTreeNode.SelectableNode) || !((Boolean)(node = (KeymanTree.KeymanTreeNode.SelectableNode)leaf.getValue()).getSecond()).booleanValue()) continue;
            returnList.add((String)node.getFirst());
        }
        return returnList;
    }

    public class JCheckBoxRenderer
    implements TreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JComponent returnValue;
            if (value instanceof KeymanTree.KeymanTreeNode) {
                KeymanTree.KeymanTreeNode node = (KeymanTree.KeymanTreeNode)value;
                if (node.getValue() instanceof KeymanTree.KeymanTreeNode.SelectableNode) {
                    KeymanTree.KeymanTreeNode.SelectableNode nodeData = (KeymanTree.KeymanTreeNode.SelectableNode)node.getValue();
                    returnValue = new JCheckBox((String)nodeData.getFirst(), (boolean)((Boolean)nodeData.getSecond()));
                } else {
                    returnValue = new JLabel(value.toString());
                    returnValue.setOpaque(true);
                }
            } else {
                throw new RuntimeException("value must be DefaultMutableTreeNode");
            }
            if (selected) {
                returnValue.setBackground(UIManager.getColor("Tree.selectionBackground"));
                returnValue.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                returnValue.setBackground(tree.getBackground());
            }
            return returnValue;
        }
    }

    private class MouseKeyHandler
    implements MouseListener,
    KeyListener {
        private MouseKeyHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            this.togglePath(CheckBoxTree.this.getPathForLocation(x, y));
        }

        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == ' ') {
                this.togglePath(CheckBoxTree.this.getSelectionPath());
            }
        }

        private void togglePath(TreePath path) {
            if (path != null) {
                DefaultTreeModel model = (DefaultTreeModel)CheckBoxTree.this.getModel();
                TreeNode root = (TreeNode)model.getRoot();
                root = this.getNodeForPath(root, path);
                this.toggleNode(root, model);
                CheckBoxTree.this.repaint();
            }
        }

        private TreeNode getNodeForPath(TreeNode root, TreePath path) {
            block0: for (int i = 1; i < path.getPathCount(); ++i) {
                String currentComponent = path.getPathComponent(i).toString();
                for (int j = 0; j < root.getChildCount(); ++j) {
                    TreeNode child = root.getChildAt(j);
                    if (!child.toString().equals(currentComponent)) continue;
                    root = child;
                    continue block0;
                }
            }
            return root;
        }

        private void toggleNode(TreeNode node, DefaultTreeModel model) {
            KeymanTree.KeymanTreeNode treeNode;
            if (node instanceof KeymanTree.KeymanTreeNode && (treeNode = (KeymanTree.KeymanTreeNode)node).getValue() instanceof KeymanTree.KeymanTreeNode.SelectableNode) {
                KeymanTree.KeymanTreeNode.SelectableNode data = (KeymanTree.KeymanTreeNode.SelectableNode)treeNode.getValue();
                this.setNodeSelected(treeNode, model, (Boolean)data.getSecond() == false, true, true);
            }
        }

        private boolean isNodeSelected(TreeNode node) {
            KeymanTree.KeymanTreeNode treeNode;
            if (node instanceof KeymanTree.KeymanTreeNode && (treeNode = (KeymanTree.KeymanTreeNode)node).getValue() instanceof KeymanTree.KeymanTreeNode.SelectableNode) {
                KeymanTree.KeymanTreeNode.SelectableNode data = (KeymanTree.KeymanTreeNode.SelectableNode)treeNode.getValue();
                return (Boolean)data.getSecond();
            }
            return false;
        }

        private void setNodeSelected(TreeNode node, DefaultTreeModel model, boolean selected, boolean updateChildren, boolean updateParent) {
            KeymanTree.KeymanTreeNode treeNode;
            CheckBoxTree.this.expandPath(new TreePath(model.getPathToRoot(node)));
            if (node instanceof KeymanTree.KeymanTreeNode && (treeNode = (KeymanTree.KeymanTreeNode)node).getValue() instanceof KeymanTree.KeymanTreeNode.SelectableNode) {
                KeymanTree.KeymanTreeNode.SelectableNode data = (KeymanTree.KeymanTreeNode.SelectableNode)treeNode.getValue();
                data.setSecond(selected);
                if (updateChildren) {
                    for (int i = 0; i < treeNode.getChildCount(); ++i) {
                        this.setNodeSelected(treeNode.getChildAt(i), model, selected, true, false);
                    }
                }
                if (updateParent) {
                    if (!selected) {
                        this.setNodeSelected(node.getParent(), model, false, false, true);
                    } else {
                        TreeNode parent = node.getParent();
                        boolean hasDeselectedChild = false;
                        for (int i = 0; i < parent.getChildCount(); ++i) {
                            hasDeselectedChild |= !this.isNodeSelected(parent.getChildAt(i));
                        }
                        if (this.isNodeSelected(parent) == hasDeselectedChild) {
                            this.setNodeSelected(parent, model, !hasDeselectedChild, false, true);
                        }
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

