/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command.cli;

import com.ibm.gsk.ikeyman.util.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokeniserFactory {
    public static <T> Tokeniser<T> newArrayTokeniser(TokeniserItem<T> ... tokenisers) {
        return new ArrayTokeniser<T>(tokenisers);
    }

    public static TokeniserItem<String> newSimpleTokeniser(int numItems) {
        return new SimpleTokeniser(numItems);
    }

    public static TokeniserItem<String> newParameterTokeniser(String parameterStartTag) {
        return new ParameterTokeniser(parameterStartTag);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayTokeniser<T>
    implements Tokeniser<T> {
        private List<TokeniserItem<T>> tokenisers;

        public ArrayTokeniser(TokeniserItem<T> ... tokenisers) {
            this.tokenisers = Arrays.asList(tokenisers);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Stack<Token<T>> tokenise(T[] args) {
            void var5_8;
            Debug.entering(args);
            Stack<T> stack = new Stack<T>();
            for (int i = args.length - 1; i >= 0; --i) {
                stack.push(args[i]);
            }
            ArrayList<Token<T>> tokens = new ArrayList<Token<T>>();
            for (TokeniserItem tokeniserItem : this.tokenisers) {
                tokens.addAll(tokeniserItem.tokenise(stack));
            }
            Stack<Token<T>> tokenStack = new Stack<Token<T>>();
            int n = tokens.size() - 1;
            while (var5_8 >= 0) {
                tokenStack.push((Token<T>)tokens.get((int)var5_8));
                --var5_8;
            }
            Debug.exiting(tokenStack);
            return tokenStack;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterTokeniser
    implements TokeniserItem<String> {
        private String parameterStartTag;

        public ParameterTokeniser(String parameterStartTag) {
            this.parameterStartTag = parameterStartTag;
        }

        @Override
        public Collection<Token<String>> tokenise(Stack<String> stack) {
            Debug.entering(stack);
            ArrayList<Token<String>> tokens = new ArrayList<Token<String>>();
            while (!stack.empty()) {
                CommandToken currentToken = new CommandToken(stack.pop());
                while (!stack.empty() && !stack.peek().startsWith(this.parameterStartTag)) {
                    Debug.log("adding data element {0}", stack.peek());
                    currentToken.addDataElement(stack.pop());
                }
                Debug.log("adding token {0}", currentToken);
                tokens.add(currentToken);
            }
            Debug.exiting(tokens);
            return tokens;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleTokeniser
    implements TokeniserItem<String> {
        private int numTags;

        public SimpleTokeniser(int numTags) {
            this.numTags = numTags;
        }

        @Override
        public Collection<Token<String>> tokenise(Stack<String> stack) {
            Debug.entering(stack);
            ArrayList<Token<String>> tokens = new ArrayList<Token<String>>();
            for (int i = 0; i < this.numTags && !stack.empty(); ++i) {
                CommandToken token = new CommandToken(stack.pop());
                Debug.log("adding token {0}", token);
                tokens.add(token);
            }
            Debug.exiting(tokens);
            return tokens;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CommandToken
    implements Token<String> {
        private String tag;
        private List<String> data = new ArrayList<String>();

        public CommandToken(String tag) {
            this.tag = tag;
        }

        public void addDataElement(String element) {
            this.data.add(element);
        }

        @Override
        public List<String> getData() {
            return this.data;
        }

        @Override
        public String getTag() {
            return this.tag;
        }

        public String toString() {
            return this.tag + " " + this.data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TokeniserItem<T> {
        public Collection<Token<T>> tokenise(Stack<T> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Tokeniser<T> {
        public Stack<Token<T>> tokenise(T[] var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Token<T> {
        public T getTag();

        public List<T> getData();
    }
}

