/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeader;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.QueryableRequestDatabase;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabase;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecord;
import com.ibm.gsk.ikeyman.sequence.Sequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceIterator;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;

final class QueryableRequestDatabaseFactory {
    private QueryableRequestDatabaseFactory() {
        throw new UnsupportedOperationException();
    }

    public static QueryableRequestDatabase newQueryableRequestDatabase(RequestDatabase database) {
        return new QueryableRequestDatabaseImpl(database);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class QueryableRequestDatabaseImpl
    implements QueryableRequestDatabase {
        private RequestDatabase keydatabase;
        private int nextRecordID;

        private static ByteSequence char2UTF8ByteSequence(char[] value) {
            CharBuffer buffer = CharBuffer.wrap(value);
            Charset charset = Charset.forName("UTF-8");
            ByteBuffer bbuffer = charset.encode(buffer);
            byte[] bytes = new byte[bbuffer.limit()];
            System.arraycopy(bbuffer.array(), 0, bytes, 0, bbuffer.limit());
            return ByteSequenceFactory.newByteSequence(bytes);
        }

        QueryableRequestDatabaseImpl(RequestDatabase database) {
            if (database == null) {
                throw new NullPointerException();
            }
            this.keydatabase = database;
            int numberOfRecords = this.keydatabase.getRecords().length();
            if (numberOfRecords > 0) {
                ArrayList<Integer> recordIDs = new ArrayList<Integer>(numberOfRecords);
                for (RequestRecord record : this.keydatabase.getRecords()) {
                    recordIDs.add(record.getRecordId().toInt());
                }
                this.nextRecordID = (Integer)Collections.max(recordIDs) + 1;
            } else {
                this.nextRecordID = 1;
            }
        }

        @Override
        public RequestRecord getRecordByLabel(String label) {
            ByteSequence labelSequence;
            try {
                labelSequence = ByteSequenceFactory.newByteSequence(label.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            for (RequestRecord record : this.keydatabase.getRecords()) {
                if (!((Object)record.getLabel().getContent()).equals(labelSequence)) continue;
                return record;
            }
            return null;
        }

        @Override
        public FileHeader getHeader() {
            return this.keydatabase.getHeader();
        }

        @Override
        public Sequence<RequestRecord> getRecords() {
            return this.keydatabase.getRecords();
        }

        @Override
        public byte get(int index) throws IndexOutOfBoundsException {
            return this.keydatabase.get(index);
        }

        @Override
        public int length() {
            return this.keydatabase.length();
        }

        @Override
        public ByteSequence append(ByteSequence sequence) throws NullPointerException {
            return this.keydatabase.append(sequence);
        }

        @Override
        public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            return this.keydatabase.getSubSequence(fromPosition, toPosition);
        }

        @Override
        public int indexOf(byte b) {
            return this.keydatabase.indexOf(b);
        }

        @Override
        public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
            return this.keydatabase.indexOf(position, b);
        }

        @Override
        public int lastIndexOf(byte b) {
            return this.keydatabase.lastIndexOf(b);
        }

        @Override
        public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
            return this.keydatabase.lastIndexOf(position, b);
        }

        @Override
        public boolean isEmpty() {
            return this.keydatabase.isEmpty();
        }

        @Override
        public InputStream getInputStream() {
            return this.keydatabase.getInputStream();
        }

        @Override
        public ByteSequenceIterator getIterator() {
            return this.keydatabase.getIterator();
        }

        @Override
        public ByteSequenceIterator getIterator(int position) throws IndexOutOfBoundsException {
            return this.keydatabase.getIterator(position);
        }

        @Override
        public String toBinaryString() {
            return this.keydatabase.toBinaryString();
        }

        @Override
        public String toOctalString() {
            return this.keydatabase.toOctalString();
        }

        @Override
        public String toHexString() {
            return this.keydatabase.toHexString();
        }

        @Override
        public int getNextRecordID() {
            return this.nextRecordID++;
        }

        @Override
        public boolean equals(Object o) {
            return this.keydatabase.equals(o);
        }

        @Override
        public int hashCode() {
            return this.keydatabase.hashCode();
        }

        @Override
        public String toString() {
            return this.keydatabase.toString();
        }
    }
}

