/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest;

import com.ibm.gsk.ikeyman.certrequest.AbstractCertificateRequestStore;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.io.FileModificationTracker;
import com.ibm.gsk.ikeyman.io.LockedFileOutputStream;
import com.ibm.gsk.ikeyman.keystore.EntryInterfaceFactory;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicCertificateRequestFile<T extends DatabaseDescriptorFactory.DatabaseDescriptor>
extends AbstractCertificateRequestStore<T> {
    private static final String REQUEST_STORE_EXTENSION = ".qer";
    private static final String REQUEST_FILE_EXTENSION = ".crq";
    private static final String KEY_FILE_EXTENSION = ".bdr";
    private static final int RANDOM_BYTES = 2;
    private static final int CHARS_PER_BYTE = 2;
    private FileName fileName;
    private String storePassword;
    private List<String> aliases;
    private FileModificationTracker tracker;

    private BasicCertificateRequestFile(File f, String password, boolean create) throws KeyManagerException {
        Debug.entering(f, password, create);
        this.fileName = new FileName(f);
        this.storePassword = password;
        this.tracker = new FileModificationTracker(f.getAbsolutePath());
        if (create) {
            this.aliases = new ArrayList<String>();
        } else {
            this.rebuildAliasList();
        }
        Debug.exiting();
    }

    @Override
    public void refresh() throws KeyManagerException {
        Debug.entering();
        this.tracker.loaded();
        this.rebuildAliasList();
        Debug.exiting();
    }

    @Override
    public void add(CertificateRequestKeyItem item) throws KeyManagerException {
        EncryptedPrivateKeyInfo encryptedPrivateKey;
        Debug.entering(item);
        String uniqueLabel = BasicCertificateRequestFile.makeUniqueName(item.getLabel());
        try {
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(item.getPrivateKey().getEncoded());
            encryptedPrivateKey = new EncryptedPrivateKeyInfo(this.storePassword.toCharArray(), privateKeyInfo, "MD5", "DES");
        }
        catch (Exception e) {
            Debug.throwing(e);
            throw new KeyManagerException(KeyManagerException.ExceptionReason.PRIVATE_KEY_ENCRYPTION_ERROR, (Throwable)e, item.getLabel());
        }
        String keyFileName = this.makeKeyFileName(uniqueLabel);
        String reqFileName = this.makeRequestFileName(uniqueLabel);
        try {
            FileOutputStream out = new FileOutputStream(keyFileName);
            encryptedPrivateKey.encode((OutputStream)out);
            out.close();
            item.extract(reqFileName, null);
        }
        catch (FileNotFoundException e) {
            Debug.throwing(e);
            throw new KeyManagerException(KeyManagerException.ExceptionReason.OUTPUT_FILE_CREATION_ERROR, (Throwable)e, keyFileName);
        }
        catch (IOException e) {
            Debug.throwing(e);
            throw new KeyManagerException(KeyManagerException.ExceptionReason.PRIVATE_KEY_ENCODING_ERROR, (Throwable)e);
        }
        this.aliases.add(uniqueLabel);
        Debug.exiting();
    }

    private static String makeUniqueName(String label) {
        Debug.entering(label);
        Random random = new Random();
        byte[] bytes = new byte[2];
        random.nextBytes(bytes);
        StringBuffer buf = new StringBuffer(label);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append("0123456789ABCDEF".charAt(bytes[i] >> 4 & 0xF));
            buf.append("0123456789ABCDEF".charAt(bytes[i] & 0xF));
        }
        Debug.exiting(buf.toString());
        return buf.toString();
    }

    private void rebuildAliasList() throws KeyManagerException {
        BufferedReader reader;
        Debug.entering();
        this.tracker.loaded();
        this.aliases = new ArrayList<String>();
        try {
            reader = new BufferedReader(new FileReader(this.fileName.toString()));
        }
        catch (FileNotFoundException e1) {
            Debug.throwing(e1);
            return;
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.aliases.add(line);
            }
        }
        catch (IOException e) {
            Debug.throwing(e);
            throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e, this.fileName.getName());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    return;
                }
            }
        }
        Debug.exiting();
    }

    @Override
    public void delete() throws KeyManagerException {
        Debug.entering();
        for (String alias : this.aliases) {
            this.delete(alias);
        }
        File tempFile = new File(this.fileName.getFile());
        if (tempFile.exists() && !tempFile.delete()) {
            KeyManagerException e = new KeyManagerException(KeyManagerException.ExceptionReason.FILE_DELETION_FAILED, this.fileName.getName());
            Debug.throwing(e);
            throw e;
        }
        Debug.exiting();
    }

    @Override
    public void delete(String label) throws KeyManagerException {
        Debug.entering(label);
        if (!this.contains(label)) {
            KeyManagerException e = new KeyManagerException(KeyManagerException.ExceptionReason.NO_REQUEST_FOR_LABEL, label);
            Debug.throwing(e);
            throw e;
        }
        String fullLabel = this.getFullLabel(label);
        this.deleteCertificateRequestFiles(fullLabel);
        this.aliases.remove(fullLabel);
        Debug.exiting();
    }

    private String getFullLabel(String label) {
        Debug.entering(label);
        for (String alias : this.aliases) {
            if (!alias.startsWith(label)) continue;
            Debug.exiting(alias);
            return alias;
        }
        Debug.exiting(null);
        return null;
    }

    private void deleteCertificateRequestFiles(String fullLabel) throws KeyManagerException {
        Debug.entering(fullLabel);
        String requestFileName = this.makeRequestFileName(fullLabel);
        File f = new File(requestFileName);
        if (!f.delete()) {
            KeyManagerException e = new KeyManagerException(KeyManagerException.ExceptionReason.FILE_DELETION_FAILED, requestFileName);
            Debug.throwing(e);
            throw e;
        }
        String keyFileName = this.makeKeyFileName(fullLabel);
        f = new File(keyFileName);
        if (!f.delete()) {
            KeyManagerException e = new KeyManagerException(KeyManagerException.ExceptionReason.FILE_DELETION_FAILED, keyFileName);
            Debug.throwing(e);
            throw e;
        }
        Debug.exiting();
    }

    private String makeKeyFileName(String fullLabel) {
        Debug.entering(fullLabel);
        String returnValue = this.fileName.getDirectory() + File.separator + fullLabel + KEY_FILE_EXTENSION;
        Debug.exiting(returnValue);
        return returnValue;
    }

    private String makeRequestFileName(String fullLabel) {
        Debug.entering(fullLabel);
        String returnValue = this.fileName.getDirectory() + File.separator + fullLabel + REQUEST_FILE_EXTENSION;
        Debug.exiting(returnValue);
        return returnValue;
    }

    @Override
    public CertificateRequestKeyItem getItem(String label) throws KeyManagerException {
        Debug.entering(label);
        if (this.contains(label)) {
            PrivateKey privateKey;
            CertificationRequest req;
            String fullLabel = this.getFullLabel(label);
            String keyFile = this.makeKeyFileName(fullLabel);
            String requestFile = this.makeRequestFileName(fullLabel);
            try {
                File tempFile = new File(requestFile);
                if (!tempFile.exists() || !tempFile.canRead()) {
                    KeyManagerException e = new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_REQUEST_FILE_NOT_FOUND, requestFile);
                    Debug.throwing(e);
                    throw e;
                }
                req = new CertificationRequest(requestFile, true);
            }
            catch (IOException e) {
                Debug.throwing(e);
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CERT_REQUEST_FILE_CORRUPTED, (Throwable)e, requestFile);
            }
            try {
                File tempFile = new File(keyFile);
                if (!tempFile.exists() || !tempFile.canRead()) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_FILE_NOT_FOUND, keyFile);
                }
                EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(keyFile, false);
                byte[] privateKeyInfoBytes = epki.decrypt(this.storePassword.toCharArray());
                privateKey = PrivateKeyInfo.parseKey((DerValue)new DerValue(privateKeyInfoBytes));
            }
            catch (Exception e) {
                Debug.throwing(e);
                throw new KeyManagerException(KeyManagerException.ExceptionReason.PRIVATE_KEY_DECRYPTION_ERROR, (Throwable)e, label);
            }
            CertificateRequestKeyItem returnValue = EntryFactory.loadCertificateRequestItem(label, req, privateKey);
            Debug.exiting(returnValue);
            return returnValue;
        }
        KeyManagerException e = new KeyManagerException(KeyManagerException.ExceptionReason.NO_REQUEST_FOR_LABEL, label);
        Debug.throwing(e);
        throw e;
    }

    @Override
    public void save() throws KeyManagerException {
        Debug.entering();
        if (this.aliases.size() > 0) {
            LockedFileOutputStream out;
            try {
                out = new LockedFileOutputStream(this.fileName.toString());
            }
            catch (IOException e) {
                Debug.throwing(e);
                throw new KeyManagerException(KeyManagerException.ExceptionReason.OUTPUT_FILE_CREATION_ERROR, (Throwable)e, this.fileName.getName());
            }
            PrintStream pout = new PrintStream(out);
            for (String alias : this.aliases) {
                pout.println(alias);
            }
            pout.close();
        } else {
            File tempFile = new File(this.fileName.toString());
            if (tempFile.exists()) {
                tempFile.delete();
            }
        }
        Debug.exiting();
    }

    public static <T extends DatabaseDescriptorFactory.DatabaseDescriptor> EntryInterfaceFactory.EntryInterface<CertificateRequestKeyItem, T> createRequestFile(String databaseName, String password, Class<T> c) throws KeyManagerException {
        Debug.entering(databaseName, password);
        File f = new File(databaseName + REQUEST_STORE_EXTENSION);
        BasicCertificateRequestFile<T> returnValue = new BasicCertificateRequestFile<T>(f, password, true);
        Debug.exiting(returnValue);
        return returnValue;
    }

    public static <T extends DatabaseDescriptorFactory.DatabaseDescriptor> EntryInterfaceFactory.EntryInterface<CertificateRequestKeyItem, T> loadRequestFile(String databaseName, String password, Class<T> c) throws KeyManagerException {
        Debug.entering(databaseName, password);
        File f = new File(databaseName + REQUEST_STORE_EXTENSION);
        BasicCertificateRequestFile<T> returnValue = new BasicCertificateRequestFile<T>(f, password, false);
        Debug.exiting(returnValue);
        return returnValue;
    }

    @Override
    public List<String> getAliases() {
        Debug.entering();
        ArrayList<String> returnList = new ArrayList<String>();
        for (String alias : this.aliases) {
            Debug.log("{0}", alias);
            returnList.add(((Object)alias.subSequence(0, alias.length() - 4)).toString());
        }
        Debug.exiting(returnList);
        return returnList;
    }

    @Override
    public void changePassword(CommandParameters params) throws KeyManagerException {
        Debug.entering(params);
        String newPassword = params.getNewPassword();
        ArrayList<CertificateRequestKeyItem> tempList = new ArrayList<CertificateRequestKeyItem>();
        for (String alias : this.getAliases()) {
            tempList.add(this.getItem(alias));
        }
        this.storePassword = newPassword;
        for (CertificateRequestKeyItem item : tempList) {
            this.delete(item.getLabel());
            this.add(item);
        }
        Debug.exiting();
    }

    @Override
    public boolean needsRefresh() {
        Debug.entering();
        boolean returnValue = this.tracker.needsRefresh();
        Debug.exiting(returnValue);
        return returnValue;
    }
}

