/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.Enumeration;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.apache.harmony.jndi.internal.nls.Messages;

public class DNSName
implements Name,
Cloneable {
    private static final long serialVersionUID = -5931312723719884197L;
    private Vector<String> components;

    public DNSName() {
        this.components = new Vector();
    }

    DNSName(Vector<String> vector) {
        this.components = vector;
    }

    @Override
    public int size() {
        return this.components.size();
    }

    @Override
    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    public boolean isAbsolute() {
        String string;
        return this.components.size() > 0 && (string = this.components.get(0)) != null && string.length() == 0;
    }

    @Override
    public Object clone() {
        Vector<String> vector = new Vector<String>();
        Enumeration<String> enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return new DNSName(vector);
    }

    @Override
    public Object remove(int n) throws InvalidNameException {
        return this.components.remove(n);
    }

    @Override
    public int compareTo(Object object) {
        DNSName dNSName = null;
        if (object == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        if (!(object instanceof DNSName)) {
            throw new ClassCastException(Messages.getString("jndi.2F"));
        }
        dNSName = (DNSName)object;
        Enumeration<String> enumeration = this.getAll();
        Enumeration<String> enumeration2 = dNSName.getAll();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!enumeration2.hasMoreElements()) {
                return 1;
            }
            String string2 = enumeration2.nextElement();
            int n = string.compareToIgnoreCase(string2);
            if (n == 0) continue;
            return n;
        }
        if (enumeration2.hasMoreElements()) {
            return -1;
        }
        return 0;
    }

    @Override
    public String get(int n) {
        return this.components.elementAt(n);
    }

    @Override
    public Enumeration<String> getAll() {
        return this.components.elements();
    }

    @Override
    public Name getPrefix(int n) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            vector.addElement(this.components.elementAt(i));
        }
        return new DNSName(vector);
    }

    @Override
    public Name getSuffix(int n) {
        Vector<String> vector = new Vector<String>();
        for (int i = n; i < this.components.size(); ++i) {
            vector.addElement(this.components.elementAt(i));
        }
        return new DNSName(vector);
    }

    @Override
    public boolean endsWith(Name name) {
        int n;
        int n2 = -1;
        if (name == null) {
            return false;
        }
        if (!(name instanceof DNSName)) {
            return false;
        }
        int n3 = this.size();
        if (n3 == (n = name.size())) {
            try {
                n2 = this.compareTo(name);
            }
            catch (ClassCastException classCastException) {}
        } else if (n3 > n) {
            Name name2 = this.getSuffix(n3 - n);
            n2 = name2.compareTo(name);
        }
        return n2 == 0;
    }

    @Override
    public boolean startsWith(Name name) {
        int n;
        int n2 = -1;
        if (name == null) {
            return false;
        }
        if (!(name instanceof DNSName)) {
            return false;
        }
        int n3 = this.size();
        if (n3 == (n = name.size())) {
            try {
                n2 = this.compareTo(name);
            }
            catch (ClassCastException classCastException) {}
        } else if (n3 > n) {
            Name name2 = this.getPrefix(n);
            n2 = name2.compareTo(name);
        }
        return n2 == 0;
    }

    @Override
    public Name add(int n, String string) throws InvalidNameException {
        if (!DNSName.componentIsOk(string)) {
            throw new InvalidNameException(Messages.getString("jndi.30", string));
        }
        this.components.insertElementAt(string, n);
        return this;
    }

    @Override
    public Name add(String string) throws InvalidNameException {
        if (!DNSName.componentIsOk(string)) {
            throw new InvalidNameException(Messages.getString("jndi.30", string));
        }
        this.components.addElement(string);
        return this;
    }

    @Override
    public Name addAll(int n, Name name) throws InvalidNameException {
        if (!(name instanceof DNSName)) {
            throw new InvalidNameException(Messages.getString("jndi.31"));
        }
        Vector<String> vector = ((DNSName)name).components;
        this.components.addAll(n, vector);
        return this;
    }

    @Override
    public Name addAll(Name name) throws InvalidNameException {
        if (!(name instanceof DNSName)) {
            throw new InvalidNameException(Messages.getString("jndi.31"));
        }
        Vector<String> vector = ((DNSName)name).components;
        this.components.addAll(vector);
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.components.size() - 1; i >= 0; --i) {
            String string = this.components.elementAt(i);
            if (stringBuffer.length() > 0 || i == 0) {
                stringBuffer.append('.');
            }
            if (string.length() <= 0) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    static boolean componentIsOk(String string) {
        return string.indexOf(".") == -1 && string.length() <= 63;
    }
}

