/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;
import org.apache.harmony.jndi.internal.nls.Messages;

public abstract class GenericURLContext
implements Context {
    protected Hashtable<Object, Object> environment;

    protected GenericURLContext() {
        this(null);
    }

    protected GenericURLContext(Hashtable<?, ?> hashtable) {
        this.environment = hashtable == null ? new Hashtable() : (Hashtable)hashtable.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            return this.lookup(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            Object object = context.lookup(name.getSuffix(1));
            return object;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.environment);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Object object = context.lookup(resolveResult.getRemainingName());
            return object;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookupLink(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            return this.lookupLink(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            Object object = context.lookupLink(name.getSuffix(1));
            return object;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookupLink(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.environment);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Object object = context.lookupLink(resolveResult.getRemainingName());
            return object;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(Name name, Object object) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            this.bind(name.get(0), object);
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.bind(name.getSuffix(1), object);
            }
            finally {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String string, Object object) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.environment);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.bind(resolveResult.getRemainingName(), object);
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(Name name, Object object) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            this.rebind(name.get(0), object);
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.rebind(name.getSuffix(1), object);
            }
            finally {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(String string, Object object) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.environment);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.rebind(resolveResult.getRemainingName(), object);
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            this.unbind(name.get(0));
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.unbind(name.getSuffix(1));
            }
            finally {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.environment);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.unbind(resolveResult.getRemainingName());
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            return this.createSubcontext(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            Context context2 = context.createSubcontext(name.getSuffix(1));
            return context2;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context createSubcontext(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.environment);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Context context2 = context.createSubcontext(resolveResult.getRemainingName());
            return context2;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            this.destroySubcontext(name.get(0));
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.destroySubcontext(name.getSuffix(1));
            }
            finally {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySubcontext(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.environment);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.destroySubcontext(resolveResult.getRemainingName());
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(Name name, Name name2) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (!(name2 instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name2));
        }
        if (name.size() == 1 ^ name2.size() != 1) {
            throw new OperationNotSupportedException(Messages.getString("jndi.27", name, name2));
        }
        if (name.size() == 1) {
            this.rename(name.get(0), name2.get(0));
        } else {
            if (!this.urlEquals(name.get(0), name.get(0))) {
                throw new OperationNotSupportedException(Messages.getString("jndi.28", name, name2));
            }
            Context context = this.getContinuationContext(name);
            try {
                context.rename(name.getSuffix(1), name2.getSuffix(1));
            }
            finally {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String string, String string2) throws NamingException {
        String string3;
        String string4 = this.getURLPrefix(string);
        if (!this.urlEquals(string4, string3 = this.getURLPrefix(string2))) {
            throw new OperationNotSupportedException(Messages.getString("jndi.29", string, string2));
        }
        ResolveResult resolveResult = this.getRootURLContext(string, this.environment);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.rename(resolveResult.getRemainingName(), this.getURLSuffix(string3, string2));
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            return this.list(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = context.list(name.getSuffix(1));
            return namingEnumeration;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.environment);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = context.list(resolveResult.getRemainingName());
            return namingEnumeration;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            return this.listBindings(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            NamingEnumeration<Binding> namingEnumeration = context.listBindings(name.getSuffix(1));
            return namingEnumeration;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.environment);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            NamingEnumeration<Binding> namingEnumeration = context.listBindings(resolveResult.getRemainingName());
            return namingEnumeration;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            return this.getNameParser(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            NameParser nameParser = context.getNameParser(name.getSuffix(1));
            return nameParser;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameParser getNameParser(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.environment);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            NameParser nameParser = context.getNameParser(resolveResult.getRemainingName());
            return nameParser;
        }
        finally {
            context.close();
        }
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        return ((Name)name2.clone()).addAll(name);
    }

    @Override
    public String composeName(String string, String string2) {
        return string2.length() < 1 ? string : (string.length() < 1 ? string2 : string2 + '/' + string);
    }

    @Override
    public String getNameInNamespace() {
        return "";
    }

    @Override
    public Hashtable<?, ?> getEnvironment() {
        return (Hashtable)this.environment.clone();
    }

    @Override
    public Object addToEnvironment(String string, Object object) {
        return this.environment.put(string, object);
    }

    @Override
    public Object removeFromEnvironment(String string) {
        return this.environment.remove(string);
    }

    @Override
    public void close() {
        this.environment = null;
    }

    protected Context getContinuationContext(Name name) throws NamingException {
        return NamingManager.getContinuationContext(this.createCannotProceedException(name));
    }

    protected final CannotProceedException createCannotProceedException(Name name) throws NamingException {
        CannotProceedException cannotProceedException = new CannotProceedException();
        cannotProceedException.setResolvedObj(this.lookup(name.get(0)));
        cannotProceedException.setEnvironment(this.environment);
        return cannotProceedException;
    }

    protected abstract ResolveResult getRootURLContext(String var1, Hashtable<?, ?> var2) throws NamingException;

    protected boolean urlEquals(String string, String string2) {
        return string.equals(string2);
    }

    protected String getURLPrefix(String string) throws NamingException {
        int n = string.indexOf(58);
        if (n < 0) {
            throw new OperationNotSupportedException(Messages.getString("jndi.2A", string));
        }
        if (string.startsWith("//", ++n)) {
            int n2 = string.indexOf(47, n + 2);
            n = n2 >= 0 ? n2 : string.length();
        }
        return string.substring(0, n);
    }

    protected Name getURLSuffix(String string, String string2) throws NamingException {
        int n = string.length();
        if (n >= string2.length() - 1) {
            return new CompositeName();
        }
        String string3 = string2.substring(string2.charAt(n) == '/' ? n + 1 : n);
        try {
            return new CompositeName().add(GenericURLContext.decodeURLString(string3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (InvalidNameException)new InvalidNameException().initCause(illegalArgumentException);
        }
    }

    protected static final String decodeURLString(String string) throws IllegalArgumentException {
        int n = string.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c;
            if ((c = string.charAt(n3++)) == '%') {
                int n4 = n3 + 2;
                if (n4 > n) {
                    new IllegalArgumentException(Messages.getString("jndi.2B", string));
                }
                try {
                    byArray[n2++] = (byte)Integer.parseInt(string.substring(n3, n4), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    throw (IllegalArgumentException)new IllegalArgumentException(Messages.getString("jndi.2B", string)).initCause(numberFormatException);
                }
                n3 = n4;
                continue;
            }
            byArray[n2++] = (byte)c;
        }
        return new String(byArray, 0, n2);
    }
}

