/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.saxhandler;

import com.ibm.jvm.j9.dump.command.CommandPlugin;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class GenericSaxHandler
extends DefaultHandler {
    private static String errorString;
    private static boolean bInErrorElement;
    private static StringBuffer gpfSb;
    private static boolean bInGpfElement;
    private static Object userHandler;
    private static Locator documentLocator;
    private static Class userHandlerClass;
    private static HashMap methodTable;
    private static int level;
    private static boolean bFatalParseError;

    public GenericSaxHandler(File inputFile, Object handoff, Object plugin) throws SAXException, FileNotFoundException {
        if (inputFile == null) {
            throw new SAXException("null input file");
        }
        GenericSaxHandler handler = this;
        userHandler = handoff;
        userHandlerClass = userHandler.getClass();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        try {
            CommandPlugin cp;
            SAXParser saxParser = factory.newSAXParser();
            if (null != plugin && plugin instanceof CommandPlugin) {
                cp = (CommandPlugin)plugin;
                cp.notifyObservers("Parsing of xml started for file " + inputFile.getName() + "... be patient");
            }
            saxParser.parse(inputFile, (DefaultHandler)handler);
            if (null != plugin && plugin instanceof CommandPlugin) {
                cp = (CommandPlugin)plugin;
                cp.notifyObservers("Parsing ended");
            }
        }
        catch (SAXParseException e) {
            Console.reportError("SaxParseException caught", null);
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (UTFDataFormatException UTFe) {
            StringBuffer sb = new StringBuffer("UTFDataFormatException caught\n");
            sb.append("\tmessage:" + UTFe.getMessage() + "\n");
            sb.append("\tDamaged xml.");
            Console.reportError(sb.toString(), null);
            bFatalParseError = true;
        }
        catch (Exception t) {
            Console.reportError("Unexpected error caught while attempting to parse xml", t);
        }
        if (bFatalParseError) {
            throw new SAXException("Fatal Error");
        }
    }

    public void setDocumentLocator(Locator locator) {
        documentLocator = locator;
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        String ename = this.getName(localName, qualifiedName);
        this.passToUserMethod(ename, attributes, true);
        ++level;
    }

    public void endElement(String namespaceUri, String localName, String qualifiedName) throws SAXException {
        String ename = this.getName(localName, qualifiedName);
        this.passToUserMethod(ename, null, false);
        --level;
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (bInErrorElement) {
            errorString = new String(buf, offset, len);
        }
        if (bInGpfElement) {
            if (gpfSb == null) {
                gpfSb = new StringBuffer();
                gpfSb.append(new String(buf, offset, len));
            } else {
                gpfSb.append(new String(buf, offset, len));
            }
        }
    }

    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
    }

    public void error(SAXParseException exception) throws SAXException {
        Console.reportError("SAXParseException error: ", exception);
    }

    public void warning(SAXParseException exception) throws SAXException {
        Console.reportError("SAXParseException warning: ", exception);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        Console.reportError("Fatal error encountered processing incoming xml.", null);
        bFatalParseError = true;
    }

    private String getName(String s1, String s2) {
        if (s1 == null || "".equals(s1)) {
            return s2;
        }
        return s1;
    }

    private void passToUserMethod(String name, Attributes attributes, boolean torf) {
        Method m = null;
        String expandedName = name + "El";
        m = (Method)methodTable.get(expandedName);
        if (null == m && methodTable.containsKey(expandedName)) {
            return;
        }
        if (null == m) {
            try {
                Class[] parmTypes = new Class[]{Attributes.class, Boolean.class};
                m = userHandlerClass.getDeclaredMethod(expandedName, parmTypes);
            }
            catch (Exception e) {
                System.out.println("Warning:  \"" + name + "\" is an unknown tag and is being ignored");
            }
            methodTable.put(expandedName, m);
        }
        if (null != m) {
            try {
                m.invoke(userHandler, attributes, new Boolean(torf));
            }
            catch (Exception e) {
                Console.reportError("Exception trying to invoke sax parsing for " + expandedName, e);
            }
        }
    }

    public static int getLevel() {
        return level;
    }

    public static void setLevel(int i) {
        level = i;
    }

    public static void setBInErrorElement(boolean inErrorElement) {
        bInErrorElement = inErrorElement;
    }

    public static String getErrorString() {
        return errorString;
    }

    public static void setBInGpfElement(boolean inGpfElement) {
        bInGpfElement = inGpfElement;
    }

    public static StringBuffer getGpfSb() {
        return gpfSb;
    }

    static {
        methodTable = new HashMap();
        level = 0;
        bFatalParseError = false;
    }
}

