/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel;

import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDump;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpClassCache;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpHandler;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpRecord;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ShortObjectRecord
extends PortableHeapDumpRecord {
    public static final byte MAGIC_NUMBER = -128;
    private byte classCacheIndex;
    private byte gapSize;
    private short gapPreceding;
    private short hashcode;

    public ShortObjectRecord(J9Object current, J9Object previous, byte classCacheIndex) {
        this.tag = (byte)-128;
        if (classCacheIndex > 3) {
            throw new IllegalArgumentException("classCacheIndex is too big!");
        }
        this.classCacheIndex = classCacheIndex;
        this.setReferences(current);
        long addressDifference = ShortObjectRecord.getAddressDifference(current, previous);
        if (addressDifference > 32767L || addressDifference < -32768L) {
            throw new IllegalArgumentException("address differences is too big - need long record");
        }
        this.gapSize = PortableHeapDumpRecord.sizeofReference(addressDifference);
        this.gapPreceding = (short)addressDifference;
    }

    public void writeHeapDump(DataOutput dos) throws IOException {
        int tagAndFlag = 128;
        tagAndFlag |= this.classCacheIndex << 5;
        tagAndFlag |= this.References.length << 3;
        tagAndFlag |= this.gapSize << 2;
        dos.writeByte(tagAndFlag |= this.referenceSize);
        this.writeReference(dos, this.gapSize, this.gapPreceding);
        if (PortableHeapDump.isJ9()) {
            dos.writeShort(this.hashcode);
        }
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.println("\ttag and flag = " + tagAndFlag + " num of ref = " + this.References.length);
        }
        this.writeReferences(dos);
    }

    public static void readHeapDump(DataInput dis, byte flag, PortableHeapDumpHandler phdh, PortableHeapDumpClassCache phdcc) {
    }
}

