/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel;

import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDump;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpHandler;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpRecord;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ClassRecord
extends PortableHeapDumpRecord {
    public static final byte MAGIC_NUMBER = 6;
    private byte gapSize;
    private long gapPreceding;
    private boolean hashedandmoved;
    private int instanceSize;
    private long superclass;
    private String className;

    public ClassRecord(J9Object current, J9Object previous) {
        this.tag = (byte)6;
        J9Class j9c = J9JVMConsole.getClass(current.getObjectAddress());
        this.className = j9c.getName();
        this.setReferences(current);
        this.gapPreceding = ClassRecord.getAddressDifference(current, previous);
        this.gapSize = ClassRecord.sizeofReference(this.gapPreceding);
        this.instanceSize = j9c.getInstanceSize();
        this.superclass = Long.decode(current.getClassForObject().getSuperId());
        if (PortableHeapDump.isJ9()) {
            this.hashedandmoved = false;
        }
    }

    public void writeHeapDump(DataOutput dos) throws IOException {
        dos.writeByte(this.tag);
        int flag = 0;
        flag = (byte)(flag | this.gapSize << 6);
        flag = (byte)(flag | this.referenceSize << 4);
        if (this.hashedandmoved) {
            flag = (byte)(flag | 8);
        }
        dos.writeByte(flag);
        this.writeReference(dos, this.gapSize, this.gapPreceding);
        dos.writeInt(this.instanceSize);
        dos.writeShort(this.hashCode());
        if (PortableHeapDump.is32bit()) {
            dos.writeInt((int)this.superclass);
        } else {
            dos.writeLong(this.superclass);
        }
        dos.writeUTF(this.className);
        dos.writeInt(this.References.length);
        this.writeReferences(dos);
    }

    public static void readHeapDump(DataInput dis, byte flag, PortableHeapDumpHandler phdh) {
    }
}

