/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump;

import com.ibm.jvm.j9.dump.command.CommandDetails;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpAbstractCommand;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpBaseCmds;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpConsole;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Observable;
import java.util.zip.GZIPOutputStream;

public class HeapDumpFileCommand
extends HeapDumpAbstractCommand {
    public static final String FILE_PROPERTY = "HEAPDUMPFILE";
    public static final String GZIP_EXTENSION = ".gz";
    public static final String NOUN = "F";
    private static final String DESC = "Writes a portable heapdump file to disk";

    public HeapDumpFileCommand(HeapDumpBaseCmds cp, Observable o) {
        super(NOUN, cp, o, DESC);
    }

    public boolean checkUserInput(CommandDetails cd) {
        return cd.getNoun().equals(NOUN);
    }

    public String action(CommandDetails cd, Observable ob) {
        String heapDumpFileName = HeapDumpConsole.getProperty(FILE_PROPERTY);
        if (heapDumpFileName == null || heapDumpFileName.equals("")) {
            heapDumpFileName = HeapDumpUtil.getDefaultFileName();
        }
        File heapDumpFile = new File(heapDumpFileName);
        ob.notifyObservers("Now dumping heapdump file " + heapDumpFile.getAbsolutePath());
        ob.notifyObservers("\n");
        try {
            OutputStream rawOutputStream = new FileOutputStream(heapDumpFileName);
            if (heapDumpFileName.endsWith(GZIP_EXTENSION)) {
                ob.notifyObservers("Writing Compressed Heapdump\n");
                rawOutputStream = new GZIPOutputStream(rawOutputStream);
            }
            PrintWriter output = new PrintWriter(rawOutputStream);
            int objectCount = 0;
            if (HeapDumpUtil.isPortableDump()) {
                ob.notifyObservers("Writing Heapdump in Portable Format");
                objectCount = HeapDumpUtil.doPortableHeapDump(rawOutputStream);
            } else {
                ob.notifyObservers("Writing Heapdump in Classic Format");
                objectCount = HeapDumpUtil.doClassicHeapDump(output);
            }
            ob.notifyObservers("Heapdump complete, number of objects processed = " + objectCount);
            output.close();
        }
        catch (Exception e) {
            ob.notifyObservers("Error writing Heapdump: ");
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            ob.notifyObservers(sw.toString());
            return "Heapdump failed";
        }
        return "Heapdump Successful";
    }
}

