/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.gen;

import com.ibm.ws.persistence.pdqstatic.gen.StaticAbstractSQLStmt;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenUtil;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenerator;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSelectStmt;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;

public class StaticUpdateStmt
extends StaticAbstractSQLStmt {
    private static final Localizer _loc = Localizer.forPackage(StaticUpdateStmt.class);
    protected Map<String, List> updatableFieldsMap = new HashMap<String, List>();
    protected Map<String, Map> pkSettersMap = new HashMap<String, Map>();
    protected Collection entities = null;
    protected int[] updateMode = new int[]{1, 2};
    protected int[] lockMode = new int[]{1, 2};

    public StaticUpdateStmt(EntityManager em, StaticSQLGenerator.BindInfo bindInfo, Log _logs) {
        super(em, bindInfo, _logs);
        if (this.updatableFieldsMap.size() == 0) {
            StaticSQLGenUtil.findUpdatableFields(this.clms, this.updatableFieldsMap, this.pkSettersMap);
        }
    }

    public void generate() {
        for (int i = 0; i < this.lockMode.length; ++i) {
            for (int j = 0; j < this.updateMode.length; ++j) {
                this.generateUpdateStmt(this.lockMode[i], this.updateMode[j]);
            }
        }
        this.generateMergeStmt();
    }

    private void generateUpdateStmt(int lockMode, int updateMode) {
        StaticSelectStmt selectStmt = new StaticSelectStmt(this.em, this.bindInfo, this._logs);
        this.entities = selectStmt.getEntities();
        this.generateUpdateStmt1(lockMode, updateMode);
    }

    private void generateUpdateStmt1(int lockMode, int updateMode) {
        Map clm2entityMap = StaticSQLGenUtil.getClm2EntitiesMap(this.entities, this.clms);
        Map cls2entityMap = StaticSQLGenUtil.getCls2EntitiesMap(this.entities);
        this.em.getTransaction().begin();
        for (Object entity : this.entities) {
            List fieldsToUpdate;
            ClassMapping clm = StaticSQLGenUtil.getClassMapping(entity, this.clms);
            if (clm == null) continue;
            Class entityClass = clm.getDescribedType();
            String entityClassName = entityClass.getName();
            FieldMapping[] declaredFields = clm.getDeclaredFieldMappings();
            FieldMapping[] allPKFields = (FieldMapping[])clm.getPrimaryKeyFields();
            HashMap oneRelationMap = new HashMap();
            HashMap manyRelationMap = new HashMap();
            if (this._logs.isTraceEnabled()) {
                this._logs.trace(_loc.get("update-entity", entityClassName));
            }
            if ((fieldsToUpdate = this.updatableFieldsMap.get(entityClassName)) == null) continue;
            Map pkSetters = this.pkSettersMap.get(entityClassName);
            StaticSQLGenUtil.constructCollectionParm(entityClassName, manyRelationMap, fieldsToUpdate, clm2entityMap, this._logs);
            StaticSQLGenUtil.collectEntityParm(entityClassName, oneRelationMap, fieldsToUpdate, clm2entityMap, cls2entityMap);
            if (!this.bindInfo.singlePackage) {
                this.metaRepo.setPkgName(entityClassName);
            }
            if (lockMode == 1) {
                this.metaRepo.setRuntimeSignature(entityClassName + ":OptimisticLockRead");
                this.em.lock(entity, LockModeType.READ);
            } else if (lockMode == 2) {
                this.metaRepo.setRuntimeSignature(entityClassName + ":OptimisticLockWrite");
                this.em.lock(entity, LockModeType.WRITE);
            }
            this.invokeSetters(entity, fieldsToUpdate, manyRelationMap, oneRelationMap, pkSetters, updateMode);
        }
        StaticSQLGenUtil.commit(this.em, this._logs);
    }

    private void invokeSetters(Object entity, List fieldsToUpdate, Map manyRelationMap, Map oneRelationMap, Map pkSetters, int updateMode) {
        Class<?> entityClass = entity.getClass();
        ArrayList pcSetMethods = new ArrayList();
        ArrayList setMethods = new ArrayList();
        StaticSQLGenUtil.getMethods(entity, pcSetMethods, setMethods, false, fieldsToUpdate);
        this.invokeSetters(entity, fieldsToUpdate, manyRelationMap, oneRelationMap, pkSetters, pcSetMethods, true, updateMode);
        if (setMethods.size() != 0) {
            this.invokeSetters(entity, fieldsToUpdate, manyRelationMap, oneRelationMap, pkSetters, setMethods, false, updateMode);
        }
    }

    private void invokeSetters(Object entity, List fieldsToUpdate, Map manyRelationMap, Map oneRelationMap, Map pkSetters, List methods, boolean isPCSet, int updateMode) {
        Class<?> entityClass = entity.getClass();
        String entityClassName = entityClass.getName();
        boolean invoked = false;
        String runTimeSignature = "";
        int cnt = 0;
        boolean hasLob = false;
        ArrayList<Method> lazyMethods = new ArrayList<Method>();
        ArrayList<Method> eagerMethods = new ArrayList<Method>();
        for (Method method : methods) {
            FieldMapping fm;
            String methodName = method.getName();
            if (pkSetters != null && StaticSQLGenUtil.isPKSetter(pkSetters, methodName) || (fm = StaticSQLGenUtil.isUpdatable(methodName, fieldsToUpdate)) == null) continue;
            boolean isEager = fm.isInDefaultFetchGroup();
            if (!isEager) {
                lazyMethods.add(method);
                continue;
            }
            eagerMethods.add(method);
        }
        Method[] methodArray = new Method[lazyMethods.size() + eagerMethods.size()];
        int i = 0;
        for (i = 0; i < lazyMethods.size(); ++i) {
            methodArray[i] = (Method)lazyMethods.get(i);
        }
        for (int j = 0; j < eagerMethods.size(); ++j) {
            methodArray[i++] = (Method)eagerMethods.get(j);
        }
        block15: for (i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String methodName = method.getName();
            FieldMapping fm = StaticSQLGenUtil.isUpdatable(methodName, fieldsToUpdate);
            boolean isEager = fm.isInDefaultFetchGroup();
            Class<?>[] parms = method.getParameterTypes();
            if (isPCSet && parms.length != 2 || !isPCSet && parms.length != 1) continue;
            method.setAccessible(true);
            if (!this.bindInfo.singlePackage) {
                this.metaRepo.setPkgName(entityClassName);
            }
            this.metaRepo.setRuntimeSignature(entityClassName + ":" + methodName);
            boolean invoked1 = false;
            String extStr = StaticSQLGenUtil.findExtString(fm);
            if (extStr != null) {
                try {
                    method.invoke(null, entity, extStr);
                }
                catch (Exception e) {
                    StaticSQLGenUtil.printException(this._logs, e);
                    continue;
                }
                invoked1 = true;
            } else {
                try {
                    invoked1 = this.invoke1Setter(entity, method, manyRelationMap, oneRelationMap, isPCSet);
                }
                catch (Exception e) {
                    StaticSQLGenUtil.printException(this._logs, e);
                }
            }
            if (!invoked1 && this._logs.isTraceEnabled()) {
                this._logs.trace(_loc.get("fail-to-invoke", methodName));
                continue;
            }
            invoked = true;
            ++cnt;
            switch (updateMode) {
                case 1: {
                    if (isEager) continue block15;
                    StaticSQLGenUtil.persistFlush(this.em, entity, this._logs);
                    continue block15;
                }
                case 2: {
                    if (isEager) continue block15;
                    StaticSQLGenUtil.refreshFlush(this.em, entity, this._logs);
                }
            }
        }
        if (invoked && !hasLob) {
            switch (updateMode) {
                case 1: {
                    this.metaRepo.setRuntimeSignature(entityClassName + ":setAllFields");
                    StaticSQLGenUtil.persistFlush(this.em, entity, this._logs);
                    break;
                }
                case 2: {
                    this.metaRepo.setRuntimeSignature(entityClassName + ":refresh:setAllFields");
                    StaticSQLGenUtil.refreshFlush(this.em, entity, this._logs);
                }
            }
        }
    }

    private boolean invoke1Setter(Object entity, Method setter, Map manyRelationMap, Map oneRelationMap, boolean isPCSet) {
        Class<?>[] parms = setter.getParameterTypes();
        String methodName = setter.getName();
        Object parmObj = null;
        Class<?> parmClass = null;
        parmClass = isPCSet ? parms[1] : parms[0];
        if (this._logs.isTraceEnabled()) {
            this._logs.trace(_loc.get("invoke-method", methodName));
            this._logs.trace(_loc.get("parm-type", parmClass.getName()));
        }
        if (parmClass.isPrimitive()) {
            parmObj = StaticSQLGenUtil.makePrimitiveParmObj(parmClass.getName(), "1");
            try {
                if (isPCSet) {
                    setter.invoke(null, entity, parmObj);
                } else {
                    setter.invoke(entity, parmObj);
                }
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(this._logs, e);
                return false;
            }
            return true;
        }
        if (manyRelationMap != null && (parmObj = manyRelationMap.get(methodName)) != null) {
            if (this._logs.isTraceEnabled()) {
                this._logs.trace(_loc.get("to-many-relation"));
            }
            try {
                setter.invoke(null, entity, parmObj);
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(this._logs, e);
                return false;
            }
            return true;
        }
        if (oneRelationMap != null && parmClass.isInstance(parmObj = oneRelationMap.get(methodName))) {
            if (this._logs.isTraceEnabled()) {
                this._logs.trace(_loc.get("to-one-relation"));
            }
            try {
                setter.invoke(null, entity, parmObj);
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(this._logs, e);
                return false;
            }
            return true;
        }
        int modifiers = parmClass.getModifiers();
        boolean isAbstract = Modifier.isAbstract(modifiers);
        boolean isInterface = Modifier.isInterface(modifiers);
        if (isAbstract || isInterface) {
            if (this._logs.isTraceEnabled()) {
                this._logs.trace(_loc.get("interface-parm"));
            }
            return false;
        }
        if (parmClass.isEnum()) {
            parmObj = parmClass.getEnumConstants()[0];
            if (this._logs.isTraceEnabled()) {
                this._logs.trace(_loc.get("enum-parm", parmObj.getClass().getName()));
            }
        } else {
            try {
                parmObj = StaticSQLGenUtil.constructObjFromClass(parmClass, this._logs);
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(this._logs, e);
                return false;
            }
            for (int i = 0; i < this.clms.length; ++i) {
                ClassMapping clm = this.clms[i];
                if (!clm.getDescribedType().isInstance(parmObj) || clm.isEmbeddedOnly()) continue;
                if (this._logs.isTraceEnabled()) {
                    this._logs.trace(_loc.get("unmanaged-entity", parmObj.getClass().getName()));
                }
                return false;
            }
            if (parmObj.getClass() != entity.getClass()) {
                StaticSQLGenUtil.invokeSetters(entity, parmObj, this._logs);
            }
        }
        try {
            if (isPCSet) {
                setter.invoke(null, entity, parmObj);
            } else {
                setter.invoke(entity, parmObj);
            }
        }
        catch (Exception e) {
            StaticSQLGenUtil.printException(this._logs, e);
            return false;
        }
        return true;
    }

    private void generateMergeStmt() {
        this.generateUpdateStmt(3, 2);
        this.em.clear();
        for (Object entity : this.entities) {
            String entityClassName = entity.getClass().getName();
            if (!this.bindInfo.singlePackage) {
                this.metaRepo.setPkgName(entityClassName);
            }
            this.metaRepo.setRuntimeSignature(entityClassName + ":merge");
            if (StaticSQLGenUtil.merge(this.em, entity, this._logs)) continue;
        }
    }
}

