/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.gen;

import com.ibm.pdq.runtime.internal.xml.PDQXmlRSColumn;
import com.ibm.websphere.persistence.RowChangeTimestampStrategy;
import com.ibm.websphere.persistence.RowChangeVersionStrategy;
import com.ibm.ws.persistence.pdqstatic.jdbc.meta.StaticMappingRepository;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.FieldStrategy;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.LobFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.NanoPrecisionTimestampVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.NumberVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.StringFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.SuperclassVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.TimestampVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.XMLValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.TimestampHelper;
import org.apache.openjpa.meta.FieldMetaData;

public class StaticSQLGenUtil {
    private static final Localizer _loc = Localizer.forPackage(StaticSQLGenUtil.class);
    public static int PACKAGE_NAME_LENGTH = 7;
    public static final int PERSIST_FLUSH = 1;
    public static final int REFRESH_FLUSH = 2;
    public static final int NO_FLUSH_NO_REFRESH = 3;
    public static final int TO_LOCK_READ = 1;
    public static final int TO_LOCK_WRITE = 2;
    public static final int TO_LOCK_NONE = 3;

    public static Object makePrimitiveParmObj(String parmClassName, String val) {
        Constable parmObj = null;
        if (parmClassName.equals("int")) {
            parmObj = new Integer(val);
        } else if (parmClassName.equals("double")) {
            parmObj = new Double(val);
        } else if (parmClassName.equals("boolean")) {
            parmObj = new Boolean(true);
        } else if (parmClassName.equals("short")) {
            parmObj = new Short(val);
        } else if (parmClassName.equals("long")) {
            parmObj = new Long(val);
        } else if (parmClassName.equals("float")) {
            parmObj = new Float(val);
        } else if (parmClassName.equals("byte")) {
            parmObj = new Byte(val);
        } else if (parmClassName.equals("char")) {
            parmObj = new Character(val.charAt(0));
        }
        return parmObj;
    }

    public static void invokeSetters(Object caller, Object obj, Log _logs) {
        Class<?> cls = obj.getClass();
        String className = cls.getName();
        Method[] methods = cls.getDeclaredMethods();
        for (int j = 0; j < methods.length; ++j) {
            Class<?>[] parms;
            String methodName = methods[j].getName();
            if (!methodName.startsWith("set") || (parms = methods[j].getParameterTypes()).length != 1) continue;
            if (_logs.isTraceEnabled()) {
                _logs.trace(_loc.get("invoke-method", className + "." + methodName));
            }
            StaticSQLGenUtil.invoke1setter(caller, obj, methods[j], _logs);
        }
    }

    public static void invoke1setter(Object caller, Object obj, Method setter, Log _logs) {
        Class<?>[] parms = setter.getParameterTypes();
        String methodName = setter.getName();
        Object parmObj = null;
        if (parms.length != 1) {
            return;
        }
        if (parms[0].equals(caller.getClass())) {
            parmObj = caller;
            try {
                setter.invoke(obj, parmObj);
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(_logs, e);
                return;
            }
            return;
        }
        if (_logs.isTraceEnabled()) {
            _logs.trace(_loc.get("parm-type", parms[0].getName()));
        }
        if (parms[0].isPrimitive()) {
            parmObj = StaticSQLGenUtil.makePrimitiveParmObj(parms[0].getName(), "1");
            try {
                setter.invoke(obj, parmObj);
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(_logs, e);
                return;
            }
            return;
        }
        int modifiers = parms[0].getModifiers();
        boolean isAbstract = Modifier.isAbstract(modifiers);
        boolean isInterface = Modifier.isInterface(modifiers);
        if (isAbstract || isInterface) {
            if (_logs.isTraceEnabled()) {
                _logs.trace(_loc.get("interface-parm"));
            }
            return;
        }
        if (parms[0].isEnum()) {
            if (_logs.isTraceEnabled()) {
                _logs.trace(_loc.get("enum-parm", parms[0]));
            }
            parmObj = parms[0].getEnumConstants()[0];
        } else {
            try {
                parmObj = StaticSQLGenUtil.constructObjFromClass(parms[0], _logs);
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(_logs, e);
                return;
            }
            if (parmObj.getClass() != obj.getClass()) {
                caller = obj;
                StaticSQLGenUtil.invokeSetters(caller, parmObj, _logs);
            }
        }
        try {
            setter.invoke(obj, parmObj);
        }
        catch (Exception e) {
            StaticSQLGenUtil.printException(_logs, e);
            return;
        }
    }

    public static boolean isSuperClass(Class cls, String superClassName) {
        Class _cls = cls.getSuperclass();
        boolean found = false;
        do {
            if (_cls == null || !_cls.getName().equals(superClassName)) continue;
            found = true;
            break;
        } while ((_cls = _cls.getSuperclass()) != null);
        return found;
    }

    public static void findUpdatableFields(ClassMapping[] clms, Map updatableFieldsMap, Map pkSettersMap) {
        for (int i = 0; i < clms.length; ++i) {
            if (clms[i].isEmbeddedOnly()) continue;
            Class cls = clms[i].getDescribedType();
            String entityClassName = cls.getName();
            int modifiers = cls.getModifiers();
            boolean isAbstract = Modifier.isAbstract(modifiers);
            boolean isInterface = Modifier.isInterface(modifiers);
            if (isAbstract || isInterface) continue;
            FieldMapping[] allPKFields = (FieldMapping[])clms[i].getPrimaryKeyFields();
            FieldMetaData[] definedFields = clms[i].getFields();
            StaticSQLGenUtil.findUpdatableFields(entityClassName, definedFields, allPKFields, updatableFieldsMap, pkSettersMap);
        }
    }

    public static void findUpdatableFields(String entityClassName, FieldMetaData[] allFields, FieldMapping[] allPKFields, Map updatableFieldsMap, Map pkSettersMap) {
        int k;
        HashMap<String, FieldMapping> pkSetters = new HashMap<String, FieldMapping>();
        ArrayList<FieldMetaData> fieldsToUpdate = new ArrayList<FieldMetaData>();
        for (k = 0; k < allFields.length; ++k) {
            fieldsToUpdate.add(allFields[k]);
        }
        for (k = 0; k < allPKFields.length; ++k) {
            if (fieldsToUpdate != null) {
                fieldsToUpdate.remove(allPKFields[k]);
            }
            String pkSetter = "pcSet" + allPKFields[k].getName();
            pkSetters.put(pkSetter, allPKFields[k]);
        }
        updatableFieldsMap.put(entityClassName, fieldsToUpdate);
        pkSettersMap.put(entityClassName, pkSetters);
    }

    public static void setFetchModeForAllEntities(FetchType fetchType, int fetchMode, ClassMapping[] clms, Map updatableFieldsMap, Map pkSettersMap) {
        if (updatableFieldsMap.size() == 0) {
            StaticSQLGenUtil.findUpdatableFields(clms, updatableFieldsMap, pkSettersMap);
        }
        Collection coll = updatableFieldsMap.values();
        for (List fieldsToUpdate : coll) {
            for (FieldMapping fm : fieldsToUpdate) {
                fm.setInDefaultFetchGroup(fetchType == FetchType.EAGER);
                fm.setEagerFetchMode(fetchMode);
            }
        }
    }

    public static Object createPrimaryKeyObject(FieldMapping pkField, Log _logs) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ParseException {
        ValueMapping pkVal = (ValueMapping)pkField.getValue();
        Class pkType = pkVal.getDeclaredType();
        return StaticSQLGenUtil.constructObjFromClass(pkType, _logs);
    }

    public static Object constructArrayObj(Class cls, Log _logs) throws InstantiationException, InvocationTargetException, IllegalAccessException, ParseException {
        Class<?> elementType = cls.getComponentType();
        String elementTypeName = elementType.getName();
        if (_logs.isTraceEnabled()) {
            _logs.trace(_loc.get("isArray", cls.getName(), elementTypeName));
        }
        if (!elementType.isPrimitive()) {
            if (elementTypeName.equals("java.lang.Character")) {
                return new Character[]{new Character('1')};
            }
            Object arr = Array.newInstance(cls, 1);
            Object element = StaticSQLGenUtil.constructObjFromClass(elementType, _logs);
            Array.set(arr, 0, element);
            return arr;
        }
        if (elementTypeName.equals("int")) {
            return new int[]{1};
        }
        if (elementTypeName.equals("double")) {
            return new double[]{1.0};
        }
        if (elementTypeName.equals("boolean")) {
            return new boolean[]{true};
        }
        if (elementTypeName.equals("short")) {
            return new short[]{1};
        }
        if (elementTypeName.equals("long")) {
            return new long[]{1L};
        }
        if (elementTypeName.equals("float")) {
            return new float[]{1.0f};
        }
        if (elementTypeName.equals("byte")) {
            return "1".getBytes();
        }
        if (elementTypeName.equals("char")) {
            return "1".toCharArray();
        }
        return null;
    }

    public static Object constructObjFromClass(Class cls, Log _logs) throws InstantiationException, InvocationTargetException, IllegalAccessException, ParseException {
        boolean found = false;
        if (cls.isPrimitive()) {
            return StaticSQLGenUtil.makePrimitiveParmObj(cls.getName(), "1");
        }
        String className = cls.getName();
        if (className.equals("java.util.Calendar")) {
            return Calendar.getInstance();
        }
        if (cls.isArray()) {
            return StaticSQLGenUtil.constructArrayObj(cls, _logs);
        }
        int modifiers = cls.getModifiers();
        boolean isAbstract = Modifier.isAbstract(modifiers);
        boolean isInterface = Modifier.isInterface(modifiers);
        if (isAbstract || isInterface) {
            return null;
        }
        if (cls.isEnum()) {
            return cls.getEnumConstants()[0];
        }
        if (cls.getName().equals("java.util.Date")) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            return df.parse("2001-01-01");
        }
        if (className.startsWith("java.lang.String") || className.startsWith("java.lang.Object")) {
            return "1";
        }
        try {
            Constructor cnstr = cls.getConstructor(String.class);
            return cnstr.newInstance("1");
        }
        catch (Exception e) {
            StaticSQLGenUtil.printException(_logs, e);
            Constructor<?>[] constructors = cls.getConstructors();
            for (int j = 0; j < constructors.length; ++j) {
                Class<?>[] parmClasses = constructors[j].getParameterTypes();
                if (parmClasses.length == 0) continue;
                Object[] parmObjs = new Object[parmClasses.length];
                for (int k = 0; k < parmClasses.length; ++k) {
                    int modifiers1 = parmClasses[k].getModifiers();
                    boolean isAbstract1 = Modifier.isAbstract(modifiers1);
                    boolean isInterface1 = Modifier.isInterface(modifiers1);
                    if (isAbstract || isInterface) continue;
                    found = true;
                    if (_logs.isTraceEnabled()) {
                        _logs.trace("parmClasses = " + parmClasses[k].getName());
                    }
                    if (parmClasses[k].getName().equals("java.lang.String")) {
                        parmObjs[k] = "1";
                        continue;
                    }
                    if (parmClasses[k].isPrimitive()) {
                        String parmClassName = parmClasses[k].getName();
                        parmObjs[k] = StaticSQLGenUtil.makePrimitiveParmObj(parmClassName, "1");
                        continue;
                    }
                    if (parmClasses[k].isEnum()) {
                        parmObjs[k] = parmClasses[k].getEnumConstants()[0];
                        continue;
                    }
                    try {
                        parmObjs[k] = parmClasses[k].newInstance();
                        continue;
                    }
                    catch (Exception e2) {
                        StaticSQLGenUtil.printException(_logs, e2);
                        found = false;
                        break;
                    }
                }
                if (!found) continue;
                if (_logs.isTraceEnabled()) {
                    for (int i = 0; i < parmObjs.length; ++i) {
                        _logs.trace("parm = " + parmObjs[i]);
                    }
                }
                return constructors[j].newInstance(parmObjs);
            }
            return cls.newInstance();
        }
    }

    public static FieldMapping isUpdatable(String methodName, List fieldsToUpdate) {
        for (FieldMapping fm : fieldsToUpdate) {
            String fieldName = "";
            if (methodName.startsWith("pcSet") || methodName.startsWith("pcGet")) {
                fieldName = methodName.substring(5);
            } else if (methodName.startsWith("set") || methodName.startsWith("get")) {
                fieldName = methodName.substring(3);
            } else {
                return null;
            }
            if (!fm.getName().equalsIgnoreCase(fieldName)) continue;
            return fm;
        }
        return null;
    }

    public static boolean isLob(String methodName, List fieldsToUpdate) {
        for (FieldMapping fm : fieldsToUpdate) {
            FieldStrategy strat;
            if (!fm.getName().equalsIgnoreCase(methodName.substring(5)) || !((strat = fm.getStrategy()) instanceof LobFieldStrategy) && !(strat instanceof XMLValueHandler)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRelationSetter(String methodName, Map manyRelationMap, Map oneRelationMap) {
        return manyRelationMap.get(methodName) != null || oneRelationMap.get(methodName) != null;
    }

    public static void setPrimaryKey(FieldMapping[] allPKFields, Object entity, Log _logs) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ParseException {
        for (int i = 0; i < allPKFields.length; ++i) {
            String pkSetterName;
            Method pkMethod;
            if (allPKFields[i].getValueStrategy() != 0) continue;
            Class<?> entityCls = entity.getClass();
            Object pkObj = StaticSQLGenUtil.createPrimaryKeyObject(allPKFields[i], _logs);
            if (pkObj == null || (pkMethod = StaticSQLGenUtil.findMethod(pkSetterName = "pcSet" + allPKFields[i].getName(), entity.getClass())) == null) continue;
            pkMethod.setAccessible(true);
            pkMethod.invoke(null, entity, pkObj);
        }
    }

    public static Map createPrimaryKeys(ClassMapping[] clms, Log _logs) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ParseException {
        HashMap<Class, Object> pkObjectMap = new HashMap<Class, Object>();
        for (int i = 0; i < clms.length; ++i) {
            if (clms[i].isEmbeddedOnly()) continue;
            Class cls = clms[i].getDescribedType();
            String entityClassName = cls.getName();
            int modifiers = cls.getModifiers();
            boolean isAbstract = Modifier.isAbstract(modifiers);
            boolean isInterface = Modifier.isInterface(modifiers);
            if (isAbstract || isInterface) continue;
            FieldMapping[] allPKFields = (FieldMapping[])clms[i].getPrimaryKeyFields();
            Object pkObj = StaticSQLGenUtil.createPrimaryKeyObject(allPKFields[i], _logs);
            pkObjectMap.put(cls, pkObj);
        }
        return pkObjectMap;
    }

    public static Object getPrimaryKeyObj(ClassMapping clm, Log _logs) throws InstantiationException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, ParseException {
        FieldMapping[] fm = clm.getPrimaryKeyFieldMappings();
        if (fm.length > 1) {
            return null;
        }
        return StaticSQLGenUtil.createPrimaryKeyObject(fm[0], _logs);
    }

    public static void constructCollectionParm(String entityClassName, Map relationMap, List fieldsToUpdate, Map clm2entityMap, Log _logs) {
        for (FieldMapping fm : fieldsToUpdate) {
            ValueMapping elem = (ValueMapping)fm.getElement();
            ClassMapping decTypeMapping = elem.getDeclaredTypeMapping();
            Object entity1 = clm2entityMap.get(decTypeMapping);
            if (entity1 == null) continue;
            String setter = "pcSet" + fm.getName();
            Class proxyType = fm.getProxyType();
            ArrayList proxyObj = null;
            if (proxyType != null && proxyType.getName().equals("java.util.Collection")) {
                proxyObj = new ArrayList();
                continue;
            }
            try {
                proxyObj = (ArrayList)proxyType.newInstance();
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(_logs, e);
                continue;
            }
            if (!(proxyObj instanceof Collection)) continue;
            ((Collection)proxyObj).add(entity1);
            relationMap.put(setter, proxyObj);
        }
    }

    public static void collectEntityParm(String entityClassName, Map oneRelationMap, List fieldsToUpdate, Map clm2entityMap, Map cls2entityMap) {
        for (FieldMapping fm : fieldsToUpdate) {
            ValueMapping val = (ValueMapping)fm.getValue();
            ClassMapping decTypeMapping = val.getDeclaredTypeMapping();
            Object entity = null;
            if (decTypeMapping != null) {
                Class decType = decTypeMapping.getDescribedType();
                if (decType.isInterface()) {
                    Class implClass = decTypeMapping.getInterfaceImpl();
                    entity = cls2entityMap.get(implClass);
                } else {
                    int modifiers = decType.getModifiers();
                    entity = Modifier.isAbstract(modifiers) ? StaticSQLGenUtil.findObjForConcreteSubClass(decType.getName(), clm2entityMap) : (Object)clm2entityMap.get(decTypeMapping);
                }
            }
            if (entity == null) continue;
            String setter = "pcSet" + fm.getName();
            oneRelationMap.put(setter, entity);
        }
    }

    public static Object findObjForConcreteSubClass(String superClassName, Map clsMap) {
        Set keys = clsMap.keySet();
        for (ClassMapping key : keys) {
            if (!StaticSQLGenUtil.isSuperClass(key.getDescribedType(), superClassName)) continue;
            return clsMap.get(key);
        }
        return null;
    }

    public static ClassMapping getClassMapping(Object entity, ClassMapping[] clms) {
        for (int i = 0; i < clms.length; ++i) {
            if (!clms[i].getDescribedType().equals(entity.getClass())) continue;
            return clms[i];
        }
        return null;
    }

    public static Map getClm2EntitiesMap(Collection entities, ClassMapping[] clms) {
        HashMap clm2entityMap = new HashMap();
        for (Object entity : entities) {
            ClassMapping clm = StaticSQLGenUtil.getClassMapping(entity, clms);
            clm2entityMap.put(clm, entity);
        }
        return clm2entityMap;
    }

    public static Map getCls2EntitiesMap(Collection entities) {
        HashMap cls2entityMap = new HashMap();
        for (Object entity : entities) {
            cls2entityMap.put(entity.getClass(), entity);
        }
        return cls2entityMap;
    }

    public static void commit(EntityManager em, Log _logs) {
        try {
            em.getTransaction().commit();
        }
        catch (Exception e) {
            StaticSQLGenUtil.printException(_logs, e);
        }
    }

    public static void rollback(EntityManager em, Log _logs) {
        try {
            em.getTransaction().rollback();
        }
        catch (Exception e) {
            StaticSQLGenUtil.printException(_logs, e);
        }
    }

    public static boolean persistFlush(EntityManager em, Object entity, Log _logs) {
        try {
            em.persist(entity);
            em.flush();
            return true;
        }
        catch (Exception e) {
            StaticSQLGenUtil.printException(_logs, e);
            return false;
        }
    }

    public static boolean persist(EntityManager em, Object entity, Log _logs) {
        try {
            em.persist(entity);
            return true;
        }
        catch (Exception e) {
            StaticSQLGenUtil.printException(_logs, e);
            return false;
        }
    }

    public static boolean removeFlush(EntityManager em, Object entity, Log _logs) {
        try {
            em.remove(entity);
            em.flush();
            return true;
        }
        catch (Exception e) {
            StaticSQLGenUtil.printException(_logs, e);
            return false;
        }
    }

    public static boolean refreshFlush(EntityManager em, Object entity, Log _logs) {
        try {
            em.refresh(entity);
            em.flush();
            return true;
        }
        catch (Exception e) {
            StaticSQLGenUtil.printException(_logs, e);
            return false;
        }
    }

    public static boolean merge(EntityManager em, Object entity, Log _logs) {
        try {
            em.merge(entity);
            return true;
        }
        catch (Exception e) {
            StaticSQLGenUtil.printException(_logs, e);
            return false;
        }
    }

    public static void flush(EntityManager em, Log _logs) {
        try {
            em.flush();
        }
        catch (Exception e) {
            StaticSQLGenUtil.printException(_logs, e);
        }
    }

    public static boolean isPKSetter(Map pkSetters, String methodName) {
        Set keys = pkSetters.keySet();
        for (String pkSetterName : keys) {
            if (!pkSetterName.equalsIgnoreCase(methodName)) continue;
            return true;
        }
        return false;
    }

    public static boolean setNonNullableFields(FieldMetaData[] fields, Object entity, Log _logs) {
        Method[] methods = entity.getClass().getMethods();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getNullValue() != 2) continue;
            Method setter = StaticSQLGenUtil.findSetter(fields[i].getName(), methods);
            if (setter == null) {
                return false;
            }
            Class<?>[] parm = setter.getParameterTypes();
            if (parm.length > 1) {
                return false;
            }
            Object parmObj = null;
            try {
                parmObj = StaticSQLGenUtil.constructObjFromClass(parm[0], _logs);
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(_logs, e);
                return false;
            }
            try {
                setter.invoke(entity, parmObj);
                continue;
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(_logs, e);
                return false;
            }
        }
        return true;
    }

    public static boolean setNonNullableFields(Object entity, FieldMetaData[] fields, List managedEntities, Log _logs) {
        Method[] methods = entity.getClass().getMethods();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getNullValue() != 2) continue;
            Method setter = StaticSQLGenUtil.findSetter(fields[i].getName(), methods);
            if (setter == null) {
                return false;
            }
            Class<?>[] parm = setter.getParameterTypes();
            if (parm.length > 1) {
                return false;
            }
            Object parmObj = null;
            try {
                parmObj = StaticSQLGenUtil.findManagedEntityAsParm(entity, parm[0], managedEntities);
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(_logs, e);
                return false;
            }
            try {
                if (parmObj == null) continue;
                setter.invoke(entity, parmObj);
                continue;
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(_logs, e);
                return false;
            }
        }
        return true;
    }

    public static Method findSetter(String fieldName, Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (!methodName.startsWith("set") || !methodName.substring(3).equalsIgnoreCase(fieldName)) continue;
            return methods[i];
        }
        return null;
    }

    public static Object findManagedEntityAsParm(Object entity, Class parmClass, List managedEntities) {
        for (Object managedEntity : managedEntities) {
            if (managedEntity.getClass() != parmClass) continue;
            return managedEntity;
        }
        return null;
    }

    public static void setVersion(ClassMapping clm, Object entity, Log _logs) {
        StateManager stateMgr = ((PersistenceCapable)entity).pcGetStateManager();
        if (stateMgr instanceof StateManagerImpl) {
            StateManagerImpl stateMgrImp = (StateManagerImpl)stateMgr;
            VersionStrategy versionStrat = clm.getVersion().getStrategy();
            if (versionStrat instanceof NumberVersionStrategy) {
                stateMgrImp.setVersion(new Integer(1));
            } else if (versionStrat instanceof TimestampVersionStrategy) {
                stateMgrImp.setVersion(new Timestamp(System.currentTimeMillis()));
            } else if (versionStrat instanceof NanoPrecisionTimestampVersionStrategy) {
                stateMgrImp.setVersion(TimestampHelper.getNanoPrecisionTimestamp());
            } else if (versionStrat instanceof SuperclassVersionStrategy) {
                StaticSQLGenUtil.setVersion(clm.getPCSuperclassMapping(), entity, _logs);
            } else if (versionStrat instanceof RowChangeTimestampStrategy) {
                stateMgrImp.setVersion(TimestampHelper.getNanoPrecisionTimestamp());
            } else if (versionStrat instanceof RowChangeVersionStrategy) {
                stateMgrImp.setVersion(new Long(1L));
            } else if (_logs.isTraceEnabled()) {
                _logs.trace(_loc.get("verion-strategy", versionStrat));
            }
        }
    }

    public static Method findMethod(String methodName, Class cls) {
        Method[] methods = cls.getDeclaredMethods();
        for (int j = 0; j < methods.length; ++j) {
            if (!methods[j].getName().equals(methodName)) continue;
            return methods[j];
        }
        return null;
    }

    public static String findExtString(FieldMapping fm) {
        String extStr = null;
        String _extString = fm.getExternalValues();
        if (_extString == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(_extString, ",");
        if (st.hasMoreTokens()) {
            extStr = st.nextToken();
            extStr = extStr.substring(0, extStr.indexOf("="));
        }
        return extStr;
    }

    public static void setExternalStringFields(FieldMapping[] fields, Object entity, Log _logs) {
        for (int i = 0; i < fields.length; ++i) {
            String extStr = StaticSQLGenUtil.findExtString(fields[i]);
            if (extStr == null) continue;
            Object extStrObj = null;
            extStrObj = fields[i].getStrategy() instanceof StringFieldStrategy ? extStr : StaticSQLGenUtil.makePrimitiveParmObj(fields[i].getDeclaredType().getName(), extStr);
            String pcSetterName = "pcSet" + fields[i].getName();
            Method pcSetter = null;
            try {
                Method[] m = entity.getClass().getDeclaredMethods();
                for (int j = 0; j < m.length; ++j) {
                    if (!m[j].getName().equals(pcSetterName)) continue;
                    pcSetter = m[j];
                    break;
                }
                if (pcSetter == null) continue;
                pcSetter.setAccessible(true);
                pcSetter.invoke(null, entity, extStrObj);
                continue;
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(_logs, e);
            }
        }
    }

    public static void getMethods(Object entity, List pcSetMethods, List setMethods, boolean isGet, List fieldsToUpdate) {
        HashMap<String, String> pcSetters = new HashMap<String, String>();
        ArrayList<Method> temp = new ArrayList<Method>();
        List methods = StaticSQLGenUtil.getAllMethods(entity);
        for (Method method : methods) {
            String methodName = method.getName();
            String fieldName = null;
            if (isGet && methodName.startsWith("pcGet") || !isGet && methodName.startsWith("pcSet")) {
                fieldName = methodName.substring(5);
                if (StaticSQLGenUtil.isUpdatable(methodName, fieldsToUpdate) == null || fieldName.equalsIgnoreCase("version")) continue;
                pcSetMethods.add(method);
                pcSetters.put(StaticSQLGenUtil.capitalize(fieldName), fieldName);
                continue;
            }
            if ((!isGet || !methodName.startsWith("get")) && (isGet || !methodName.startsWith("set"))) continue;
            fieldName = methodName.substring(3);
            if (StaticSQLGenUtil.isUpdatable(methodName, fieldsToUpdate) == null || fieldName.equalsIgnoreCase("version")) continue;
            temp.add(method);
        }
        for (Method setter : temp) {
            String fieldName = setter.getName().substring(3);
            if (pcSetters.get(fieldName) != null) continue;
            setMethods.add(setter);
        }
    }

    public static List getAllMethods(Object entity) {
        int i;
        Method[] methods1 = entity.getClass().getMethods();
        Method[] methods2 = entity.getClass().getDeclaredMethods();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (i = 0; i < methods1.length; ++i) {
            methods.add(methods1[i]);
        }
        for (i = 0; i < methods2.length; ++i) {
            if (StaticSQLGenUtil.exists(methods2[i], methods1)) continue;
            methods.add(methods2[i]);
        }
        return methods;
    }

    public static boolean exists(Method m, Method[] ms) {
        for (int i = 0; i < ms.length; ++i) {
            if (!m.equals(ms[i])) continue;
            return true;
        }
        return false;
    }

    public static String capitalize(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static void printException(Log _logs, Exception ex) {
        if (_logs.isWarnEnabled()) {
            _logs.warn(ex);
            Throwable t = ex.getCause();
            if (t != null) {
                _logs.warn(t);
            }
        }
    }

    public static void setLoad(OpenJPAStateManager sm, ClassMapping mapping, List columns) {
        FieldMapping[] fields = mapping.getDefinedFieldMappings();
        for (int i = 0; i < fields.length; ++i) {
            ValueMapping val = fields[i].getValueMapping();
            Column[] cols = val.getColumns();
            for (int j = 0; j < cols.length; ++j) {
                if (!StaticSQLGenUtil.exists(cols[j].getName(), columns)) continue;
                try {
                    Method setLoaded = StateManagerImpl.class.getDeclaredMethod("setLoaded", Integer.TYPE, Boolean.TYPE);
                    setLoaded.setAccessible(true);
                    setLoaded.invoke((Object)sm, i, true);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean exists(String colName, List columns) {
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            if (!((PDQXmlRSColumn)iter.next()).getColumnName().equalsIgnoreCase(colName)) continue;
            return true;
        }
        return false;
    }

    public static int executeUpdate(PreparedStatement stmnt, String sql2, int opcode, JDBCConfiguration conf) throws SQLException {
        StaticMappingRepository metaRepo = (StaticMappingRepository)conf.getMetaDataRepositoryInstance();
        metaRepo.createPDQMeta(sql2, stmnt, opcode);
        return 1;
    }

    public static ResultSet executeQuery(PreparedStatement stmnt, String sql2, JDBCConfiguration conf) throws SQLException {
        StaticMappingRepository metaRepo = (StaticMappingRepository)conf.getMetaDataRepositoryInstance();
        metaRepo.createPDQMeta(sql2, stmnt, -1);
        return null;
    }

    public static void getSubclassMapping(List subs, ClassMapping mapping) {
        ClassMapping[] subclasses = mapping.getPCSubclassMappings();
        if (subclasses == null) {
            return;
        }
        for (int i = 0; i < subclasses.length; ++i) {
            Class type = subclasses[i].getDescribedType();
            int modifiers = type.getModifiers();
            boolean isAbstract = Modifier.isAbstract(modifiers);
            boolean isInterface = Modifier.isInterface(modifiers);
            if (!isAbstract && !isInterface) {
                subs.add(subclasses[i]);
            }
            StaticSQLGenUtil.getSubclassMapping(subs, subclasses[i]);
        }
    }
}

