/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.kernel.conf;

import com.ibm.websphere.persistence.WsJpaTaskNameManager;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;

public class WsJpaTaskNameManagerImpl
implements WsJpaTaskNameManager {
    private static final Localizer _loc = Localizer.forPackage(WsJpaTaskNameManagerImpl.class);
    private WsJpaJDBCConfiguration config = null;
    private static TaskState state = TaskState.Uninitialized;
    private static Object uowSyncRegistry = null;
    private static Method getResourceMethod = null;
    private static Method putResourceMethod = null;

    public WsJpaTaskNameManagerImpl() {
    }

    public WsJpaTaskNameManagerImpl(WsJpaJDBCConfiguration config) {
        this.config = config;
    }

    private Log getLog() {
        Log rtnLog = null;
        if (this.config != null) {
            rtnLog = this.config.getLog("openjpa.Runtime");
        }
        return rtnLog;
    }

    private final boolean isUowSRAvailable() {
        if (state == TaskState.Uninitialized) {
            Log log = this.getLog();
            try {
                InitialContext ic = new InitialContext();
                uowSyncRegistry = ic.lookup("java:comp/websphere/UOWSynchronizationRegistry");
                Class<?> uowSr = Class.forName("com.ibm.websphere.uow.UOWSynchronizationRegistry");
                getResourceMethod = uowSr.getMethod("getResource", Object.class);
                putResourceMethod = uowSr.getMethod("putResource", Object.class, Object.class);
                if (log != null && log.isInfoEnabled()) {
                    log.info(_loc.get("access-intent-task-initialzed"));
                }
                state = TaskState.Available;
            }
            catch (Throwable e) {
                if (log != null && log.isInfoEnabled()) {
                    log.info(_loc.get("unable-to-obtain-uow-sync-registry", e.getMessage()));
                }
                state = TaskState.Unavailable;
            }
        }
        return state == TaskState.Available;
    }

    public String getTSRTaskName() {
        String taskName;
        block5: {
            taskName = null;
            if (this.isUowSRAvailable()) {
                Log log = this.getLog();
                try {
                    Object taskObject = getResourceMethod.invoke(uowSyncRegistry, "com.ibm.websphere.profile");
                    if (taskObject instanceof String) {
                        taskName = (String)taskObject;
                        if (log != null && log.isTraceEnabled()) {
                            log.trace(_loc.get("get-taskname", taskName));
                        }
                    }
                }
                catch (Throwable e) {
                    if (log == null || !log.isTraceEnabled()) break block5;
                    log.trace(_loc.get("cant-get-taskname"));
                }
            }
        }
        return taskName;
    }

    public boolean setTSRTaskName(String taskName) {
        boolean rtnValue;
        block4: {
            rtnValue = false;
            if (this.isUowSRAvailable()) {
                Log log = this.getLog();
                try {
                    putResourceMethod.invoke(uowSyncRegistry, "com.ibm.websphere.profile", taskName);
                    if (log != null && log.isTraceEnabled()) {
                        log.trace(_loc.get("put-taskname", taskName));
                    }
                    rtnValue = true;
                }
                catch (Throwable e) {
                    if (log == null || !log.isTraceEnabled()) break block4;
                    log.trace(_loc.get("cant-put-taskname", taskName));
                }
            }
        }
        return rtnValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TaskState {
        Uninitialized,
        Available,
        Unavailable;

    }
}

