/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.kernel;

import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfigurationImpl;
import com.ibm.ws.persistence.jdbc.kernel.WsJpaJDBCStoreManager;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCBrokerFactory;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;

public class WsJpaJDBCBrokerFactory
extends JDBCBrokerFactory {
    private static final long serialVersionUID = 1257416402258781723L;
    private static Class helper;
    private static Method configPdq;
    private static Method newPdqStoreManager;
    private static final Localizer _loc;

    public WsJpaJDBCBrokerFactory(JDBCConfiguration conf) {
        super(conf);
        Log log = conf.getLog("openjpa.Runtime");
        boolean runPDQ = false;
        Class<?> cls = null;
        try {
            cls = Class.forName("com.ibm.pdq.runtime.Data", false, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace(_loc.get("no-pdq-jar"));
            }
            ((WsJpaJDBCConfigurationImpl)conf).setRunPDQ(false);
        }
        if (cls != null) {
            if (log.isTraceEnabled()) {
                if (helper == null) {
                    log.trace(_loc.get("null-pdqconfig-helper"));
                }
                if (configPdq == null) {
                    log.trace(_loc.get("null-configPdq-method"));
                }
                if (newPdqStoreManager == null) {
                    log.trace(_loc.get("null-pdq-newstore-method"));
                }
                if (cls != null && helper != null && configPdq != null) {
                    log.trace(_loc.get("pdq-jar-loaded", cls.getName()));
                }
            }
            try {
                if (configPdq != null) {
                    runPDQ = (Boolean)configPdq.invoke(null, this);
                }
                ((WsJpaJDBCConfigurationImpl)conf).setRunPDQ(runPDQ);
            }
            catch (Exception e) {
                if (log.isTraceEnabled()) {
                    log.trace(_loc.get("pdq-exception", e.getStackTrace()));
                }
                ((WsJpaJDBCConfigurationImpl)conf).setRunPDQ(false);
            }
        }
    }

    public static WsJpaJDBCBrokerFactory newInstance(ConfigurationProvider cp) {
        WsJpaJDBCConfigurationImpl conf = new WsJpaJDBCConfigurationImpl();
        cp.setInto(conf);
        return new WsJpaJDBCBrokerFactory(conf);
    }

    public static WsJpaJDBCBrokerFactory getInstance(ConfigurationProvider cp) {
        Map props = cp.getProperties();
        Object key = WsJpaJDBCBrokerFactory.toPoolKey(props);
        WsJpaJDBCBrokerFactory factory = (WsJpaJDBCBrokerFactory)WsJpaJDBCBrokerFactory.getPooledFactoryForKey(key);
        if (factory != null) {
            return factory;
        }
        factory = WsJpaJDBCBrokerFactory.newInstance(cp);
        WsJpaJDBCBrokerFactory.pool(key, factory);
        return factory;
    }

    protected StoreManager newStoreManager() {
        WsJpaJDBCConfigurationImpl conf = (WsJpaJDBCConfigurationImpl)this.getConfiguration();
        if (conf.runPDQ()) {
            try {
                StoreManager mgr = (StoreManager)newPdqStoreManager.invoke(null, conf);
                conf.setRunPDQ(mgr != null);
                if (mgr != null) {
                    return mgr;
                }
            }
            catch (Exception e) {
                conf.setRunPDQ(false);
            }
        }
        return new WsJpaJDBCStoreManager();
    }

    static {
        _loc = Localizer.forPackage(WsJpaJDBCBrokerFactory.class);
        try {
            helper = Class.forName("com.ibm.ws.persistence.pdq.conf.PDQConfigurationHelper");
            configPdq = helper.getMethod("configurePdqPlugins", WsJpaJDBCBrokerFactory.class);
            newPdqStoreManager = helper.getMethod("newPdqStoreManager", JDBCConfiguration.class);
        }
        catch (Exception e) {
            System.err.println(_loc.get("pdqconfig-helper-exception", e.getStackTrace()));
        }
    }
}

