/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Reference;
import sun.misc.Cleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceQueue<T> {
    private Reference[] references = new Reference[128];
    private int head = 0;
    private int tail = 0;
    private boolean empty = true;
    private static final int DEFAULT_QUEUE_SIZE = 128;
    private static final Class reflectRefClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<? extends T> poll() {
        Reference ref;
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            if (this.empty) {
                return null;
            }
            ref = this.references[this.head];
            this.references[this.head++] = null;
            ref.dequeue();
            if (this.head == this.references.length) {
                this.head = 0;
            }
            if (this.head == this.tail) {
                this.empty = true;
            }
        }
        return ref;
    }

    public Reference<? extends T> remove() throws InterruptedException {
        return this.remove(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<? extends T> remove(long timeout) throws IllegalArgumentException, InterruptedException {
        Reference ref;
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            if (this.empty) {
                this.wait(timeout);
                if (this.empty) {
                    return null;
                }
            }
            ref = this.references[this.head];
            this.references[this.head++] = null;
            ref.dequeue();
            if (this.head == this.references.length) {
                this.head = 0;
            }
            if (this.head == this.tail) {
                this.empty = true;
            } else {
                this.notifyAll();
            }
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueue(Reference reference) {
        if (reference instanceof Cleaner) {
            reference.dequeue();
            ((Cleaner)reference).clean();
            return true;
        }
        if (reference.getClass() == reflectRefClass) {
            reference.dequeue();
            ((Runnable)((Object)reference)).run();
            return true;
        }
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            if (!this.empty && this.head == this.tail) {
                int newQueueSize = (int)((double)this.references.length * 1.1);
                Reference[] newQueue = new Reference[newQueueSize];
                System.arraycopy((Object)this.references, this.head, (Object)newQueue, 0, this.references.length - this.head);
                if (this.tail > 0) {
                    System.arraycopy((Object)this.references, 0, (Object)newQueue, this.references.length - this.head, this.tail);
                }
                this.head = 0;
                this.tail = this.references.length;
                this.references = newQueue;
            }
            this.references[this.tail++] = reference;
            if (this.tail == this.references.length) {
                this.tail = 0;
            }
            this.empty = false;
            this.notifyAll();
        }
        return true;
    }

    static {
        Class<Cleaner> cl = Cleaner.class;
        Class<?> tmpClass = null;
        try {
            tmpClass = Class.forName("java.lang.Class$ReflectRef");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        reflectRefClass = tmpClass;
    }
}

