/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.ReferenceQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Reference<T> {
    private T referent;
    private ReferenceQueue queue;
    private boolean enqueued;

    public void clear() {
        this.referent = null;
    }

    public boolean enqueue() {
        return this.enqueueImpl();
    }

    public T get() {
        return this.getImpl();
    }

    private native T getImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued() {
        Reference reference = this;
        synchronized (reference) {
            return this.enqueued;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueueImpl() {
        Reference reference = this;
        synchronized (reference) {
            ReferenceQueue tempQueue = this.queue;
            this.queue = null;
            if (this.enqueued || tempQueue == null) {
                return false;
            }
            boolean result = tempQueue.enqueue(this);
            if (result) {
                this.enqueued = true;
            }
            return result;
        }
    }

    Reference() {
    }

    void initReference(Object r) {
        this.initReferenceImpl(r);
    }

    void initReference(Object r, ReferenceQueue q) {
        this.queue = q;
        this.enqueued = false;
        this.initReferenceImpl(r);
    }

    private final native void initReferenceImpl(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dequeue() {
        Reference reference = this;
        synchronized (reference) {
            this.enqueued = false;
        }
    }
}

