/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.reflect.AnnotationHelper;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.repository.ClassRepository;
import sun.reflect.generics.scope.ClassScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Class<T>
implements Serializable,
GenericDeclaration,
Type,
AnnotatedElement {
    private static final long serialVersionUID = 3206093459760846163L;
    private static ProtectionDomain AllPermissionsPD;
    private static final int SYNTHETIC = 4096;
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;
    private static final int j9Version = 50463296;
    private static final long j9Config = 8314596479310233600L;
    private static final Class[] EmptyParameters;
    private long vmRef;
    private Object classLoader;
    private ProtectionDomain protectionDomain;
    private String classNameString;
    private static Method copyMethod;
    private static Method copyField;
    private static Method copyConstructor;
    private static Field methodParameterTypesField;
    private static Field constructorParameterTypesField;
    private static final Object[] NoArgs;
    private static final CacheKey PublicKey;
    private static final CacheKey DeclaredKey;
    static ReferenceQueue queue;

    private Class() {
    }

    private void checkMemberAccess(int type) {
        ClassLoader callerClassLoader;
        SecurityManager security = System.getSecurityManager();
        if (security != null && (callerClassLoader = ClassLoader.getStackClassLoader(2)) != ClassLoader.systemClassLoader) {
            security.checkMemberAccess(this, type);
            String packageName = this.getPackageName();
            ClassLoader loader = this.getClassLoaderImpl();
            if (packageName != "" && callerClassLoader != loader && !callerClassLoader.isAncestorOf(loader)) {
                security.checkPackageAccess(packageName);
            }
        }
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        ClassLoader defaultClassLoader = ClassLoader.callerClassLoader();
        return Class.forNameImpl(className, true, defaultClassLoader);
    }

    public static Class<?> forName(String className, boolean initializeBoolean, ClassLoader classLoader) throws ClassNotFoundException {
        SecurityManager security;
        ClassLoader callerClassLoader;
        if (null == classLoader && (callerClassLoader = ClassLoader.callerClassLoader()) != null && null != (security = System.getSecurityManager())) {
            security.checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        return Class.forNameImpl(className, initializeBoolean, classLoader);
    }

    private static native Class forNameImpl(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    public Class<?>[] getClasses() {
        Object[] classes;
        this.checkMemberAccess(0);
        Vector<Object> publicClasses = new Vector<Object>();
        for (Class<T> current = this; current != null; current = current.getSuperclass()) {
            classes = current.getDeclaredClassesImpl();
            for (int i = 0; i < classes.length; ++i) {
                if (!Modifier.isPublic(((Class)classes[i]).getModifiers())) continue;
                publicClasses.addElement(classes[i]);
            }
        }
        classes = new Class[publicClasses.size()];
        publicClasses.copyInto(classes);
        return classes;
    }

    public ClassLoader getClassLoader() {
        ClassLoader loader = this.getClassLoaderImpl();
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            if (loader == ClassLoader.systemClassLoader) {
                return null;
            }
            ClassLoader callersClassLoader = ClassLoader.callerClassLoader();
            if (callersClassLoader != null && callersClassLoader != loader && !callersClassLoader.isAncestorOf(loader)) {
                security.checkPermission(RuntimePermission.permissionToGetClassLoader);
            }
        }
        if (loader == ClassLoader.systemClassLoader) {
            return null;
        }
        return loader;
    }

    ClassLoader getClassLoaderImpl() {
        return J9VMInternals.getClassLoader(this);
    }

    public native Class<?> getComponentType();

    private void throwNoSuchMethodException(String name, Class[] types) throws NoSuchMethodException {
        StringBuffer error = new StringBuffer();
        error.append(this.getName()).append('.').append(name).append('(');
        if (types.length > 0) {
            error.append(types[0] == null ? null : types[0].getName());
            for (int i = 1; i < types.length; ++i) {
                error.append(", ").append(types[i] == null ? null : types[i].getName());
            }
        }
        error.append(')');
        throw new NoSuchMethodException(error.toString());
    }

    public Constructor<T> getConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0);
        Constructor cachedConstructor = this.lookupCachedConstructor(parameterTypes == null ? EmptyParameters : parameterTypes);
        if (cachedConstructor != null && Modifier.isPublic(cachedConstructor.getModifiers())) {
            return cachedConstructor;
        }
        if (parameterTypes == null || parameterTypes.length == 0) {
            Constructor rc = this.getConstructorImpl(EmptyParameters, "()V");
            if (rc == null) {
                this.throwNoSuchMethodException("<init>", EmptyParameters);
            }
            return this.cacheConstructor(rc);
        }
        int total = 3;
        String[] sigs = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] != null) {
                sigs[i] = super.getSignature();
                total += sigs[i].length();
                continue;
            }
            this.throwNoSuchMethodException("<init>", parameterTypes);
        }
        StringBuffer signature = new StringBuffer(total);
        signature.append('(');
        for (int i = 0; i < parameterTypes.length; ++i) {
            signature.append(sigs[i]);
        }
        signature.append(")V");
        Constructor rc = this.getConstructorImpl((Class[])parameterTypes.clone(), signature.toString());
        if (rc == null) {
            this.throwNoSuchMethodException("<init>", parameterTypes);
        }
        return this.cacheConstructor(rc);
    }

    private native Constructor getConstructorImpl(Class[] var1, String var2);

    public Constructor<?>[] getConstructors() throws SecurityException {
        this.checkMemberAccess(0);
        Constructor[] cachedConstructors = this.lookupCachedConstructors(PublicKey);
        if (cachedConstructors != null) {
            return cachedConstructors;
        }
        return this.cacheConstructors(this.getConstructorsImpl(), PublicKey);
    }

    private native Constructor[] getConstructorsImpl();

    public Class<?>[] getDeclaredClasses() throws SecurityException {
        this.checkMemberAccess(1);
        return this.getDeclaredClassesImpl();
    }

    private native Class[] getDeclaredClassesImpl();

    public Constructor<T> getDeclaredConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1);
        Constructor cachedConstructor = this.lookupCachedConstructor(parameterTypes == null ? EmptyParameters : parameterTypes);
        if (cachedConstructor != null) {
            return cachedConstructor;
        }
        if (parameterTypes == null || parameterTypes.length == 0) {
            Constructor rc = this.getDeclaredConstructorImpl(EmptyParameters, "()V");
            if (rc == null) {
                this.throwNoSuchMethodException("<init>", EmptyParameters);
            }
            return this.cacheConstructor(rc);
        }
        int total = 3;
        String[] sigs = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] != null) {
                sigs[i] = super.getSignature();
                total += sigs[i].length();
                continue;
            }
            this.throwNoSuchMethodException("<init>", parameterTypes);
        }
        StringBuffer signature = new StringBuffer(total);
        signature.append('(');
        for (int i = 0; i < parameterTypes.length; ++i) {
            signature.append(sigs[i]);
        }
        signature.append(")V");
        Constructor rc = this.getDeclaredConstructorImpl((Class[])parameterTypes.clone(), signature.toString());
        if (rc == null) {
            this.throwNoSuchMethodException("<init>", parameterTypes);
        }
        return this.cacheConstructor(rc);
    }

    private native Constructor getDeclaredConstructorImpl(Class[] var1, String var2);

    public Constructor<?>[] getDeclaredConstructors() throws SecurityException {
        this.checkMemberAccess(1);
        Constructor[] cachedConstructors = this.lookupCachedConstructors(DeclaredKey);
        if (cachedConstructors != null) {
            return cachedConstructors;
        }
        return this.cacheConstructors(this.getDeclaredConstructorsImpl(), DeclaredKey);
    }

    private native Constructor[] getDeclaredConstructorsImpl();

    public Field getDeclaredField(String name) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(1);
        Field cachedField = this.lookupCachedField(name);
        if (cachedField != null && cachedField.getDeclaringClass() == this) {
            return cachedField;
        }
        return this.cacheField(this.getDeclaredFieldImpl(name));
    }

    private native Field getDeclaredFieldImpl(String var1) throws NoSuchFieldException;

    public Field[] getDeclaredFields() throws SecurityException {
        this.checkMemberAccess(1);
        Field[] cachedFields = this.lookupCachedFields(DeclaredKey);
        if (cachedFields != null) {
            return cachedFields;
        }
        return this.cacheFields(this.getDeclaredFieldsImpl(), DeclaredKey);
    }

    private native Field[] getDeclaredFieldsImpl();

    public Method getDeclaredMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Class[] params;
        String strSig;
        this.checkMemberAccess(1);
        Method cachedMethod = this.lookupCachedMethod(name, parameterTypes == null ? EmptyParameters : parameterTypes);
        if (cachedMethod != null && cachedMethod.getDeclaringClass() == this) {
            return cachedMethod;
        }
        if (name == null || parameterTypes == null || parameterTypes.length == 0) {
            strSig = "()";
            params = EmptyParameters;
        } else {
            strSig = this.getParameterTypesSignature(name, parameterTypes);
            params = (Class[])parameterTypes.clone();
            for (int i = 0; i < params.length; ++i) {
                Class parameterType = params[i];
                ClassLoader loader = this.getClassLoader();
                if (parameterType.isPrimitive()) continue;
                try {
                    if (Class.forName(parameterType.getName(), false, loader) == parameterType) continue;
                    this.throwNoSuchMethodException(name, parameterTypes);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    this.throwNoSuchMethodException(name, parameterTypes);
                }
            }
        }
        Method result = this.getDeclaredMethodImpl(name, params, strSig, null);
        if (result == null) {
            this.throwNoSuchMethodException(name, params);
        }
        Method bestCandidate = result;
        int maxDepth = super.getClassDepth();
        while ((result = this.getDeclaredMethodImpl(name, params, strSig, result)) != null) {
            int resultDepth = super.getClassDepth();
            if (resultDepth <= maxDepth) continue;
            bestCandidate = result;
            maxDepth = resultDepth;
        }
        return this.cacheMethod(bestCandidate);
    }

    private native Method getDeclaredMethodImpl(String var1, Class[] var2, String var3, Method var4);

    public Method[] getDeclaredMethods() throws SecurityException {
        this.checkMemberAccess(1);
        Method[] cachedMethods = this.lookupCachedMethods(DeclaredKey);
        if (cachedMethods != null) {
            return cachedMethods;
        }
        return this.cacheMethods(this.getDeclaredMethodsImpl(), DeclaredKey);
    }

    private native Method[] getDeclaredMethodsImpl();

    public Class<?> getDeclaringClass() {
        return this.getDeclaringClassImpl();
    }

    private native Class getDeclaringClassImpl();

    public Field getField(String name) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(0);
        Field cachedField = this.lookupCachedField(name);
        if (cachedField != null && Modifier.isPublic(cachedField.getModifiers())) {
            return cachedField;
        }
        return this.cacheField(this.getFieldImpl(name));
    }

    private native Field getFieldImpl(String var1) throws NoSuchFieldException;

    public Field[] getFields() throws SecurityException {
        this.checkMemberAccess(0);
        Field[] cachedFields = this.lookupCachedFields(PublicKey);
        if (cachedFields != null) {
            return cachedFields;
        }
        return this.cacheFields(this.getFieldsImpl(), PublicKey);
    }

    private native Field[] getFieldsImpl();

    public Class<?>[] getInterfaces() {
        return J9VMInternals.getInterfaces(this);
    }

    public Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Class[] params;
        String strSig;
        this.checkMemberAccess(0);
        Method cachedMethod = this.lookupCachedMethod(name, parameterTypes == null ? EmptyParameters : parameterTypes);
        if (cachedMethod != null && Modifier.isPublic(cachedMethod.getModifiers())) {
            return cachedMethod;
        }
        if (name == null || parameterTypes == null || parameterTypes.length == 0) {
            strSig = "()";
            params = EmptyParameters;
        } else {
            strSig = this.getParameterTypesSignature(name, parameterTypes);
            params = (Class[])parameterTypes.clone();
        }
        Method result = this.getMethodImpl(name, params, strSig);
        if (result == null) {
            this.throwNoSuchMethodException(name, params);
        }
        for (int i = 0; i < params.length; ++i) {
            Class parameterType = params[i];
            ClassLoader loader = result.getDeclaringClass().getClassLoader();
            if (parameterType.isPrimitive()) continue;
            try {
                if (Class.forName(parameterType.getName(), false, loader) == parameterType) continue;
                this.throwNoSuchMethodException(name, parameterTypes);
                continue;
            }
            catch (ClassNotFoundException e) {
                this.throwNoSuchMethodException(name, parameterTypes);
            }
        }
        Method bestCandidate = result;
        int maxDepth = super.getClassDepth();
        Class<?> declaringClass = result.getDeclaringClass();
        while ((result = super.getDeclaredMethodImpl(name, params, strSig, result)) != null) {
            int resultDepth;
            if ((result.getModifiers() & 1) == 0 || (resultDepth = super.getClassDepth()) <= maxDepth) continue;
            bestCandidate = result;
            maxDepth = resultDepth;
        }
        return this.cacheMethod(bestCandidate);
    }

    private native Method getMethodImpl(String var1, Class[] var2, String var3);

    public Method[] getMethods() throws SecurityException {
        this.checkMemberAccess(0);
        Method[] methods = this.lookupCachedMethods(PublicKey);
        if (methods != null) {
            return methods;
        }
        if (this.isPrimitive()) {
            return new Method[0];
        }
        if (this.isInterface()) {
            methods = this.getInterfaceMethodsImpl();
            return this.cacheMethods(methods, PublicKey);
        }
        int vCount = this.getVirtualMethodCountImpl();
        methods = (Method[])super.allocateAndFillArray(vCount + this.getStaticMethodCountImpl());
        this.getVirtualMethodsImpl(methods, 0);
        this.getStaticMethodsImpl(methods, vCount);
        return this.cacheMethods(methods, PublicKey);
    }

    private boolean methodsEqual(Method m1, Method m2) {
        Class<?>[] m2Parms;
        if (!m1.getName().equals(m2.getName())) {
            return false;
        }
        if (!m1.getReturnType().equals(m2.getReturnType())) {
            return false;
        }
        Class<?>[] m1Parms = m1.getParameterTypes();
        if (m1Parms.length != (m2Parms = m2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < m1Parms.length; ++i) {
            if (m1Parms[i] == m2Parms[i]) continue;
            return false;
        }
        return true;
    }

    private int getInterfaceMethodCountImpl() {
        int count = this.getDeclaredMethods().length;
        Class<?>[] parents = this.getInterfaces();
        for (int i = 0; i < parents.length; ++i) {
            count += super.getInterfaceMethodCountImpl();
        }
        return count;
    }

    private Method[] getInterfaceMethodsImpl() {
        int i;
        Method[] scratch = new Method[this.getInterfaceMethodCountImpl()];
        Method[] local = this.getDeclaredMethods();
        int index = 0;
        for (i = 0; i < local.length; ++i) {
            if (Modifier.isAbstract(local[i].getModifiers())) {
                scratch[index++] = local[i];
                continue;
            }
            local[i] = null;
        }
        Class<?>[] parents = this.getInterfaces();
        for (i = 0; i < parents.length; ++i) {
            int j;
            Method[] parentMethods = super.getInterfaceMethodsImpl();
            for (j = 0; j < local.length; ++j) {
                if (local[j] == null) continue;
                for (int k = 0; k < parentMethods.length; ++k) {
                    if (parentMethods[k] == null || !this.methodsEqual(local[j], parentMethods[k])) continue;
                    parentMethods[k] = null;
                }
            }
            for (j = 0; j < parentMethods.length; ++j) {
                if (parentMethods[j] == null) continue;
                scratch[index++] = parentMethods[j];
            }
        }
        for (i = 0; i < scratch.length; ++i) {
            if (scratch[i] == null) continue;
            for (int j = i + 1; j < scratch.length; ++j) {
                if (scratch[j] == null || !scratch[i].equals(scratch[j])) continue;
                scratch[j] = null;
            }
        }
        int count = 0;
        for (i = 0; i < scratch.length; ++i) {
            if (scratch[i] == null) continue;
            ++count;
        }
        Method[] unique = new Method[count];
        index = 0;
        for (i = 0; i < scratch.length; ++i) {
            if (scratch[i] == null) continue;
            unique[index++] = scratch[i];
        }
        return unique;
    }

    private native int getVirtualMethodCountImpl();

    private native void getVirtualMethodsImpl(Method[] var1, int var2);

    private native int getStaticMethodCountImpl();

    private native void getStaticMethodsImpl(Method[] var1, int var2);

    private native Object[] allocateAndFillArray(int var1);

    public int getModifiers() {
        int rawModifiers = this.getModifiersImpl();
        rawModifiers = this.isArray() ? (rawModifiers &= 0x417) : (rawModifiers &= 0x761F);
        return rawModifiers;
    }

    private native int getModifiersImpl();

    public String getName() {
        String name = this.classNameString;
        if (name != null) {
            return name;
        }
        this.classNameString = name = this.getNameImpl().intern();
        return name;
    }

    native String getNameImpl();

    public ProtectionDomain getProtectionDomain() {
        ProtectionDomain result;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermission.permissionToGetProtectionDomain);
        }
        if ((result = this.getPDImpl()) != null) {
            return result;
        }
        if (AllPermissionsPD == null) {
            Permissions collection = new Permissions();
            collection.add(new AllPermission());
            AllPermissionsPD = new ProtectionDomain(null, collection);
        }
        return AllPermissionsPD;
    }

    ProtectionDomain getPDImpl() {
        return this.protectionDomain;
    }

    String getPackageName() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            return name.substring(0, index);
        }
        return "";
    }

    public URL getResource(String resName) {
        ClassLoader loader = this.getClassLoaderImpl();
        if (loader == ClassLoader.systemClassLoader) {
            return ClassLoader.getSystemResource(this.toResourceName(resName));
        }
        return loader.getResource(this.toResourceName(resName));
    }

    public InputStream getResourceAsStream(String resName) {
        ClassLoader loader = this.getClassLoaderImpl();
        if (loader == ClassLoader.systemClassLoader) {
            return ClassLoader.getSystemResourceAsStream(this.toResourceName(resName));
        }
        return loader.getResourceAsStream(this.toResourceName(resName));
    }

    private String getSignature() {
        if (this.isArray()) {
            return this.getName();
        }
        if (this.isPrimitive()) {
            if (this == Void.TYPE) {
                return "V";
            }
            if (this == Boolean.TYPE) {
                return "Z";
            }
            if (this == Byte.TYPE) {
                return "B";
            }
            if (this == Character.TYPE) {
                return "C";
            }
            if (this == Short.TYPE) {
                return "S";
            }
            if (this == Integer.TYPE) {
                return "I";
            }
            if (this == Long.TYPE) {
                return "J";
            }
            if (this == Float.TYPE) {
                return "F";
            }
            if (this == Double.TYPE) {
                return "D";
            }
        }
        String name = this.getName();
        return new StringBuffer(name.length() + 2).append('L').append(name).append(';').toString();
    }

    public Object[] getSigners() {
        return this.getClassLoaderImpl().getSigners(this);
    }

    public Class<? super T> getSuperclass() {
        return J9VMInternals.getSuperclass(this);
    }

    public native boolean isArray();

    public native boolean isAssignableFrom(Class<?> var1);

    public native boolean isInstance(Object var1);

    public boolean isInterface() {
        return !this.isArray() && (this.getModifiersImpl() & 0x200) != 0;
    }

    public native boolean isPrimitive();

    public T newInstance() throws IllegalAccessException, InstantiationException {
        this.checkMemberAccess(0);
        return (T)J9VMInternals.newInstanceImpl(this);
    }

    private Object newInstancePrototype(Class callerClass) throws InstantiationException {
        throw new InstantiationException(this);
    }

    private String toResourceName(String resName) {
        if (resName.length() > 0 && resName.charAt(0) == '/') {
            return resName.substring(1);
        }
        String qualifiedClassName = this.getName();
        int classIndex = qualifiedClassName.lastIndexOf(46);
        if (classIndex == -1) {
            return resName;
        }
        return qualifiedClassName.substring(0, classIndex + 1).replace('.', '/') + resName;
    }

    public String toString() {
        if (this.isPrimitive()) {
            return this.getName();
        }
        return (this.isInterface() ? "interface " : "class ") + this.getName();
    }

    public Package getPackage() {
        return this.getClassLoaderImpl().getPackage(this.getPackageName());
    }

    static Class getPrimitiveClass(String name) {
        if (name.equals("float")) {
            return new float[0].getClass().getComponentType();
        }
        if (name.equals("double")) {
            return new double[0].getClass().getComponentType();
        }
        if (name.equals("int")) {
            return new int[0].getClass().getComponentType();
        }
        if (name.equals("long")) {
            return new long[0].getClass().getComponentType();
        }
        if (name.equals("char")) {
            return new char[0].getClass().getComponentType();
        }
        if (name.equals("byte")) {
            return new byte[0].getClass().getComponentType();
        }
        if (name.equals("boolean")) {
            return new boolean[0].getClass().getComponentType();
        }
        if (name.equals("short")) {
            return new short[0].getClass().getComponentType();
        }
        if (name.equals("void")) {
            try {
                Method method = Runnable.class.getMethod("run", new Class[0]);
                return method.getReturnType();
            }
            catch (Exception e) {
                VM.dumpString("Cannot initialize Void.TYPE\n");
            }
        }
        throw new Error("Unknown primitive type: " + name);
    }

    public boolean desiredAssertionStatus() {
        ClassLoader cldr = this.getClassLoaderImpl();
        if (cldr != null) {
            return cldr.getClassAssertionStatus(this.getName());
        }
        return false;
    }

    static final native Class getStackClass(int var0);

    static final native Class[] getStackClasses(int var0, boolean var1);

    static int classDepth(String name) {
        Class[] classes = Class.getStackClasses(-1, false);
        for (int i = 1; i < classes.length; ++i) {
            if (!classes[i].getName().equals(name)) continue;
            return i - 1;
        }
        return -1;
    }

    static int classLoaderDepth() {
        Class[] classes = Class.getStackClasses(-1, true);
        for (int i = 1; i < classes.length; ++i) {
            ClassLoader cl = classes[i].getClassLoaderImpl();
            if (cl.isSystemClassLoader()) continue;
            return i - 1;
        }
        return -1;
    }

    static ClassLoader currentClassLoader() {
        Class[] classes = Class.getStackClasses(-1, true);
        for (int i = 1; i < classes.length; ++i) {
            ClassLoader cl = classes[i].getClassLoaderImpl();
            if (cl.isSystemClassLoader()) continue;
            return cl;
        }
        return null;
    }

    static Class currentLoadedClass() {
        Class[] classes = Class.getStackClasses(-1, true);
        for (int i = 1; i < classes.length; ++i) {
            ClassLoader cl = classes[i].getClassLoaderImpl();
            if (cl.isSystemClassLoader()) continue;
            return classes[i];
        }
        return null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        if (annotation == null) {
            throw new NullPointerException();
        }
        Annotation[] ans = this.getAnnotations();
        for (int i = 0; i < ans.length; ++i) {
            if (ans[i].annotationType() != annotation) continue;
            return (A)ans[i];
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        HashMap<String, Annotation> annotations = new HashMap<String, Annotation>();
        Annotation[] anns = this.getDeclaredAnnotations();
        for (int i = 0; i < anns.length; ++i) {
            annotations.put(anns[i].annotationType().getName(), anns[i]);
        }
        for (Class<T> c = this.getSuperclass(); c != null; c = c.getSuperclass()) {
            Annotation[] ann = c.getDeclaredAnnotations();
            if (ann == null) continue;
            for (int i = 0; i < ann.length; ++i) {
                if (annotations.containsKey(ann[i].annotationType().getName()) || ann[i].annotationType().getAnnotation((Class)Inherited.class) == null) continue;
                annotations.put(ann[i].annotationType().getName(), ann[i]);
            }
        }
        Annotation[] annArray = new Annotation[annotations.size()];
        annotations.values().toArray(annArray);
        return annArray;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        Hashtable collection = this.getClassLoaderImpl().getAnnotationCache();
        Annotation[] annotations = (Annotation[])collection.get(this);
        if (annotations == null) {
            annotations = AnnotationHelper.getDeclaredAnnotations(this, 0, null);
            collection.put(this, annotations);
        }
        return (Annotation[])annotations.clone();
    }

    public boolean isAnnotation() {
        return !this.isArray() && (this.getModifiersImpl() & 0x2000) != 0;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        if (annotation == null) {
            throw new NullPointerException();
        }
        return this.getAnnotation((Class)annotation) != null;
    }

    public <U> Class<? extends U> asSubclass(Class<U> cls) {
        if (!cls.isAssignableFrom(this)) {
            throw new ClassCastException(this.toString());
        }
        return this;
    }

    public T cast(Object object) {
        if (object != null && !this.isAssignableFrom(object.getClass())) {
            throw new ClassCastException(Msg.getString("K0336", object.getClass(), this));
        }
        return (T)object;
    }

    public boolean isEnum() {
        return !this.isArray() && (this.getModifiersImpl() & 0x4000) != 0 && this.getSuperclass() == Enum.class;
    }

    Map<String, T> enumConstantDirectory() {
        T[] enums = this.getEnumConstants();
        if (enums == null) {
            throw new IllegalArgumentException(this.getName() + " is not an Enum");
        }
        HashMap<String, T> map = new HashMap<String, T>(enums.length * 2);
        for (int i = 0; i < enums.length; ++i) {
            map.put(((Enum)enums[i]).name(), enums[i]);
        }
        return map;
    }

    public T[] getEnumConstants() {
        if (!this.isEnum()) {
            return null;
        }
        try {
            Method values = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    Method method = Class.this.getMethod("values", new Class[0]);
                    method.setAccessible(true);
                    return method;
                }
            });
            Object[] enums = (Object[])values.invoke((Object)this, new Object[0]);
            return (Object[])enums.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isSynthetic() {
        return !this.isArray() && (this.getModifiersImpl() & 0x1000) != 0;
    }

    private native String getGenericSignature();

    private CoreReflectionFactory getFactory() {
        return CoreReflectionFactory.make(this, ClassScope.make(this));
    }

    private ClassRepository getClassRepository(String signature) {
        Hashtable collection = this.getClassLoaderImpl().getGenericRepository();
        ClassRepository classRepository = (ClassRepository)collection.get(this);
        if (classRepository == null) {
            classRepository = ClassRepository.make(signature, this.getFactory());
            collection.put(this, classRepository);
        }
        return classRepository;
    }

    public TypeVariable<Class<T>>[] getTypeParameters() {
        String signature = this.getGenericSignature();
        if (signature == null) {
            return new TypeVariable[0];
        }
        ClassRepository repository = this.getClassRepository(signature);
        return repository.getTypeParameters();
    }

    public Type[] getGenericInterfaces() {
        String signature = this.getGenericSignature();
        if (signature == null) {
            return this.getInterfaces();
        }
        ClassRepository repository = this.getClassRepository(signature);
        return repository.getSuperInterfaces();
    }

    public Type getGenericSuperclass() {
        String signature = this.getGenericSignature();
        if (signature == null) {
            return this.getSuperclass();
        }
        if (this.isInterface()) {
            return null;
        }
        ClassRepository repository = this.getClassRepository(signature);
        return repository.getSuperclass();
    }

    private native Object getEnclosingObject();

    public Constructor<?> getEnclosingConstructor() {
        Object enclosing = this.getEnclosingObject();
        if (enclosing instanceof Constructor) {
            return (Constructor)enclosing;
        }
        return null;
    }

    public Method getEnclosingMethod() {
        Object enclosing = this.getEnclosingObject();
        if (enclosing instanceof Method) {
            return (Method)enclosing;
        }
        return null;
    }

    private native Class getEnclosingObjectClass();

    public Class<?> getEnclosingClass() {
        Class<?> declaringClass = this.getDeclaringClass();
        if (declaringClass != null) {
            return declaringClass;
        }
        Class enclosingClass = this.getEnclosingObjectClass();
        return enclosingClass;
    }

    private native String getSimpleNameImpl();

    public String getSimpleName() {
        String simpleName;
        int arrayCount = 0;
        Class<?> baseType = this;
        if (this.isArray()) {
            arrayCount = 1;
            while ((baseType = baseType.getComponentType()).isArray()) {
                ++arrayCount;
            }
        }
        if ((simpleName = baseType.getSimpleNameImpl()) == null) {
            if (super.getEnclosingObjectClass() != null) {
                simpleName = "";
            } else {
                simpleName = baseType.getName();
                int index = simpleName.lastIndexOf(46);
                if (index != -1) {
                    simpleName = simpleName.substring(index + 1);
                }
            }
        }
        if (arrayCount > 0) {
            StringBuffer result = new StringBuffer(simpleName);
            for (int i = 0; i < arrayCount; ++i) {
                result.append("[]");
            }
            return result.toString();
        }
        return simpleName;
    }

    public String getCanonicalName() {
        String canonicalName;
        int arrayCount = 0;
        Class<?> baseType = this;
        if (this.isArray()) {
            arrayCount = 1;
            while ((baseType = baseType.getComponentType()).isArray()) {
                ++arrayCount;
            }
        }
        if (baseType.getEnclosingObjectClass() != null) {
            return null;
        }
        Class<?> declaringClass = baseType.getDeclaringClass();
        if (declaringClass == null) {
            canonicalName = baseType.getName();
        } else {
            String declaringClassCanonicalName = declaringClass.getCanonicalName();
            if (declaringClassCanonicalName == null) {
                return null;
            }
            String simpleName = baseType.getName().substring(declaringClass.getName().length() + 1);
            canonicalName = declaringClassCanonicalName + '.' + simpleName;
        }
        if (arrayCount > 0) {
            StringBuffer result = new StringBuffer(canonicalName);
            for (int i = 0; i < arrayCount; ++i) {
                result.append("[]");
            }
            return result.toString();
        }
        return canonicalName;
    }

    public boolean isAnonymousClass() {
        return this.getSimpleNameImpl() == null && this.getEnclosingObjectClass() != null;
    }

    public boolean isLocalClass() {
        return this.getEnclosingObjectClass() != null && this.getSimpleNameImpl() != null;
    }

    public boolean isMemberClass() {
        return this.getEnclosingObjectClass() == null && this.getDeclaringClass() != null;
    }

    private native int getClassDepth();

    private String getParameterTypesSignature(String name, Class[] parameterTypes) throws NoSuchMethodException {
        int total = 2;
        String[] sigs = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class parameterType = parameterTypes[i];
            if (parameterType != null) {
                sigs[i] = parameterType.getSignature();
                total += sigs[i].length();
                continue;
            }
            this.throwNoSuchMethodException(name, parameterTypes);
        }
        StringBuffer signature = new StringBuffer(total);
        signature.append('(');
        for (int i = 0; i < parameterTypes.length; ++i) {
            signature.append(sigs[i]);
        }
        signature.append(')');
        return signature.toString();
    }

    static void initCacheIds() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class<Method> mClass = Method.class;
                try {
                    methodParameterTypesField = mClass.getDeclaredField("parameterTypes");
                    methodParameterTypesField.setAccessible(true);
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
                try {
                    copyMethod = mClass.getDeclaredMethod("copy", new Class[0]);
                    copyMethod.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                Class<Field> fClass = Field.class;
                try {
                    copyField = fClass.getDeclaredMethod("copy", new Class[0]);
                    copyField.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                Class<Constructor> cClass = Constructor.class;
                try {
                    constructorParameterTypesField = cClass.getDeclaredField("parameterTypes");
                    constructorParameterTypesField.setAccessible(true);
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
                try {
                    copyConstructor = cClass.getDeclaredMethod("copy", new Class[0]);
                    copyConstructor.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private Method lookupCachedMethod(String methodName, Class[] parameters) {
        Method method;
        Hashtable clCache;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return null;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("lookup Method: ");
            output.append(this.getName());
            output.append('.');
            output.append(methodName);
            System.err.println(output);
        }
        if ((clCache = (Hashtable)this.getClassLoaderImpl().getMethodCache().get(this)) != null && (method = (Method)clCache.get(new CacheKey(methodName, parameters, null))) != null) {
            try {
                Class[] orgParams = (Class[])methodParameterTypesField.get(method);
                for (int i = 0; i < orgParams.length; ++i) {
                    if (parameters[i] == orgParams[i]) continue;
                    return null;
                }
                return (Method)copyMethod.invoke((Object)method, NoArgs);
            }
            catch (IllegalAccessException e) {
                throw new InternalError(e.toString());
            }
            catch (InvocationTargetException e) {
                throw new InternalError(e.toString());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method cacheMethod(Method method) {
        if (!ClassLoader.isReflectCacheEnabled()) {
            return method;
        }
        if (ClassLoader.isReflectCacheAppOnly() && ClassLoader.getStackClassLoader(2) == ClassLoader.systemClassLoader) {
            return method;
        }
        if (copyMethod == null) {
            return method;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("cache Method: ");
            output.append(this.getName());
            output.append('.');
            output.append(method.getName());
            System.err.println(output);
        }
        try {
            Method foundMethod;
            ClassLoader.CacheTable cacheTable;
            ClassLoader.CacheTable clCache;
            CacheKey key = new CacheKey(method.getName(), (Class[])methodParameterTypesField.get(method), method.getReturnType());
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass != this) {
                cacheTable = clCache = this.getClassLoaderImpl().getMethodCache(declaringClass);
                synchronized (cacheTable) {
                    foundMethod = (Method)clCache.get(key);
                    if (foundMethod == null) {
                        clCache.put(key, new ReflectRef(method, key, clCache));
                    } else {
                        method = foundMethod;
                    }
                    clCache.free();
                }
            }
            cacheTable = clCache = this.getClassLoaderImpl().getMethodCache(this);
            synchronized (cacheTable) {
                if (declaringClass == this) {
                    foundMethod = (Method)clCache.get(key);
                    if (foundMethod == null) {
                        clCache.put(key, new ReflectRef(method, key, clCache));
                    } else {
                        method = foundMethod;
                    }
                }
                CacheKey lookupKey = new CacheKey(method.getName(), (Class[])methodParameterTypesField.get(method), null);
                clCache.put(lookupKey, new ReflectRef(method, lookupKey, clCache));
                clCache.free();
            }
            return (Method)copyMethod.invoke((Object)method, NoArgs);
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.toString());
        }
    }

    private Field lookupCachedField(String fieldName) {
        Field field;
        ClassLoader loader;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return null;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("lookup Field: ");
            output.append(this.getName());
            output.append('.');
            output.append(fieldName);
            System.err.println(output);
        }
        if ((loader = this.getClassLoaderImpl()) == null) {
            return null;
        }
        Hashtable clCache = (Hashtable)loader.getFieldCache().get(this);
        if (clCache != null && (field = (Field)clCache.get(new CacheKey(fieldName, EmptyParameters, null))) != null) {
            try {
                return (Field)copyField.invoke((Object)field, NoArgs);
            }
            catch (IllegalAccessException e) {
                throw new InternalError(e.toString());
            }
            catch (InvocationTargetException e) {
                throw new InternalError(e.toString());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Field cacheField(Field field) {
        Field foundField;
        ClassLoader.CacheTable cacheTable;
        ClassLoader.CacheTable clCache;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return field;
        }
        if (ClassLoader.isReflectCacheAppOnly() && ClassLoader.getStackClassLoader(2) == ClassLoader.systemClassLoader) {
            return field;
        }
        if (copyField == null) {
            return field;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("cache Field: ");
            output.append(this.getName());
            output.append('.');
            output.append(field.getName());
            System.err.println(output);
        }
        CacheKey key = new CacheKey(field.getName(), EmptyParameters, field.getType());
        Class<?> declaringClass = field.getDeclaringClass();
        if (declaringClass != this) {
            cacheTable = clCache = this.getClassLoaderImpl().getFieldCache(declaringClass);
            synchronized (cacheTable) {
                foundField = (Field)clCache.get(key);
                if (foundField == null) {
                    clCache.put(key, new ReflectRef(field, key, clCache));
                } else {
                    field = foundField;
                }
                clCache.free();
            }
        }
        cacheTable = clCache = this.getClassLoaderImpl().getFieldCache(this);
        synchronized (cacheTable) {
            if (declaringClass == this) {
                foundField = (Field)clCache.get(key);
                if (foundField == null) {
                    clCache.put(key, new ReflectRef(field, key, clCache));
                } else {
                    field = foundField;
                }
            }
            CacheKey lookupKey = new CacheKey(field.getName(), EmptyParameters, null);
            clCache.put(lookupKey, new ReflectRef(field, lookupKey, clCache));
            clCache.free();
        }
        try {
            return (Field)copyField.invoke((Object)field, NoArgs);
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.toString());
        }
    }

    private Constructor lookupCachedConstructor(Class[] parameters) {
        Constructor constructor;
        Hashtable clCache;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return null;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("lookup Constructor: ");
            output.append(this.getName()).append('(');
            for (int i = 0; i < parameters.length; ++i) {
                if (i != 0) {
                    output.append(", ");
                }
                output.append(parameters[i].getName());
            }
            output.append(')');
            System.err.println(output);
        }
        if ((clCache = (Hashtable)this.getClassLoaderImpl().getConstructorCache().get(this)) != null && (constructor = (Constructor)clCache.get(new CacheKey(this.getName(), parameters, null))) != null) {
            try {
                Class[] orgParams = (Class[])constructorParameterTypesField.get(constructor);
                for (int i = 0; i < orgParams.length; ++i) {
                    if (parameters[i] == orgParams[i]) continue;
                    return null;
                }
                return (Constructor)copyConstructor.invoke((Object)constructor, NoArgs);
            }
            catch (IllegalAccessException e) {
                throw new InternalError(e.toString());
            }
            catch (InvocationTargetException e) {
                throw new InternalError(e.toString());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Constructor cacheConstructor(Constructor constructor) {
        if (!ClassLoader.isReflectCacheEnabled()) {
            return constructor;
        }
        if (ClassLoader.isReflectCacheAppOnly() && ClassLoader.getStackClassLoader(2) == ClassLoader.systemClassLoader) {
            return constructor;
        }
        if (copyConstructor == null) {
            return constructor;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("cache Constructor: ");
            output.append(this.getName()).append('(');
            Class<?>[] params = constructor.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                if (i != 0) {
                    output.append(", ");
                }
                output.append(params[i].getName());
            }
            output.append(')');
            System.err.println(output);
        }
        ClassLoader.CacheTable clCache = this.getClassLoaderImpl().getConstructorCache(this);
        try {
            CacheKey key = new CacheKey(this.getName(), (Class[])constructorParameterTypesField.get(constructor), null);
            ReflectRef ref = new ReflectRef(constructor, key, clCache);
            ClassLoader.CacheTable cacheTable = clCache;
            synchronized (cacheTable) {
                clCache.put(key, ref);
                clCache.free();
            }
            return (Constructor)copyConstructor.invoke((Object)constructor, NoArgs);
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.toString());
        }
    }

    private Method[] copyMethods(Method[] methods) {
        Method[] result = new Method[methods.length];
        try {
            for (int i = 0; i < methods.length; ++i) {
                result[i] = (Method)copyMethod.invoke((Object)methods[i], NoArgs);
            }
            return result;
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.toString());
        }
    }

    private Method[] lookupCachedMethods(CacheKey cacheKey) {
        Method[] methods;
        Hashtable clCache;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return null;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("lookup Methods in: ");
            output.append(this.getName());
            System.err.println(output);
        }
        if ((clCache = (Hashtable)this.getClassLoaderImpl().getMethodCache().get(this)) != null && (methods = (Method[])clCache.get(cacheKey)) != null) {
            return this.copyMethods(methods);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method[] cacheMethods(Method[] methods, CacheKey cacheKey) {
        if (!ClassLoader.isReflectCacheEnabled()) {
            return methods;
        }
        if (ClassLoader.isReflectCacheAppOnly() && ClassLoader.getStackClassLoader(2) == ClassLoader.systemClassLoader) {
            return methods;
        }
        if (copyMethod == null) {
            return methods;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("cache Methods: ");
            output.append(this.getName());
            System.err.println(output);
        }
        try {
            Class<?> lastDeclaringClass = null;
            ClassLoader.CacheTable declaringCache = null;
            ClassLoader loader = this.getClassLoaderImpl();
            ClassLoader.CacheTable clCache = loader.getMethodCache(this);
            for (int i = 0; i < methods.length; ++i) {
                Method method;
                ClassLoader.CacheTable cacheTable;
                CacheKey key = new CacheKey(methods[i].getName(), (Class[])methodParameterTypesField.get(methods[i]), methods[i].getReturnType());
                Class<?> declaringClass = methods[i].getDeclaringClass();
                if (declaringClass != this) {
                    if (declaringClass != lastDeclaringClass) {
                        if (declaringCache != null) {
                            declaringCache.free();
                        }
                        declaringCache = loader.getMethodCache(declaringClass);
                        lastDeclaringClass = declaringClass;
                    }
                    cacheTable = declaringCache;
                    synchronized (cacheTable) {
                        method = (Method)declaringCache.get(key);
                        if (method == null) {
                            declaringCache.put(key, new ReflectRef(methods[i], key, declaringCache));
                        } else {
                            methods[i] = method;
                        }
                        continue;
                    }
                }
                cacheTable = clCache;
                synchronized (cacheTable) {
                    method = (Method)clCache.get(key);
                    if (method == null) {
                        clCache.put(key, new ReflectRef(methods[i], key, clCache));
                    } else {
                        methods[i] = method;
                    }
                    continue;
                }
            }
            if (declaringCache != null) {
                declaringCache.free();
            }
            ReflectRef ref = new ReflectRef(methods, cacheKey, clCache);
            ClassLoader.CacheTable cacheTable = clCache;
            synchronized (cacheTable) {
                clCache.put(cacheKey, ref);
                clCache.free();
            }
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.toString());
        }
        return this.copyMethods(methods);
    }

    private Field[] copyFields(Field[] fields) {
        Field[] result = new Field[fields.length];
        try {
            for (int i = 0; i < fields.length; ++i) {
                result[i] = (Field)copyField.invoke((Object)fields[i], NoArgs);
            }
            return result;
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.toString());
        }
    }

    private Field[] lookupCachedFields(CacheKey cacheKey) {
        Field[] fields;
        Hashtable clCache;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return null;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("lookup Fields in: ");
            output.append(this.getName());
            System.err.println(output);
        }
        if ((clCache = (Hashtable)this.getClassLoaderImpl().getFieldCache().get(this)) != null && (fields = (Field[])clCache.get(cacheKey)) != null) {
            return this.copyFields(fields);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Field[] cacheFields(Field[] fields, CacheKey cacheKey) {
        if (!ClassLoader.isReflectCacheEnabled()) {
            return fields;
        }
        if (ClassLoader.isReflectCacheAppOnly() && ClassLoader.getStackClassLoader(2) == ClassLoader.systemClassLoader) {
            return fields;
        }
        if (copyField == null) {
            return fields;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("cache Fields: ");
            output.append(this.getName());
            System.err.println(output);
        }
        Class<?> lastDeclaringClass = null;
        ClassLoader loader = this.getClassLoaderImpl();
        ClassLoader.CacheTable clCache = loader.getFieldCache(this);
        ClassLoader.CacheTable declaringCache = null;
        for (int i = 0; i < fields.length; ++i) {
            Field field;
            ClassLoader.CacheTable cacheTable;
            CacheKey key = new CacheKey(fields[i].getName(), EmptyParameters, fields[i].getType());
            Class<?> declaringClass = fields[i].getDeclaringClass();
            if (declaringClass != this) {
                if (declaringClass != lastDeclaringClass) {
                    if (declaringCache != null) {
                        declaringCache.free();
                    }
                    declaringCache = loader.getFieldCache(declaringClass);
                    lastDeclaringClass = declaringClass;
                }
                cacheTable = declaringCache;
                synchronized (cacheTable) {
                    field = (Field)declaringCache.get(key);
                    if (field == null) {
                        declaringCache.put(key, new ReflectRef(fields[i], key, declaringCache));
                    } else {
                        fields[i] = field;
                    }
                    continue;
                }
            }
            cacheTable = clCache;
            synchronized (cacheTable) {
                field = (Field)clCache.get(key);
                if (field == null) {
                    clCache.put(key, new ReflectRef(fields[i], key, clCache));
                } else {
                    fields[i] = field;
                }
                continue;
            }
        }
        if (declaringCache != null) {
            declaringCache.free();
        }
        ReflectRef ref = new ReflectRef(fields, cacheKey, clCache);
        ClassLoader.CacheTable cacheTable = clCache;
        synchronized (cacheTable) {
            clCache.put(cacheKey, ref);
            clCache.free();
        }
        return this.copyFields(fields);
    }

    private Constructor[] copyConstructors(Constructor[] constructors) {
        Constructor[] result = new Constructor[constructors.length];
        try {
            for (int i = 0; i < constructors.length; ++i) {
                result[i] = (Constructor)copyConstructor.invoke((Object)constructors[i], NoArgs);
            }
            return result;
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.toString());
        }
    }

    private Constructor[] lookupCachedConstructors(CacheKey cacheKey) {
        Constructor[] constructors;
        Hashtable clCache;
        if (!ClassLoader.isReflectCacheEnabled()) {
            return null;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("lookup Constructors in: ");
            output.append(this.getName());
            System.err.println(output);
        }
        if ((clCache = (Hashtable)this.getClassLoaderImpl().getConstructorCache().get(this)) != null && (constructors = (Constructor[])clCache.get(cacheKey)) != null) {
            return this.copyConstructors(constructors);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Constructor[] cacheConstructors(Constructor[] constructors, CacheKey cacheKey) {
        if (!ClassLoader.isReflectCacheEnabled()) {
            return constructors;
        }
        if (ClassLoader.isReflectCacheAppOnly() && ClassLoader.getStackClassLoader(2) == ClassLoader.systemClassLoader) {
            return constructors;
        }
        if (copyConstructor == null) {
            return constructors;
        }
        if (ClassLoader.isReflectCacheDebug()) {
            StringBuffer output = new StringBuffer(200);
            output.append("cache Constructors: ");
            output.append(this.getName());
            System.err.println(output);
        }
        ClassLoader.CacheTable clCache = this.getClassLoaderImpl().getConstructorCache(this);
        try {
            for (int i = 0; i < constructors.length; ++i) {
                CacheKey key = new CacheKey(this.getName(), (Class[])constructorParameterTypesField.get(constructors[i]), null);
                ClassLoader.CacheTable cacheTable = clCache;
                synchronized (cacheTable) {
                    Constructor constructor = (Constructor)clCache.get(key);
                    if (constructor == null) {
                        clCache.put(key, new ReflectRef(constructors[i], key, clCache));
                    } else {
                        constructors[i] = constructor;
                    }
                    continue;
                }
            }
            ReflectRef ref = new ReflectRef(constructors, cacheKey, clCache);
            ClassLoader.CacheTable cacheTable = clCache;
            synchronized (cacheTable) {
                clCache.put(cacheKey, ref);
                clCache.free();
            }
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.toString());
        }
        return this.copyConstructors(constructors);
    }

    static {
        EmptyParameters = new Class[0];
        NoArgs = new Object[0];
        PublicKey = new CacheKey(".m", EmptyParameters, null);
        DeclaredKey = new CacheKey(".d", EmptyParameters, null);
        queue = new ReferenceQueue();
    }

    static final class CacheKey {
        final int PRIME = 31;
        String name;
        Class[] parameterTypes;
        Class returnType;
        int hashCode;

        public CacheKey(String name, Class[] params, Class returnType) {
            this.name = name;
            this.parameterTypes = params;
            this.returnType = returnType;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = this.name.hashCode();
                if (this.parameterTypes.length > 0) {
                    int arrayHash = 1;
                    for (int i = 0; i < this.parameterTypes.length; ++i) {
                        arrayHash = 31 * arrayHash + (this.parameterTypes[i] == null ? 0 : this.parameterTypes[i].hashCode());
                    }
                    result = 31 * result + arrayHash;
                }
                if (this.returnType != null) {
                    result = 31 * result + this.returnType.hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            CacheKey other = (CacheKey)obj;
            if (this.returnType != other.returnType) {
                return false;
            }
            if (this.parameterTypes.length != other.parameterTypes.length || !this.name.equals(other.name)) {
                return false;
            }
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                if (this.parameterTypes[i] == other.parameterTypes[i]) continue;
                return false;
            }
            return true;
        }
    }

    static final class ReflectRef
    extends SoftReference
    implements Runnable {
        CacheKey key;
        ClassLoader.CacheTable clCache;

        public ReflectRef(Object referent, CacheKey keyValue, ClassLoader.CacheTable clCacheValue) {
            super(referent, queue);
            this.key = keyValue;
            this.clCache = clCacheValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ClassLoader.CacheTable cacheTable = this.clCache;
            synchronized (cacheTable) {
                if (this.clCache.getRef(this.key) == this) {
                    this.clCache.remove(this.key);
                }
            }
            this.clCache.removeEmpty();
        }
    }
}

