/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.Jxe;
import com.ibm.oti.vm.JxeException;
import com.ibm.oti.vm.VM;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JxeMetaData {
    private static final String META_NAME = "META-INF/JXE.MF";
    private static final boolean useNative = VM.useNatives();
    private Hashtable table;
    private boolean bigEndian;
    private int intSize;
    private String jxeName;
    private String startupClass;
    private String uuid;
    private String version;
    private String description;
    private String target;
    private Vector prereqs;
    private int ramClassSize;
    private boolean interpretable = true;
    private boolean posIndependent = false;
    private char[] buf;

    protected JxeMetaData(Jxe jxe) {
        InputStream stream = jxe.internalGetResourceAsStream(META_NAME);
        if (null != stream) {
            this.initializeTable(stream);
        }
    }

    private JxeMetaData() {
    }

    public static JxeMetaData fromFile(File file) throws IOException, JxeException {
        ZipFile zip = new ZipFile(file);
        ZipEntry entry = zip.getEntry(META_NAME);
        if (entry == null) {
            throw new JxeException(Msg.getString("K01c5", file));
        }
        JxeMetaData meta = new JxeMetaData();
        meta.initializeTable(zip.getInputStream(entry));
        return meta;
    }

    private String convertToString(byte[] bytes, int offset, int length) {
        try {
            if (useNative) {
                return Util.convertFromUTF8(bytes, offset, length);
            }
            if (length > this.buf.length) {
                this.buf = new char[length];
            }
            return Util.convertUTF8WithBuf(bytes, this.buf, offset, length);
        }
        catch (UTFDataFormatException e) {
            return "";
        }
    }

    private void initializeTable(InputStream stream) {
        byte[] bytes;
        this.table = new Hashtable();
        try {
            bytes = new byte[stream.available()];
            stream.read(bytes, 0, bytes.length);
            stream.close();
        }
        catch (IOException e) {
            return;
        }
        int offset = 0;
        if (!useNative) {
            // empty if block
        }
        this.buf = new char[256];
        while (offset < bytes.length) {
            int length = 0;
            while (0 != bytes[offset + length]) {
                ++length;
            }
            String key = this.convertToString(bytes, offset, length);
            offset += length + 1;
            length = 0;
            while (0 != bytes[offset + length]) {
                ++length;
            }
            String val = this.convertToString(bytes, offset, length);
            this.setLocalVal(key, val);
            offset += length + 2;
            Vector<String> vals = (Vector<String>)this.table.get(key);
            if (null == vals) {
                vals = new Vector<String>();
                this.table.put(key, vals);
            }
            vals.addElement(val);
        }
        this.buf = null;
    }

    private int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void setLocalVal(String key, String val) {
        if (key.equals("bigEndian")) {
            int number = this.parseInt(val);
            this.bigEndian = number != 0;
        } else if (key.equals("intSize")) {
            this.intSize = this.parseInt(val);
        } else if (key.equals("jxeName")) {
            this.jxeName = val;
        } else if (key.equals("startupClass")) {
            if (null != val) {
                val = val.replace('/', '.');
            }
            this.startupClass = val;
        } else if (key.equals("uuid")) {
            this.uuid = val;
        } else if (key.equals("version")) {
            this.version = val;
        } else if (key.equals("description")) {
            this.description = val;
        } else if (key.equals("ramClassSize")) {
            this.ramClassSize = this.parseInt(val);
        } else if (key.equals("prereq")) {
            if (null == this.prereqs) {
                this.prereqs = new Vector();
            }
            this.prereqs.addElement(val);
        } else if (key.equals("interpretable")) {
            int number = this.parseInt(val);
            this.interpretable = number != 0;
        } else if (key.equals("posIndependent")) {
            int number = this.parseInt(val);
            this.posIndependent = number != 0;
        } else if (key.equals("target")) {
            this.target = val;
        }
    }

    public Vector getValues(String key) {
        return (Vector)this.table.get(key);
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public int getIntSize() {
        return this.intSize;
    }

    public String getJxeName() {
        return this.jxeName;
    }

    public String getStartupClass() {
        return this.startupClass;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public int getRamClassSize() {
        return this.ramClassSize;
    }

    public Vector getPrereqs() {
        return this.prereqs;
    }

    public boolean isInterpretable() {
        return this.interpretable;
    }

    public boolean isPositionIndependent() {
        return this.posIndependent;
    }

    public int getRomImageVersion() {
        int index;
        if (this.version != null && (index = this.version.lastIndexOf(46)) > 0) {
            String romImageVersion = this.version.substring(index);
            return this.parseInt(romImageVersion);
        }
        return 0;
    }

    public String getTarget() {
        return this.target;
    }
}

