/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Util;
import com.ibm.oti.vm.VM;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class AbstractClassLoader
extends ClassLoader {
    private static ClassLoader systemClassLoader;
    String[] parsedPath;
    int[] types;
    Object[] cache;
    static Object cacheLock;
    FilePermission[] permissions;
    private static Object manifestLock;

    public AbstractClassLoader() {
    }

    public AbstractClassLoader(ClassLoader p1) {
        super(p1);
    }

    void fillCache(int i) {
        this.setTypeElement(i, VM.getClassPathEntryType(this, i));
        switch (this.types[i]) {
            case 0: {
                this.setCacheElement(i, this.cache);
                return;
            }
            case 1: 
            case 2: {
                String path;
                if (this.parsedPath[i] == null) {
                    this.setParsedPathElement(i, Util.toString(VM.getPathFromClassPath(i)));
                }
                File f = new File(this.parsedPath[i]);
                try {
                    path = f.getCanonicalPath();
                }
                catch (IOException e) {
                    path = f.getAbsolutePath();
                }
                if (this.types[i] == 1) {
                    if (path.charAt(path.length() - 1) != File.separatorChar) {
                        StringBuilder buffer = new StringBuilder(path.length() + 1);
                        path = buffer.append(path).append(File.separatorChar).toString();
                    }
                    this.setParsedPathElement(i, path);
                    this.setCacheElement(i, this.cache);
                } else {
                    this.setParsedPathElement(i, path);
                    try {
                        JarFile zf = new JarFile(this.parsedPath[i]);
                        this.setCacheElement(i, zf);
                        return;
                    }
                    catch (IOException e) {
                        this.setTypeElement(i, 5);
                        this.setCacheElement(i, this.cache);
                    }
                }
                return;
            }
            case 4: 
            case 8: {
                this.setTypeElement(i, 5);
            }
            case 3: 
            case 5: {
                this.setCacheElement(i, this.cache);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsStream(String resName) {
        int length;
        InputStream answer;
        if (resName == null || resName.length() < 1 || resName.charAt(0) == '/') {
            return null;
        }
        if (this != systemClassLoader && (answer = this.getParent() == null ? systemClassLoader.getResourceAsStream(resName) : this.getParent().getResourceAsStream(resName)) != null) {
            return answer;
        }
        Object object = cacheLock;
        synchronized (object) {
            length = this.cache.length;
        }
        block11: for (int i = 0; i < length; ++i) {
            try {
                if (this.cache[i] == null) {
                    this.fillCache(i);
                }
                switch (this.types[i]) {
                    case 2: {
                        ZipFile zf = (ZipFile)this.cache[i];
                        ZipEntry entry = zf.getEntry(resName);
                        if (entry == null) continue block11;
                        SecurityManager security = System.getSecurityManager();
                        if (security != null) {
                            this.initalizePermissions();
                            if (this.permissions[i] == null) {
                                this.setPermissionElement(i, new FilePermission(this.parsedPath[i], "read"));
                            }
                            security.checkPermission(this.permissions[i]);
                        }
                        try {
                            return zf.getInputStream(entry);
                        }
                        catch (IOException e) {
                            break;
                        }
                    }
                    case 1: {
                        StringBuilder buffer = new StringBuilder(this.parsedPath[i].length() + resName.length());
                        String resourcePath = buffer.append(this.parsedPath[i]).append(resName).toString();
                        InputStream result = this.openFile(resourcePath);
                        if (result == null) continue block11;
                        return result;
                    }
                }
                continue;
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCacheElement(int i, Object value) {
        Object object = cacheLock;
        synchronized (object) {
            this.cache[i] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTypeElement(int i, int value) {
        Object object = cacheLock;
        synchronized (object) {
            this.types[i] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParsedPathElement(int i, String value) {
        Object object = cacheLock;
        synchronized (object) {
            this.parsedPath[i] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initalizePermissions() {
        Object object = cacheLock;
        synchronized (object) {
            if (this.permissions == null) {
                this.permissions = new FilePermission[this.cache.length];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPermissionElement(int i, FilePermission value) {
        Object object = cacheLock;
        synchronized (object) {
            this.permissions[i] = value;
        }
    }

    private InputStream openFile(String resourcePath) {
        File f = new File(resourcePath);
        if (f.exists()) {
            try {
                return new BufferedInputStream(new FileInputStream(f));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    protected URL findResource(final String res) {
        SecurityManager sm;
        URL result = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < AbstractClassLoader.this.cache.length; ++i) {
                    URL result = AbstractClassLoader.this.findResourceImpl(i, res);
                    if (result == null) continue;
                    return result;
                }
                return null;
            }
        });
        if (result != null && (sm = System.getSecurityManager()) != null) {
            try {
                sm.checkPermission(result.openConnection().getPermission());
            }
            catch (IOException e) {
                return null;
            }
            catch (SecurityException e) {
                return null;
            }
        }
        return result;
    }

    private URL findResourceImpl(int i, String res) {
        if (res.length() > 0 && res.charAt(0) == '/') {
            return null;
        }
        if (this.cache[i] == null) {
            this.fillCache(i);
        }
        try {
            switch (this.types[i]) {
                case 2: {
                    ZipFile zf = (ZipFile)this.cache[i];
                    if (zf.getEntry(res) != null) {
                        return new URL("jar", null, -1, AbstractClassLoader.toURLString(this.parsedPath[i] + "!/" + res), null);
                    }
                    return null;
                }
                case 1: {
                    StringBuilder buffer = new StringBuilder(this.parsedPath[i].length() + res.length());
                    String resourcePath = buffer.append(this.parsedPath[i]).append(res).toString();
                    File f = new File(resourcePath);
                    if (f.exists()) {
                        return new URL(AbstractClassLoader.toURLString(resourcePath));
                    }
                    return null;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    protected Enumeration findResources(final String res) throws IOException {
        SecurityManager sm;
        Vector<URL> result = (Vector<URL>)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Vector<URL> resources = new Vector<URL>();
                for (int i = 0; i < AbstractClassLoader.this.cache.length; ++i) {
                    URL resource = AbstractClassLoader.this.findResourceImpl(i, res);
                    if (resource == null) continue;
                    resources.addElement(resource);
                }
                return resources;
            }
        });
        int length = result.size();
        if (length > 0 && (sm = System.getSecurityManager()) != null) {
            Vector<URL> reduced = new Vector<URL>(length);
            for (int i = 0; i < length; ++i) {
                URL url = (URL)result.elementAt(i);
                try {
                    sm.checkPermission(url.openConnection().getPermission());
                    reduced.addElement(url);
                    continue;
                }
                catch (IOException e) {
                    continue;
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            result = reduced;
        }
        return result.elements();
    }

    static String toURLString(String filename) {
        String name = filename;
        if (File.separatorChar != '/') {
            name = name.replace(File.separatorChar, '/');
        }
        name = Util.urlEncode(name);
        StringBuilder buf = new StringBuilder(name.length() + 6);
        buf.append("file:");
        if (!name.startsWith("/")) {
            buf.append('/');
        }
        name = buf.append(name).toString();
        return name;
    }

    public static void setBootstrapClassLoader(ClassLoader bootstrapClassLoader) {
        if (systemClassLoader != null) {
            throw new IllegalArgumentException();
        }
        systemClassLoader = bootstrapClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Package definePackage(String packageName, final int cacheIndex) {
        if (cacheIndex >= 0 && this.cache[cacheIndex] == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AbstractClassLoader.this.fillCache(cacheIndex);
                    return null;
                }
            });
        }
        if (cacheIndex >= 0 && this.types[cacheIndex] == 2) {
            Manifest manifest = null;
            try {
                JarFile jf = (JarFile)this.cache[cacheIndex];
                manifest = jf.getManifest();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (manifest != null) {
                Object e = manifestLock;
                synchronized (e) {
                    String specTitle = null;
                    String specVersion = null;
                    String specVendor = null;
                    String implTitle = null;
                    String implVersion = null;
                    String implVendor = null;
                    Package result = super.getPackage(packageName);
                    if (result != null) {
                        return result;
                    }
                    Attributes mainAttributes = manifest.getMainAttributes();
                    String value = mainAttributes.getValue(Attributes.Name.SEALED);
                    boolean sealed = value != null && value.toLowerCase().equals("true");
                    String dirName = packageName.replace('.', '/') + "/";
                    Attributes attributes = manifest.getAttributes(dirName);
                    if (attributes != null) {
                        value = attributes.getValue(Attributes.Name.SEALED);
                        if (value != null) {
                            sealed = value.toLowerCase().equals("true");
                        }
                        specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                        specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                        specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                        implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                        implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                        implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                    }
                    URL url = null;
                    try {
                        if (sealed) {
                            url = new URL(AbstractClassLoader.toURLString(this.parsedPath[cacheIndex]));
                        }
                    }
                    catch (MalformedURLException e2) {
                        // empty catch block
                    }
                    if (specTitle == null) {
                        specTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                    }
                    if (specVersion == null) {
                        specVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                    }
                    if (specVendor == null) {
                        specVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                    }
                    if (implTitle == null) {
                        implTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    }
                    if (implVersion == null) {
                        implVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    }
                    if (implVendor == null) {
                        implVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                    }
                    return this.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, url);
                }
            }
        }
        Object object = manifestLock;
        synchronized (object) {
            Package result = super.getPackage(packageName);
            if (result != null) {
                return result;
            }
            return this.definePackage(packageName, null, null, null, null, null, null, null);
        }
    }

    String getPackageName(Class theClass) {
        String name = VM.getClassNameImpl(theClass);
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return name.substring(0, index);
    }

    static {
        cacheLock = new CacheLock();
        manifestLock = new ManifestLock();
    }

    private static class ManifestLock {
        private ManifestLock() {
        }
    }

    private static class CacheLock {
        private CacheLock() {
        }
    }
}

