/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.ByteArrayOutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;

public final class Util {
    private static final boolean useNative = VM.useNatives();
    private static final String defaultEncoding;

    public static byte[] getBytes(String name) {
        if (defaultEncoding != null) {
            try {
                return name.getBytes(defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return name.getBytes();
    }

    public static String toString(byte[] bytes) {
        if (defaultEncoding != null) {
            try {
                return new String(bytes, 0, bytes.length, defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new String(bytes, 0, bytes.length);
    }

    public static String toString(byte[] bytes, int offset, int length) {
        if (defaultEncoding != null) {
            try {
                return new String(bytes, offset, length, defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new String(bytes, offset, length);
    }

    private static native String convertUTF8(byte[] var0, int var1, int var2);

    public static String convertFromUTF8(byte[] buf, int offset, int utfSize) throws UTFDataFormatException {
        if (useNative) {
            String result = Util.convertUTF8(buf, offset, utfSize);
            if (result != null) {
                return result;
            }
            throw new UTFDataFormatException();
        }
        return Util.convertUTF8WithBuf(buf, new char[utfSize], offset, utfSize);
    }

    public static String convertUTF8WithBuf(byte[] buf, char[] out, int offset, int utfSize) throws UTFDataFormatException {
        int count = 0;
        int s = 0;
        while (count < utfSize) {
            byte b;
            if ((out[s] = (char)buf[offset + count++]) < '\u0080') {
                ++s;
                continue;
            }
            char a = out[s];
            if ((a & 0xE0) == 192) {
                if (count >= utfSize) {
                    throw new UTFDataFormatException(Msg.getString("K0062", count));
                }
                if (((b = buf[count++]) & 0xC0) != 128) {
                    throw new UTFDataFormatException(Msg.getString("K0062", count - 1));
                }
                out[s++] = (char)((a & 0x1F) << 6 | b & 0x3F);
                continue;
            }
            if ((a & 0xF0) == 224) {
                if (count + 1 >= utfSize) {
                    throw new UTFDataFormatException(Msg.getString("K0063", count + 1));
                }
                b = buf[count++];
                byte c = buf[count++];
                if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                    throw new UTFDataFormatException(Msg.getString("K0064", count - 2));
                }
                out[s++] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                continue;
            }
            throw new UTFDataFormatException(Msg.getString("K0065", count - 1));
        }
        return new String(out, 0, s);
    }

    public static String decode(String s, boolean convertPlus) {
        return Util.decode(s, convertPlus, null);
    }

    public static String decode(String s, boolean convertPlus, String encoding) {
        if (!convertPlus && s.indexOf(37) == -1) {
            return s;
        }
        StringBuilder result = new StringBuilder(s.length());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (convertPlus && c == '+') {
                result.append(' ');
            } else {
                if (c == '%') {
                    out.reset();
                    do {
                        if (i + 2 >= s.length()) {
                            throw new IllegalArgumentException(Msg.getString("K01fe", i));
                        }
                        int d1 = Character.digit(s.charAt(i + 1), 16);
                        int d2 = Character.digit(s.charAt(i + 2), 16);
                        if (d1 == -1 || d2 == -1) {
                            throw new IllegalArgumentException(Msg.getString("K01ff", s.substring(i, i + 3), String.valueOf(i)));
                        }
                        out.write((byte)((d1 << 4) + d2));
                    } while ((i += 3) < s.length() && s.charAt(i) == '%');
                    if (encoding != null) {
                        try {
                            result.append(out.toString(encoding));
                            continue;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new IllegalArgumentException(e.getMessage());
                        }
                    }
                    result.append(out.toString());
                    continue;
                }
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String urlEncode(String s) {
        boolean modified = false;
        StringBuilder buf = new StringBuilder();
        int start = -1;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || "_-!.~'()*,:$&+/@".indexOf(ch) > -1) {
                if (start >= 0) {
                    modified = true;
                    Util.convert(s.substring(start, i), buf);
                    start = -1;
                }
                buf.append(ch);
                continue;
            }
            if (start >= 0) continue;
            start = i;
        }
        if (start >= 0) {
            modified = true;
            Util.convert(s.substring(start, s.length()), buf);
        }
        return modified ? buf.toString() : s;
    }

    private static void convert(String s, StringBuilder buf) {
        byte[] bytes;
        String digits = "0123456789abcdef";
        try {
            bytes = s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = s.getBytes();
        }
        for (int j = 0; j < bytes.length; ++j) {
            buf.append('%');
            buf.append("0123456789abcdef".charAt((bytes[j] & 0xF0) >> 4));
            buf.append("0123456789abcdef".charAt(bytes[j] & 0xF));
        }
    }

    static {
        String encoding = System.getProperty("os.encoding");
        if (encoding != null) {
            try {
                "".getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                encoding = null;
            }
        }
        defaultEncoding = encoding;
    }
}

