/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.reflect;

import com.ibm.oti.reflect.AnnotationHelper;
import java.lang.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Method {
    private java.lang.reflect.Method method;
    private Annotation[] declaredAnnotations;

    public Method(java.lang.reflect.Method method) {
        this.method = method;
    }

    public <T extends Annotation> T getAnnotation(Class<T> cl) {
        if (cl == null) {
            throw new NullPointerException();
        }
        Annotation[] ans = this.method.getAnnotations();
        for (int i = 0; i < ans.length; ++i) {
            if (ans[i].annotationType() != cl) continue;
            return (T)ans[i];
        }
        return null;
    }

    public Annotation[] getDeclaredAnnotations() {
        if (this.declaredAnnotations == null) {
            this.declaredAnnotations = AnnotationHelper.getDeclaredAnnotations(this.method.getDeclaringClass(), 2, this.method);
        }
        return this.declaredAnnotations;
    }

    public Object getDefaultValue() {
        return AnnotationHelper.getDefaultReturnValueFromMethod(this.method.getDeclaringClass(), this.method.getReturnType(), this.method);
    }

    public Annotation[][] getParameterAnnotations() {
        Class<?> declaringClass = this.method.getDeclaringClass();
        int paramCount = this.method.getParameterTypes().length;
        Annotation[][] annArray = new Annotation[paramCount][];
        for (int i = 0; i < paramCount; ++i) {
            int annotationType = 3;
            annArray[i] = AnnotationHelper.getDeclaredAnnotations(declaringClass, annotationType |= i << 24, this.method);
        }
        return annArray;
    }
}

