/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.jre14.fastxpath.operations;

import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.operations.Variable;
import org.eclipse.tptp.platform.provisional.fastxpath.ExpressionEvaluationException;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContext;
import org.eclipse.tptp.platform.provisional.fastxpath.IExpression;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerContext;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.EExpression;

public class EVariable
extends EExpression {
    Variable variable;

    public IExpression instance(Expression e) {
        return new EVariable((Variable)e);
    }

    public EVariable(Variable variable) {
        this.variable = variable;
    }

    public void printGraph(int level) {
        super.printGraph(level);
        System.out.println(String.valueOf(this.indent(level)) + "QName = " + this.variable.getQName().toString());
    }

    public Object[] execute(FastXPathContext context) throws TransformerException, ExpressionEvaluationException {
        String value = context.getEngine().getVariable(this.variable.getQName().toString());
        try {
            return new Object[]{new XNumber(Double.parseDouble(value))};
        }
        catch (Exception exception) {
            return new Object[]{value};
        }
    }

    public void compile(ICompilerContext compilationContext) throws CodeGenerationError {
        compilationContext.in(this);
        compilationContext.append("fastXPathEngine.getVariable(");
        compilationContext.append("\"" + this.variable.getQName() + "\"");
        compilationContext.append(")");
        compilationContext.out();
    }
}

