/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import org.eclipse.tptp.platform.agentcontroller.internal.BufferConstant;
import org.eclipse.tptp.platform.agentcontroller.internal.Queue;
import org.eclipse.tptp.platform.agentcontroller.internal.exception.QueueFullException;

public class QueueImpl
implements Queue {
    private Object _queueLock = new Object();
    private Object[] _items = null;
    private boolean _done = false;
    private int _maxQueueSize;
    private int _itemCount = 0;
    private int _startItem = 0;
    private int _endItem = 0;

    public QueueImpl() {
        this(BufferConstant.TPTP_QUEUE_BUFFER_SIZE);
    }

    public QueueImpl(int size) {
        this._maxQueueSize = size;
        this._items = new Object[this._maxQueueSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this._queueLock;
        synchronized (object) {
            this._done = true;
            this._queueLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getItem() {
        Object object = this._queueLock;
        synchronized (object) {
            block10: {
                block9: {
                    if (!this._done) break block9;
                    return null;
                }
                if (this._itemCount == 0) {
                    try {
                        this._queueLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this._done) break block10;
                return null;
            }
            Object obj = this._items[this._startItem];
            --this._itemCount;
            ++this._startItem;
            if (this._startItem == this._maxQueueSize) {
                this._startItem = 0;
            }
            this._queueLock.notifyAll();
            return obj;
        }
    }

    public boolean isEmpty() {
        return this._itemCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putItem(Object obj) throws QueueFullException {
        Object object = this._queueLock;
        synchronized (object) {
            if (this._itemCount == this._maxQueueSize) {
                try {
                    this._queueLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new QueueFullException();
                }
            }
            this._items[this._endItem] = obj;
            ++this._itemCount;
            ++this._endItem;
            if (this._endItem == this._maxQueueSize) {
                this._endItem = 0;
            }
            this._queueLock.notifyAll();
        }
    }
}

