/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.agentcontroller.internal.config.AgentControllerEnvironment;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Application;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Variable;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.AbstractConfigurationImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.EclipseUtility;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;

public class ExtensionPointConfigurationImpl
extends AbstractConfigurationImpl {
    private static ExtensionPointConfigurationImpl _instance = null;
    private static String _exeFileExtension = "";

    static {
        if (System.getProperty("os.name").startsWith("Windows")) {
            _exeFileExtension = ".exe";
        }
    }

    public static ExtensionPointConfigurationImpl getInstance() {
        if (_instance == null) {
            _instance = new ExtensionPointConfigurationImpl();
        }
        return _instance;
    }

    private ExtensionPointConfigurationImpl() {
        this.load();
    }

    private void load() {
        if (EclipseUtility.getEclipseRoot() != null) {
            File javaExe;
            AgentControllerEnvironment acEnv = new AgentControllerEnvironment();
            TPTPLoggerImpl.log(3, "Initializing Agent Controller default configuration");
            acEnv.addVariable(new Variable("TEMP", System.getProperty("java.io.tmpdir"), Variable.REPLACE));
            acEnv.addVariable(new Variable("SYS_TEMP_DIR", System.getProperty("java.io.tmpdir"), Variable.REPLACE));
            acEnv.addVariable(new Variable("LOCAL_AGENT_TEMP_DIR", System.getProperty("java.io.tmpdir"), Variable.REPLACE));
            String os = Platform.getOS();
            String arch = Platform.getOSArch();
            String libenv = os.equals("win32") ? "PATH" : (os.equals("aix") ? "LIBPATH" : (os.equals("hpux") ? "SHLIB_PATH" : "LD_LIBRARY_PATH"));
            acEnv.addVariable(new Variable(libenv, EclipseUtility.getBundleInstallLocation("org.eclipse.hyades.execution." + os + "." + arch), "prepend"));
            String swtDllPath = EclipseUtility.getBundleStoreDir("org.eclipse.swt");
            if (swtDllPath != null) {
                if (System.getProperty("os.name").startsWith("Windows")) {
                    acEnv.addVariable(new Variable("PATH", swtDllPath, Variable.APPEND));
                } else {
                    acEnv.addVariable(new Variable("LD_LIBRARY_PATH", swtDllPath, Variable.APPEND));
                }
            }
            this.addConfiguration(acEnv);
            Application javaApplication = new Application();
            javaApplication.setExecutable("java.exe");
            String javaHome = System.getProperty("java.home");
            if (javaHome.endsWith(File.separator)) {
                javaHome = javaHome.substring(0, javaHome.length() - 1);
            }
            if ((javaExe = new File(String.valueOf(javaHome) + File.separator + "jre" + File.separator + "bin" + File.separator + "java" + _exeFileExtension)).exists() && javaExe.isFile()) {
                javaApplication.setPath(javaExe.getAbsolutePath());
            } else {
                javaExe = new File(String.valueOf(javaHome) + File.separator + "bin" + File.separator + "java" + _exeFileExtension);
                if (javaExe.exists() && javaExe.isFile()) {
                    javaApplication.setPath(javaExe.getAbsolutePath());
                } else {
                    javaApplication.setPath("java" + _exeFileExtension);
                }
            }
            javaApplication.setLocation(System.getProperty("java.io.tmpdir"));
            this.addConfiguration(javaApplication);
        }
    }
}

