/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

public class CircularBuffer {
    private byte[] _buffer;
    private int _r = 0;
    private int _w = 0;
    private boolean _done = false;
    private boolean _empty = true;
    private boolean _full = false;
    private Object _lock = new Object();

    public CircularBuffer(int size) {
        this._buffer = new byte[size];
    }

    public int available() {
        if (this._w > this._r) {
            return this._w - this._r;
        }
        if (this._w < this._r) {
            return this._buffer.length - (this._r - this._w);
        }
        if (this._empty) {
            return 0;
        }
        return this._buffer.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this._lock;
        synchronized (object) {
            while (this.available() > 0) {
                try {
                    this._lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    this._done = true;
                    this._lock.notifyAll();
                    return;
                }
            }
            this._done = true;
            this._lock.notifyAll();
        }
    }

    private int free() {
        return this._buffer.length - this.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] buffer, int offset, int len) {
        int correctLen = len;
        if (offset + len > buffer.length) {
            correctLen = buffer.length - offset;
        }
        Object object = this._lock;
        synchronized (object) {
            while (true) {
                if (!this._empty || this._done) {
                    if (!this._empty || !this._done) break;
                    return -1;
                }
                try {
                    this._lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    return -1;
                }
            }
            int byteToCopy = 0;
            byteToCopy = correctLen >= this.available() ? this.available() : correctLen;
            int i = 0;
            while (true) {
                if (i >= byteToCopy) {
                    if (byteToCopy > 0) {
                        this._full = false;
                    }
                    if (this._r == this._w) {
                        this._empty = true;
                        this._full = false;
                    }
                    this._lock.notifyAll();
                    return byteToCopy;
                }
                buffer[offset + i] = this._buffer[this._r++];
                if (this._r >= this._buffer.length) {
                    this._r = 0;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(byte[] buffer, int offset, int len) {
        int correctLen = len;
        if (offset + len > buffer.length) {
            correctLen = buffer.length - offset;
        }
        Object object = this._lock;
        synchronized (object) {
            while (true) {
                if (this.free() >= correctLen || this._done) {
                    if (!this._full || !this._done) break;
                    return -1;
                }
                try {
                    this._lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    return -1;
                }
            }
            int byteToCopy = correctLen;
            int i = 0;
            while (true) {
                if (i >= byteToCopy) {
                    if (byteToCopy > 0) {
                        this._empty = false;
                    }
                    if (this._r == this._w) {
                        this._empty = false;
                        this._full = true;
                    }
                    this._lock.notifyAll();
                    return byteToCopy;
                }
                this._buffer[this._w++] = buffer[offset + i];
                if (this._w >= this._buffer.length) {
                    this._w = 0;
                }
                ++i;
            }
        }
    }
}

