/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.refactor.listeners;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.refactor.RefactorResourceHandler;
import org.eclipse.jst.j2ee.refactor.operations.OptionalRefactorHandler;
import org.eclipse.jst.j2ee.refactor.operations.ProjectDeleteDataModelProvider;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactorMetadata;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRenameDataModelProvider;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.builder.DependencyGraphManager;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class ProjectRefactoringListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public static final String PROJECT_REFACTORING_JOB_FAMILY = "org.eclipse.jst.j2ee.refactor.project";
    private final Map deletedProjectMetadata = new HashMap();

    public ProjectRefactoringListener() {
        DependencyGraphManager.getInstance();
    }

    public void resourceChanged(IResourceChangeEvent event2) {
        try {
            if (event2.getType() == 4) {
                IProject project = (IProject)event2.getResource();
                if (ModuleCoreNature.getModuleCoreNature((IProject)project) != null && ProjectFacetsManager.create((IProject)project) != null) {
                    this.cacheDeletedProjectMetadata(project);
                }
            } else {
                event2.getDelta().accept((IResourceDeltaVisitor)this);
            }
        }
        catch (CoreException ce) {
            Logger.getLogger().logError(ce);
        }
    }

    private synchronized void cacheDeletedProjectMetadata(IProject project) {
        ProjectRefactorMetadata metadata2 = new ProjectRefactorMetadata(project, ProjectRefactorMetadata.REFERER_CACHING);
        metadata2.computeMetadata();
        metadata2.computeServers();
        metadata2.computeDependentMetadata(ProjectRefactorMetadata.REF_CACHING, DependencyGraphManager.getInstance().getDependencyGraph().getReferencingComponents(project));
        this.deletedProjectMetadata.put(project.getName(), metadata2);
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource instanceof IWorkspaceRoot) {
            return true;
        }
        if (resource instanceof IProject) {
            this.processProjectDelta((IProject)resource, delta);
        }
        return false;
    }

    private synchronized void processProjectDelta(IProject project, IResourceDelta delta) throws CoreException {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (kind == 2) {
            ProjectRefactorMetadata metadata2;
            if (this.hasDeletedRemovedFlags(flags) && (metadata2 = (ProjectRefactorMetadata)this.deletedProjectMetadata.remove(project.getName())) != null && OptionalRefactorHandler.getInstance().shouldRefactorDeletedProject(metadata2)) {
                this.processDelete(metadata2);
            }
        } else if (kind == 1 && this.hasRenamedAddedFlags(flags)) {
            String originalName = delta.getMovedFromPath().lastSegment();
            ProjectRefactorMetadata originalMetadata = (ProjectRefactorMetadata)this.deletedProjectMetadata.remove(originalName);
            ProjectRefactorMetadata newMetadata = new ProjectRefactorMetadata(project);
            if (originalMetadata != null && OptionalRefactorHandler.getInstance().shouldRefactorRenamedProject(originalMetadata)) {
                newMetadata.computeMetadata(originalMetadata.getProject());
                this.processRename(originalMetadata, newMetadata, delta);
            }
        }
    }

    private boolean hasRenamedAddedFlags(int flags) {
        return (flags & 0x80000) > 0 && (flags & 0x1000) > 0;
    }

    private boolean hasDeletedRemovedFlags(int flags) {
        return (flags & 0x2000) == 0 && (flags & 0x40000) == 0;
    }

    private void processRename(final ProjectRefactorMetadata originalMetadata, final ProjectRefactorMetadata newMetadata, final IResourceDelta delta) {
        WorkspaceJob job = new WorkspaceJob("J2EEProjectRenameJob"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IDataModel dataModel = DataModelFactory.createDataModel(new ProjectRenameDataModelProvider());
                dataModel.setProperty("ProjectRefactoringProperties.PROJECT_METADATA", newMetadata);
                dataModel.setProperty("ProjectRefactoringProperties.ORIGINAL_PROJECT_METADATA", originalMetadata);
                dataModel.setProperty("ProjectRefactoringProperties.RESOURCE_DELTA", delta);
                try {
                    dataModel.getDefaultOperation().execute(monitor, null);
                }
                catch (Exception e) {
                    String msg = RefactorResourceHandler.getString("error_updating_project_on_rename", new Object[]{originalMetadata.getProjectName()});
                    Logger.getLogger().logError(msg);
                    Logger.getLogger().logError(e);
                    return new Status(4, "org.eclipse.jst.j2ee", 0, msg, (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return ProjectRefactoringListener.PROJECT_REFACTORING_JOB_FAMILY.equals(family);
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    private void processDelete(final ProjectRefactorMetadata metadata2) {
        WorkspaceJob job = new WorkspaceJob("J2EEProjectDeleteJob"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IDataModel dataModel = DataModelFactory.createDataModel(new ProjectDeleteDataModelProvider());
                dataModel.setProperty("ProjectRefactoringProperties.PROJECT_METADATA", metadata2);
                try {
                    dataModel.getDefaultOperation().execute(monitor, null);
                }
                catch (Exception e) {
                    String msg = RefactorResourceHandler.getString("error_updating_project_on_delete", new Object[]{metadata2.getProjectName()});
                    Logger.getLogger().logError(msg);
                    Logger.getLogger().logError(e);
                    return new Status(4, "org.eclipse.jst.j2ee", 0, msg, (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return ProjectRefactoringListener.PROJECT_REFACTORING_JOB_FAMILY.equals(family);
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }
}

