/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.util.logging.Level;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.AppClient50ExportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.XmlBasedImportStrategyImpl;

public class AppClient12ImportStrategyImpl
extends XmlBasedImportStrategyImpl {
    protected static Discriminator discriminator;

    public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
        return AppClient12ImportStrategyImpl.getDiscriminator().createImportStrategy(old, newArchive);
    }

    public ApplicationClientFile getApplicationClientFile() {
        return (ApplicationClientFile)this.getArchive();
    }

    public static ArchiveTypeDiscriminator getDiscriminator() {
        if (discriminator == null) {
            discriminator = new Discriminator();
        }
        return discriminator;
    }

    public void importMetaData() throws Exception {
        this.loadDeploymentDescriptor();
    }

    public void loadDeploymentDescriptor() throws Exception {
        ApplicationClient client = (ApplicationClient)this.primLoadDeploymentDescriptor();
        this.versionCheck(client);
        ApplicationClientFile appClientFile = this.getApplicationClientFile();
        appClientFile.setDeploymentDescriptor(client);
        if (client.getVersionID() >= 50) {
            appClientFile.setExportStrategy(new AppClient50ExportStrategyImpl());
        }
    }

    public static class Discriminator
    extends ArchiveTypeDiscriminatorImpl {
        protected static final String className = Discriminator.class.getName();

        public boolean canImport(Archive anArchive) {
            String methodName = "canImport";
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "ENTRY archive [ {0} ]", anArchive);
            Archive.ModuleVersionEnum version = Archive.ModuleVersionEnum.CLIENT12;
            if (anArchive.isSetCanImportAs(version)) {
                boolean canImport = anArchive.getCanImportAs(version);
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN cached CLIENT12 value [ {0} ]", Boolean.toString(canImport));
                return canImport;
            }
            boolean canImport = anArchive.containsFile("META-INF/application-client.xml");
            anArchive.setCanImportAs(version, canImport);
            anArchive.closeArchiveZipFile();
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN CLIENT12 [ {0} ]", Boolean.toString(canImport));
            return canImport;
        }

        public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
            return new AppClient12ImportStrategyImpl();
        }

        public String getUnableToOpenMessage() {
            return this.getXmlDDMessage(CommonArchiveResourceHandler.Application_Client_Jar_Fil, "META-INF/application-client.xml");
        }

        public Archive createConvertedArchive() {
            return ImportStrategyImpl.getArchiveFactory().createApplicationClientFile();
        }
    }
}

