/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.hyades.execution.local.file.FileManagerFactory;
import org.eclipse.hyades.internal.execution.core.file.ServerNotAvailableException;
import org.eclipse.hyades.internal.execution.local.common.ConsoleNotStartedException;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Node;

public class Console
extends Thread
implements Constants {
    protected ServerSocket _sock;
    protected DataProcessor _processor;
    protected long _ip = 0L;
    protected long _port = 0L;
    protected Node _node;
    private boolean _started = false;
    private boolean _valid = true;
    private Socket _activeConnection;

    public Console() {
        this.setName("Console");
        this.setDaemon(true);
    }

    public Console(Node node) {
        this();
        this._node = node;
    }

    public Console(String name) {
        super(name);
        this.setDaemon(true);
    }

    public Console(ThreadGroup group, String name) {
        super(group, name);
        this.setDaemon(true);
    }

    public long getIP() throws ConsoleNotStartedException {
        if (this._ip == 0L) {
            throw new ConsoleNotStartedException();
        }
        return this._ip;
    }

    public long getPort() throws ConsoleNotStartedException {
        if (this._port == 0L) {
            throw new ConsoleNotStartedException();
        }
        return this._port;
    }

    public ServerSocket getServerSocket() throws ConsoleNotStartedException {
        if (this._sock == null) {
            throw new ConsoleNotStartedException();
        }
        return this._sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block28: {
            block27: {
                buffer = new byte[1024];
                port = 0;
                started = false;
                while (!started) {
                    try {
                        started = true;
                        this._sock = new ServerSocket(port, 1);
                    }
                    catch (Exception v0) {
                        port = (short)(port + 1);
                        started = false;
                    }
                }
                this._port = this._sock.getLocalPort();
                localHost = null;
                try {
                    localHost = InetAddress.getLocalHost();
                    bytes = localHost.getAddress();
                    this._ip = (long)(bytes[3] << 24 & -16777216) | (long)(bytes[2] << 16 & 0xFF0000) | (long)(bytes[1] << 8 & 65280) | (long)(bytes[0] & 255);
                }
                catch (UnknownHostException v1) {}
                serverCanReach = false;
                try {
                    fileManager = FileManagerFactory.getInstance().create(this._node.getConnection());
                    serverCanReach = fileManager.determineServerReach(localHost.getHostAddress(), (int)this._port);
                }
                catch (ServerNotAvailableException e) {
                    e.printStackTrace();
                }
                e = this;
                synchronized (e) {
                    this._started = true;
                    this.notify();
                }
                if (!serverCanReach) break block27;
                while (this._valid) {
                    is = null;
                    this._activeConnection = null;
                    try {
                        this._activeConnection = this._sock.accept();
                        is = this._activeConnection.getInputStream();
                        this._activeConnection.setSoTimeout(1000);
                        complete = false;
                        if (true) ** GOTO lbl78
                    }
                    catch (Exception v3) {
                        return;
                    }
                    do {
                        length = 0;
                        try {
                            length = is.read(buffer);
                        }
                        catch (InterruptedIOException v4) {
                            if (this._processor != null) {
                                this._processor.waitingForData();
                            }
                        }
                        catch (IOException v5) {
                            try {
                                this._activeConnection.close();
                            }
                            catch (IOException v6) {}
                            complete = true;
                        }
                        if (length < 0) {
                            try {
                                this._activeConnection.close();
                            }
                            catch (IOException v7) {}
                            complete = true;
                        } else if (length > 0 && this._processor != null) {
                            this._processor.incommingData(buffer, length, this._activeConnection.getInetAddress());
                        }
                        if (this._valid) continue;
                        try {
                            this._activeConnection.close();
                        }
                        catch (IOException v8) {}
                        complete = true;
lbl78:
                        // 3 sources

                    } while (!complete);
                }
                break block28;
            }
            this._ip = 0L;
            this._port = 0L;
            this.close();
        }
    }

    public void setDataProcessor(DataProcessor processor) {
        this._processor = processor;
    }

    public DataProcessor getDataProcessor() {
        return this._processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Console console = this;
        synchronized (console) {
            this._valid = true;
            super.start();
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            } while (!this._started);
        }
    }

    public void write(String data) {
        if (this._activeConnection != null) {
            try {
                this._activeConnection.getOutputStream().write(data.getBytes("UTF-8"));
            }
            catch (Exception exception) {}
        }
    }

    public void close() {
        if (this._sock != null) {
            try {
                this._sock.close();
            }
            catch (IOException iOException) {}
        }
        this._valid = false;
    }
}

