/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file.dynamic;

import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.execution.core.loader.ScopedChannelClassLoader;
import org.eclipse.hyades.internal.execution.core.file.FileSystemServices;
import org.eclipse.hyades.internal.execution.core.file.communicator.ChannelCommunicatorFactory;
import org.eclipse.hyades.internal.execution.core.file.communicator.IChannelCommunicator;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IFileServerCommand;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;

public abstract class AbstractFileServerCommand
implements IFileServerCommand {
    private String context;
    private IFileManagerExtended.Cookie cookie;
    private Class identity;
    private IProgressMonitor monitor;
    private IFileManagerExtended.Option[] options;
    private IFileServerCommand state;

    AbstractFileServerCommand(String context, Class identity) {
        this(context, identity, IFileManagerExtended.Cookie.NONE, IFileManagerExtended.Option.NONE, (IProgressMonitor)new NullProgressMonitor());
    }

    AbstractFileServerCommand(String context, Class identity, IFileManagerExtended.Cookie cookie, IFileManagerExtended.Option[] options, IProgressMonitor monitor) {
        if (this.cookie == null) {
            // empty if block
        }
        this.context = context;
        this.identity = identity;
        this.cookie = cookie;
        this.options = options;
        this.monitor = monitor;
        FileSystemServices.println("An abstract file server command is created with identity " + this.identity + "\r\n\t\tand context " + this.context + "\r\n\t\tand cookie " + cookie + "\r\n\t\tand options " + options + "\r\n\t\tand progress monitor " + this.monitor, this);
    }

    public void dispose() {
        FileSystemServices.println("File server command with identity " + this.identity + " is now disposed", this);
        this.state.dispose();
    }

    public final void execute() throws IOException {
        if (this.state != null) {
            FileSystemServices.println("Executing file server command with identity " + this.identity, this);
            this.state.execute();
        } else {
            System.out.println("There is no behavior defined for the current state of this command: " + this);
        }
    }

    IFileManagerExtended.Option[] getOptions() {
        return this.options;
    }

    void setState(IFileServerCommand state) {
        this.state = state;
    }

    abstract class Client
    extends State {
        Client(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            this.communicator.send(AbstractFileServerCommand.this.identity.getName(), true);
            ScopedChannelClassLoader.Provider provider = new ScopedChannelClassLoader.Provider(AbstractFileServerCommand.this.context, Thread.currentThread().getContextClassLoader(), this.channel, this.channel, 64);
            Observer observer = new Observer(this){
                final /* synthetic */ Client this$1;
                {
                    this.this$1 = client;
                }

                public void update(Observable observable, Object argument) {
                    FileSystemServices.println("Class consumed by server (from providing client) " + argument, this);
                }
            };
            provider.addObserver(observer);
            provider.provide();
            provider.deleteObserver(observer);
        }
    }

    abstract class Server
    extends State {
        Server(ISocketChannel client) {
            super(client);
        }

        public void execute() throws IOException {
        }
    }

    abstract class State
    implements IFileServerCommand {
        final ISocketChannel channel;
        final IChannelCommunicator communicator;

        State(ISocketChannel channel) {
            this.channel = channel;
            this.communicator = ChannelCommunicatorFactory.getInstance().create(this.channel, this.channel);
        }

        public void dispose() {
            try {
                if (this.channel != null && this.channel.isOpen()) {
                    this.channel.close();
                }
            }
            catch (IOException iOException) {}
        }

        boolean isOpen() {
            return this.channel != null ? this.channel.isOpen() : false;
        }
    }
}

