/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileLocation;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.internal.execution.core.file.DeleteDirectoryCommand;
import org.eclipse.hyades.internal.execution.core.file.DeleteFileCommand;
import org.eclipse.hyades.internal.execution.core.file.GetFileCommand;
import org.eclipse.hyades.internal.execution.core.file.IDeleteDirectoryCommand;
import org.eclipse.hyades.internal.execution.core.file.IDeleteFileCommand;
import org.eclipse.hyades.internal.execution.core.file.IFileServerCommand;
import org.eclipse.hyades.internal.execution.core.file.IFileServerCommandFactory;
import org.eclipse.hyades.internal.execution.core.file.IGetFileCommand;
import org.eclipse.hyades.internal.execution.core.file.IListContentCommand;
import org.eclipse.hyades.internal.execution.core.file.IModifyPermissionCommand;
import org.eclipse.hyades.internal.execution.core.file.IPutFileCommand;
import org.eclipse.hyades.internal.execution.core.file.IQueryServerStatusCommand;
import org.eclipse.hyades.internal.execution.core.file.InvalidFileServerCommandException;
import org.eclipse.hyades.internal.execution.core.file.ListContentCommand;
import org.eclipse.hyades.internal.execution.core.file.ModifyPermissionCommand;
import org.eclipse.hyades.internal.execution.core.file.PutFileCommand;
import org.eclipse.hyades.internal.execution.core.file.QueryServerStatusCommand;
import org.eclipse.hyades.internal.execution.core.file.ServerNotAvailableException;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;
import org.eclipse.hyades.internal.execution.core.file.socket.SocketChannelFactory;

public final class FileServerCommandFactory
implements IFileServerCommandFactory {
    private static final float DEFAULT_CONNECT_RETRY_CALCULATION_FACTOR = 0.9f;
    private static final int DEFAULT_CONNECT_RETRY_CUTOFF = 2000;
    private static final int DEFAULT_CONNECT_RETRY_INITIAL_TIMEOUT = 3000;
    private static final int DEFAULT_CONNECT_RETRY_OFFSET = 200;
    private static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    private static final HashMap factories = new HashMap();
    private static final IFileServerCommandFactory factory = new FileServerCommandFactory();
    private InetSocketAddress address;
    static /* synthetic */ Class class$0;

    public static synchronized IFileServerCommandFactory getInstance() {
        return factory;
    }

    public static synchronized IFileServerCommandFactory getInstance(IFileLocation fileServerLocation) {
        int port;
        InetAddress address = fileServerLocation.getInetAddress();
        InetSocketAddress fileServerAddress = new InetSocketAddress(address, port = fileServerLocation.getPort());
        IFileServerCommandFactory factory = (IFileServerCommandFactory)factories.get(fileServerAddress);
        if (factory == null) {
            factory = new FileServerCommandFactory(fileServerAddress);
            factories.put(fileServerAddress, factory);
        }
        return factory;
    }

    private FileServerCommandFactory() {
    }

    private FileServerCommandFactory(InetSocketAddress address) {
        this.address = address;
    }

    private synchronized ISocketChannel connectSocketChannel() throws ServerNotAvailableException {
        return this.connectSocketChannel(3200);
    }

    private synchronized ISocketChannel connectSocketChannel(int timeout) throws ServerNotAvailableException {
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(true);
            socketChannel.socket().setSoTimeout(10000);
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setReuseAddress(true);
            socketChannel.connect(this.address);
            return SocketChannelFactory.getInstance().create(socketChannel);
        }
        catch (SocketException e1) {
            if (e1 instanceof BindException || e1 instanceof ConnectException) {
                e1.printStackTrace();
                if (e1.getMessage().indexOf("refuse") != -1) {
                    throw new ServerNotAvailableException(e1);
                }
                try {
                    if (timeout < 2000) {
                        throw new ServerNotAvailableException(e1);
                    }
                    System.err.println("About to wait for " + timeout + " seconds!");
                    this.wait(timeout);
                    return this.connectSocketChannel(this.recalculateTimeout(timeout));
                }
                catch (InterruptedException e2) {
                    throw new ServerNotAvailableException(e2);
                }
            }
            throw new ServerNotAvailableException(e1);
        }
        catch (Throwable t) {
            throw new ServerNotAvailableException(t);
        }
    }

    public IDeleteDirectoryCommand createDeleteDirectoryCommand(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws ServerNotAvailableException {
        return new DeleteDirectoryCommand(this.connectSocketChannel(), remoteIdentifiers, monitor);
    }

    public IDeleteFileCommand createDeleteFileCommand(IFileManagerExtended.Cookie cookie, IProgressMonitor monitor) {
        return new DeleteFileCommand(cookie, monitor);
    }

    public IDeleteFileCommand createDeleteFileCommand(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws ServerNotAvailableException {
        return new DeleteFileCommand(this.connectSocketChannel(), remoteIdentifiers, monitor);
    }

    public IFileServerCommand createFileServerCommand(String identity, ISocketChannel clientChannel) throws InvalidFileServerCommandException {
        try {
            Class<?> classObject = Class.forName(identity);
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Constructor<?> constructor = classObject.getConstructor(classArray);
            IFileServerCommand command = (IFileServerCommand)constructor.newInstance(clientChannel);
            return command;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InvalidFileServerCommandException();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new InvalidFileServerCommandException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InvalidFileServerCommandException();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new InvalidFileServerCommandException();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InvalidFileServerCommandException();
        }
    }

    public IGetFileCommand createGetFileCommand(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws ServerNotAvailableException {
        return new GetFileCommand(this.connectSocketChannel(), localIdentifiers, remoteIdentifiers, options, monitor);
    }

    public IListContentCommand createListContentCommand(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) {
        return new ListContentCommand(remoteIdentifiers, monitor);
    }

    public IModifyPermissionCommand createModifyPermissionCommand(IFileManagerExtended.FileIdentifierList remoteIdentifiers, String permissionDirective, IProgressMonitor monitor) {
        return new ModifyPermissionCommand(remoteIdentifiers, permissionDirective, monitor);
    }

    public IPutFileCommand createPutFileCommand(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws ServerNotAvailableException {
        return new PutFileCommand(this.connectSocketChannel(), cookie, localIdentifiers, remoteIdentifiers, options, monitor);
    }

    public IQueryServerStatusCommand createQueryServerStatusCommand() throws ServerNotAvailableException {
        return new QueryServerStatusCommand(IFileManagerExtended.Cookie.NONE, this.connectSocketChannel());
    }

    private int recalculateTimeout(int timeout) {
        float recalculatedTimeout = (float)timeout * 0.9f + 200.0f;
        return Math.round(recalculatedTimeout);
    }

    public void reset() {
    }
}

