/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.invocation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.invocation.CallData;
import org.eclipse.hyades.execution.invocation.RemoteReferenceInputStream;
import org.eclipse.hyades.execution.invocation.RemoteReferenceOutputStream;
import org.eclipse.hyades.execution.invocation.ReturnData;

public class Marshaller {
    private static final int RETURN_VALUE_IN_STREAM = 88;
    private static final int RETURN_VALUE_NOT_IN_STREAM = 188;
    private static final int WAIT_FOR_RETURN_DATA_TIMEOUT = 180000;
    private static HashMap instanceMap = new HashMap();
    private static ArrayList returnValueQueue = new ArrayList();

    private Marshaller() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInstanceToMap(Integer uniqueId, Object instance) {
        HashMap hashMap = instanceMap;
        synchronized (hashMap) {
            instanceMap.put(uniqueId, Marshaller.createReferenceProxy(instance));
        }
    }

    private static ReferenceProxy createReferenceProxy(Object referent) {
        return new ReferenceProxy(referent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getInstanceFromMap(Integer uniqueId) {
        Object instance = null;
        HashMap hashMap = instanceMap;
        synchronized (hashMap) {
            ReferenceProxy referenceProxy = (ReferenceProxy)instanceMap.get(uniqueId);
            if (referenceProxy != null) {
                instance = referenceProxy.resolve();
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInstanceFromMap(Integer uniqueId) {
        HashMap hashMap = instanceMap;
        synchronized (hashMap) {
            if (instanceMap.containsKey(uniqueId)) {
                instanceMap.remove(uniqueId);
            }
        }
    }

    public static byte[] marshalMethodCall(CallData callData) throws IOException {
        ByteArrayOutputStream outByteStream = new ByteArrayOutputStream();
        RemoteReferenceOutputStream outStream = new RemoteReferenceOutputStream(outByteStream);
        outStream.writeInt(callData.getTargetId());
        outStream.writeObject(callData.getArgTypes());
        outStream.writeObject(callData.getCallArgs());
        outStream.writeObject(callData.getCall());
        outStream.flush();
        byte[] bytes = outByteStream.toByteArray();
        outStream.close();
        outByteStream.close();
        return bytes;
    }

    public static CallData unmarshalMethodCall(byte[] callData) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inByteStream = new ByteArrayInputStream(callData);
        RemoteReferenceInputStream in = new RemoteReferenceInputStream(inByteStream);
        Object tmp = null;
        int targetId = in.readInt();
        tmp = in.readObject();
        if (!(tmp instanceof Class[])) {
            throw new ClassCastException("Expected an Class[] but got \"" + tmp.getClass().getName() + "\"");
        }
        Class[] argTypes = (Class[])tmp;
        tmp = in.readObject();
        if (!(tmp instanceof Object[])) {
            throw new ClassCastException("Expected an Object[] but got \"" + tmp.getClass().getName() + "\"");
        }
        Object[] callArgs = (Object[])tmp;
        tmp = in.readObject();
        if (!(tmp instanceof String)) {
            throw new ClassCastException("Expected a String but got \"" + tmp.getClass().getName() + "\"");
        }
        String call = (String)tmp;
        in.close();
        inByteStream.close();
        return new CallData(new Integer(targetId), argTypes, callArgs, call);
    }

    public static byte[] marshalReturnValue(ReturnData rtnData) throws IOException {
        ByteArrayOutputStream outByteStream = new ByteArrayOutputStream();
        RemoteReferenceOutputStream outStream = new RemoteReferenceOutputStream(outByteStream);
        outStream.writeInt(rtnData.getTargetId());
        outStream.writeObject(rtnData.getArgTypes());
        outStream.writeObject(rtnData.getCall());
        if (rtnData.getReturnValue() != null) {
            outStream.writeInt(88);
            outStream.writeObject(rtnData.getReturnValue());
        } else {
            outStream.writeInt(188);
        }
        outStream.flush();
        byte[] bytes = outByteStream.toByteArray();
        outStream.close();
        outByteStream.close();
        return bytes;
    }

    public static ReturnData unmarshalReturnValue(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inByteStream = new ByteArrayInputStream(data);
        RemoteReferenceInputStream in = new RemoteReferenceInputStream(inByteStream);
        Object tmp = null;
        int targetId = in.readInt();
        tmp = in.readObject();
        if (!(tmp instanceof Class[])) {
            throw new ClassCastException("Expected an Class[] but got \"" + tmp.getClass().getName() + "\"");
        }
        Class[] argTypes = (Class[])tmp;
        tmp = in.readObject();
        if (!(tmp instanceof String)) {
            throw new ClassCastException("Expected a String but got \"" + tmp.getClass().getName() + "\"");
        }
        String call = (String)tmp;
        int rtnValPresence = in.readInt();
        Object rtnVal = null;
        if (rtnValPresence == 88) {
            rtnVal = in.readObject();
        }
        in.close();
        inByteStream.close();
        return new ReturnData(new Integer(targetId), argTypes, call, rtnVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueReturnValue(ReturnData value) {
        ArrayList arrayList = returnValueQueue;
        synchronized (arrayList) {
            returnValueQueue.add(value);
            returnValueQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnData unqueueReturnValue() {
        ReturnData rtnVal = null;
        ArrayList arrayList = returnValueQueue;
        synchronized (arrayList) {
            if (!returnValueQueue.isEmpty()) {
                rtnVal = (ReturnData)returnValueQueue.remove(0);
            }
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnData peekReturnValue() {
        ReturnData rtnVal = null;
        ArrayList arrayList = returnValueQueue;
        synchronized (arrayList) {
            if (!returnValueQueue.isEmpty()) {
                rtnVal = (ReturnData)returnValueQueue.get(0);
            }
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReturnDataAvailable() {
        boolean rtnVal = false;
        ArrayList arrayList = returnValueQueue;
        synchronized (arrayList) {
            rtnVal = !returnValueQueue.isEmpty();
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForReturnData() {
        while (!Marshaller.isReturnDataAvailable()) {
            try {
                ArrayList arrayList = returnValueQueue;
                synchronized (arrayList) {
                    returnValueQueue.wait(180000L);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForReturnDataWithTimeout() throws InterruptedException {
        while (!Marshaller.isReturnDataAvailable()) {
            ArrayList arrayList = returnValueQueue;
            synchronized (arrayList) {
                returnValueQueue.wait(180000L);
            }
        }
    }

    private static class ReferenceProxy {
        private static IFactory factory;
        private final Object reference;

        static {
            try {
                factory = !Platform.isRunning() ? new PassThroughReferenceFactory() : new WeakReferenceFactory();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                factory = new PassThroughReferenceFactory();
            }
        }

        private ReferenceProxy(Object referent) {
            this.reference = factory.createReference(referent);
        }

        private Object resolve() {
            return factory.resolve(this.reference);
        }

        public String toString() {
            return factory.toString(this.reference);
        }

        private static interface IFactory {
            public Object createReference(Object var1);

            public Object resolve(Object var1);

            public String toString(Object var1);
        }

        private static class PassThroughReferenceFactory
        implements IFactory {
            private PassThroughReferenceFactory() {
            }

            public Object createReference(Object referent) {
                return referent;
            }

            public Object resolve(Object reference) {
                return reference;
            }

            public String toString(Object reference) {
                if (reference != null) {
                    return reference.toString();
                }
                return "null";
            }
        }

        private static class WeakReferenceFactory
        implements IFactory {
            private WeakReferenceFactory() {
            }

            public Object createReference(Object referent) {
                return new WeakReference<Object>(referent);
            }

            public Object resolve(Object reference) {
                return ((WeakReference)reference).get();
            }

            public String toString(Object reference) {
                Object referent;
                if (reference != null && (referent = ((WeakReference)reference).get()) != null) {
                    return referent.toString();
                }
                return "null";
            }
        }
    }
}

