/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.framework.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import org.eclipse.hyades.execution.core.DataChannelConnectionException;
import org.eclipse.hyades.execution.core.DataChannelCreationException;
import org.eclipse.hyades.execution.core.DataChannelNotInitializedException;
import org.eclipse.hyades.execution.core.IDataChannel;
import org.eclipse.hyades.execution.core.InvalidDataChannelAccessException;

public class DataChannelImpl
implements IDataChannel {
    protected boolean _isFlushing = false;
    protected boolean _isWriting = false;
    private boolean _isDCBufferCreated = false;
    private static String DC_BUFFER_NAME_ROOT = "hcbuffer";
    private static int _dc_buffer_num = 0;
    private static int DC_DEFAULT_BUFFER_SIZE = 0x100000;
    private static final int INPUT_BUFFER_SIZE = 8096;
    protected static final int FLUSH_TYPE_PIPED_OUTPUT_STREAM = 6;
    protected static final int FLUSH_TYPE_OUTPUT_STREAM = 5;
    protected static final int FLUSH_TYPE_BINARY_FILE = 4;
    protected static final int FLUSH_TYPE_ASCII_FILE = 3;
    protected static final int FLUSH_TYPE_RAC_FILE = 2;
    protected static final int FLUSH_TYPE_SOCKET = 1;
    protected static int DC_TYPE_FLUSHABLE = 1;
    protected static int DC_TYPE_FILLABLE = 2;
    private String _dc_buffer_name = null;
    private int _dc_buffer_handle = -1;
    private int _dc_type = 0;
    private int _dc_flushType = 0;
    protected OutputStream _dc_outputStream;
    private InputStream _dc_inputStream;
    private int _dc_buffer_size = 0;
    private String _file_name;
    private InetAddress _client_address;
    private int _client_port;

    static {
        try {
            System.loadLibrary("tptpShm");
        }
        catch (Throwable throwable) {
            System.out.println("Can't find hcclsm library.\n");
        }
    }

    private synchronized int incrementDCBufferNum() {
        int oldnum = _dc_buffer_num++;
        return oldnum;
    }

    public void create() throws DataChannelCreationException {
        int rc;
        if (this.getName() == null) {
            this.setName(String.valueOf(DC_BUFFER_NAME_ROOT) + String.valueOf(this.incrementDCBufferNum()));
        }
        if (this.getSize() == 0) {
            this.setSize(DC_DEFAULT_BUFFER_SIZE);
        }
        if ((rc = this.hc_createDCBuffer(this.getName(), this.getSize())) < 0) {
            if (rc == -518) {
                throw new DataChannelCreationException("Data Channel with name " + this.getName() + " already exists");
            }
            if (rc == -99) {
                throw new DataChannelCreationException("Could not allocate memory");
            }
            if (rc == -504) {
                throw new DataChannelCreationException("Data Channel size " + this.getSize() + " is invalid");
            }
            if (rc == -505) {
                throw new DataChannelCreationException("Data Channel name " + this.getName() + " is invalid");
            }
            if (rc < -500) {
                throw new DataChannelCreationException("Implementation failure code: " + rc);
            }
            throw new DataChannelCreationException();
        }
        this.setHandle(rc);
        this._isDCBufferCreated = true;
    }

    public synchronized void destroy() {
        if (this.isDCBufferCreated()) {
            this.hc_destroyDCBuffer(this.getHandle());
            this._isDCBufferCreated = false;
        }
    }

    private void hc_destroy() {
        this.destroy();
    }

    public void connect() throws DataChannelConnectionException {
        if (this.getName() == null) {
            throw new DataChannelConnectionException("No name has been set");
        }
        int rc = this.hc_attachToDCBuffer(this.getName());
        if (rc < 0) {
            if (rc == -3) {
                throw new DataChannelConnectionException("Data Channel with name " + this.getName() + " does not exist");
            }
            if (rc == -99) {
                throw new DataChannelConnectionException("Could not allocate memory");
            }
            if (rc == -505) {
                throw new DataChannelConnectionException("Data Channel name " + this.getName() + " is invalid");
            }
            if (rc < -500) {
                throw new DataChannelConnectionException("Implementation failure code: " + rc);
            }
            throw new DataChannelConnectionException();
        }
        this.setHandle(rc);
        this._isDCBufferCreated = true;
    }

    public void disconnect() {
        this.stopFlushing();
        this.hc_detachFromDCBuffer(this.getHandle());
    }

    public void write(byte[] bytes) throws IOException, InvalidDataChannelAccessException {
        if (!this.isFillable()) {
            throw new InvalidDataChannelAccessException();
        }
        if (!this.isDCBufferCreated()) {
            throw new InvalidDataChannelAccessException();
        }
        int rc = this.hc_writeToDCBuffer(this.getHandle(), bytes, bytes.length);
        if (rc < 0) {
            throw new IOException();
        }
    }

    public void setOutputStream(OutputStream outstr) throws InvalidDataChannelAccessException, DataChannelNotInitializedException {
        if (!this.isFlushable()) {
            throw new InvalidDataChannelAccessException();
        }
        if (!this.isDCBufferCreated()) {
            throw new DataChannelNotInitializedException();
        }
        this.startFlushingToStream(outstr);
    }

    public OutputStream getOutputStream() throws InvalidDataChannelAccessException, DataChannelNotInitializedException {
        return this._dc_outputStream;
    }

    public void setInputStream(InputStream instr) throws InvalidDataChannelAccessException, DataChannelNotInitializedException {
        if (!this.isFillable()) {
            throw new InvalidDataChannelAccessException();
        }
        if (this.isDCBufferCreated()) {
            this._dc_inputStream = instr;
            WriterThread writer = new WriterThread();
            try {
                writer.start();
                writer.join();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Thread was interrupted before writer thread stopped");
            }
        } else {
            throw new DataChannelNotInitializedException();
        }
    }

    public InputStream getInputStream() throws InvalidDataChannelAccessException, DataChannelNotInitializedException {
        return this._dc_inputStream;
    }

    public void startFlushingToFile(String flushtofilename) {
        this.setFlushType(2);
        this.setFileName(flushtofilename);
        if (this.isDCBufferCreated() && !this.isFlushing() && this.isFlushable()) {
            FlusherThread flusher = new FlusherThread();
            try {
                flusher.start();
                flusher.join();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Thread was interrupted before flusher thread stopped");
            }
        }
    }

    public void startFlushingToSocket(InetAddress flushtosocketaddress, int flushtosocketport) {
        this.setFlushType(1);
        this.setInetAddress(flushtosocketaddress);
        this.setPort(flushtosocketport);
        if (this.isDCBufferCreated() && !this.isFlushing() && this.isFlushable()) {
            FlusherThread flusher = new FlusherThread();
            try {
                flusher.start();
                flusher.join();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Thread was interrupted before flusher thread stopped");
            }
        }
    }

    public void startFlushingToStream(OutputStream outStr) {
        if (this.isDCBufferCreated() && !this.isFlushing() && this.isFlushable()) {
            this.setFlushType(5);
            this._dc_outputStream = outStr;
            FlusherThread flusher = new FlusherThread();
            try {
                flusher.start();
                while (!this.isFlushing()) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Thread was interrupted before flusher thread stopped");
            }
        }
    }

    public synchronized void stopFlushing() {
        if (this.isDCBufferCreated() && this.isFlushing()) {
            int rc = this.hc_stopFlushingDCBuffer(this.getHandle());
            this._isFlushing = false;
        }
    }

    public void setFlushable() throws InvalidDataChannelAccessException {
        if (this.isFillable()) {
            throw new InvalidDataChannelAccessException();
        }
        this._dc_type = DC_TYPE_FLUSHABLE;
    }

    public boolean isFlushable() {
        return this._dc_type == DC_TYPE_FLUSHABLE;
    }

    public void setFillable() throws InvalidDataChannelAccessException {
        if (this.isFlushable()) {
            throw new InvalidDataChannelAccessException();
        }
        this._dc_type = DC_TYPE_FILLABLE;
    }

    public boolean isFillable() {
        return this._dc_type == DC_TYPE_FILLABLE;
    }

    protected native void hc_destroyDCBuffer(int var1);

    protected native void hc_detachFromDCBuffer(int var1);

    private native int hc_validateDCBufferSize(int var1);

    private native int hc_createDCBuffer(String var1, int var2);

    private native int hc_attachToDCBuffer(String var1);

    private native int hc_stopFlushingDCBuffer(int var1);

    protected native int hc_flushRACDCBufferToFile(int var1, String var2);

    protected native int hc_flushASCIIDCBufferToFile(int var1, String var2);

    protected native int hc_flushBinaryDCBufferToFile(int var1, String var2);

    protected native int hc_flushDCBufferToSocket(int var1, byte[] var2, int var3);

    protected native int hc_flushDCBufferToStream(int var1, OutputStream var2);

    protected native int hc_writeToDCBuffer(int var1, byte[] var2, int var3);

    public String getName() {
        return this._dc_buffer_name;
    }

    public int getFlushType() {
        return this._dc_flushType;
    }

    public int getSize() {
        return this._dc_buffer_size;
    }

    public int getHandle() {
        return this._dc_buffer_handle;
    }

    public String getFileName() {
        return this._file_name;
    }

    public InetAddress getInetAddress() {
        return this._client_address;
    }

    public int getPort() {
        return this._client_port;
    }

    public boolean isFlushing() {
        return this._isFlushing;
    }

    public boolean isDCBufferCreated() {
        return this._isDCBufferCreated;
    }

    public void setName(String name) {
        this._dc_buffer_name = new String(name);
    }

    private void setFlushType(int type) {
        this._dc_flushType = type;
    }

    public void setSize(int size) {
        this._dc_buffer_size = this.hc_validateDCBufferSize(size);
        if (this._dc_buffer_size <= 0) {
            this._dc_buffer_size = DC_DEFAULT_BUFFER_SIZE;
        }
    }

    private void setHandle(int handle) {
        this._dc_buffer_handle = handle;
    }

    private void setFileName(String filename) {
        this._file_name = new String(filename);
    }

    private void setInetAddress(InetAddress address) {
        this._client_address = address;
    }

    private void setPort(int portnum) {
        this._client_port = portnum;
    }

    class FlusherThread
    extends Thread {
        FlusherThread() {
        }

        public void run() {
            int rc = -1;
            if (DataChannelImpl.this.isDCBufferCreated() && !DataChannelImpl.this.isFlushing()) {
                DataChannelImpl.this._isFlushing = true;
                switch (DataChannelImpl.this.getFlushType()) {
                    case 2: {
                        rc = DataChannelImpl.this.hc_flushRACDCBufferToFile(DataChannelImpl.this.getHandle(), DataChannelImpl.this.getFileName());
                        break;
                    }
                    case 3: {
                        rc = DataChannelImpl.this.hc_flushASCIIDCBufferToFile(DataChannelImpl.this.getHandle(), DataChannelImpl.this.getFileName());
                        break;
                    }
                    case 4: {
                        rc = DataChannelImpl.this.hc_flushBinaryDCBufferToFile(DataChannelImpl.this.getHandle(), DataChannelImpl.this.getFileName());
                        break;
                    }
                    case 1: {
                        rc = DataChannelImpl.this.hc_flushDCBufferToSocket(DataChannelImpl.this.getHandle(), DataChannelImpl.this.getInetAddress().getAddress(), DataChannelImpl.this.getPort());
                        break;
                    }
                    case 5: 
                    case 6: {
                        rc = DataChannelImpl.this.hc_flushDCBufferToStream(DataChannelImpl.this.getHandle(), DataChannelImpl.this._dc_outputStream);
                    }
                }
                DataChannelImpl.this._isFlushing = false;
                try {
                    DataChannelImpl.this._dc_outputStream.close();
                }
                catch (IOException iOException) {}
                if (rc != 0) {
                    return;
                }
                DataChannelImpl.this.hc_destroy();
            }
        }
    }

    class WriterThread
    extends Thread {
        WriterThread() {
        }

        public void run() {
            byte[] inbytes = new byte[8096];
            int bytesRead = 0;
            DataChannelImpl.this._isWriting = true;
            try {
                while (true) {
                    if ((bytesRead = DataChannelImpl.this._dc_inputStream.read(inbytes)) > 0) {
                        int rc = DataChannelImpl.this.hc_writeToDCBuffer(DataChannelImpl.this.getHandle(), inbytes, bytesRead);
                        if (rc == 0) continue;
                        System.out.println("Error " + rc + " writing to DataChannel " + bytesRead + " bytes");
                        DataChannelImpl.this._isWriting = false;
                        return;
                    }
                    if (bytesRead < 0) break;
                }
                DataChannelImpl.this._isWriting = false;
                return;
            }
            catch (IOException iOException) {
                DataChannelImpl.this._isWriting = false;
                return;
            }
        }
    }
}

