/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.StringUtils;

public class DefaultLogger
implements BuildLogger {
    public static final int LEFT_COLUMN_SIZE = 12;
    protected PrintStream out;
    protected PrintStream err;
    protected int msgOutputLevel = 0;
    private long startTime = System.currentTimeMillis();
    protected static final String lSep = StringUtils.LINE_SEP;
    protected boolean emacsMode = false;

    public void setMessageOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    public void setOutputPrintStream(PrintStream output) {
        this.out = new PrintStream(output, true);
    }

    public void setErrorPrintStream(PrintStream err) {
        this.err = new PrintStream(err, true);
    }

    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    public void buildStarted(BuildEvent event2) {
        this.startTime = System.currentTimeMillis();
    }

    public void buildFinished(BuildEvent event2) {
        Throwable error = event2.getException();
        StringBuffer message = new StringBuffer();
        if (error == null) {
            message.append(StringUtils.LINE_SEP);
            message.append("BUILD SUCCESSFUL");
        } else {
            message.append(StringUtils.LINE_SEP);
            message.append("BUILD FAILED");
            message.append(StringUtils.LINE_SEP);
            if (3 <= this.msgOutputLevel || !(error instanceof BuildException)) {
                message.append(StringUtils.getStackTrace(error));
            } else if (error instanceof BuildException) {
                message.append(error.toString()).append(lSep);
            } else {
                message.append(error.getMessage()).append(lSep);
            }
        }
        message.append(StringUtils.LINE_SEP);
        message.append("Total time: ");
        message.append(DefaultLogger.formatTime(System.currentTimeMillis() - this.startTime));
        String msg = message.toString();
        if (error == null) {
            this.printMessage(msg, this.out, 3);
        } else {
            this.printMessage(msg, this.err, 0);
        }
        this.log(msg);
    }

    public void targetStarted(BuildEvent event2) {
        if (2 <= this.msgOutputLevel && !event2.getTarget().getName().equals("")) {
            String msg = StringUtils.LINE_SEP + event2.getTarget().getName() + ":";
            this.printMessage(msg, this.out, event2.getPriority());
            this.log(msg);
        }
    }

    public void targetFinished(BuildEvent event2) {
    }

    public void taskStarted(BuildEvent event2) {
    }

    public void taskFinished(BuildEvent event2) {
    }

    public void messageLogged(BuildEvent event2) {
        int priority = event2.getPriority();
        if (priority <= this.msgOutputLevel) {
            StringBuffer message = new StringBuffer();
            if (event2.getTask() != null && !this.emacsMode) {
                String name = event2.getTask().getTaskName();
                String label = "[" + name + "] ";
                int size = 12 - label.length();
                StringBuffer tmp = new StringBuffer();
                int i = 0;
                while (i < size) {
                    tmp.append(" ");
                    ++i;
                }
                tmp.append(label);
                label = tmp.toString();
                try {
                    BufferedReader r = new BufferedReader(new StringReader(event2.getMessage()));
                    String line = r.readLine();
                    boolean first = true;
                    while (line != null) {
                        if (!first) {
                            message.append(StringUtils.LINE_SEP);
                        }
                        first = false;
                        message.append(label).append(line);
                        line = r.readLine();
                    }
                }
                catch (IOException e) {
                    message.append(label).append(event2.getMessage());
                }
            } else {
                message.append(event2.getMessage());
            }
            String msg = message.toString();
            if (priority != 0) {
                this.printMessage(msg, this.out, priority);
            } else {
                this.printMessage(msg, this.err, priority);
            }
            this.log(msg);
        }
    }

    protected static String formatTime(long millis) {
        return DateUtils.formatElapsedTime(millis);
    }

    protected void printMessage(String message, PrintStream stream, int priority) {
        stream.println(message);
    }

    protected void log(String message) {
    }
}

