/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.taglib;

import java.io.IOException;
import java.io.Reader;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.webapp.UIComponentELTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.taglib.UIComponentBodyTagBase;
import org.apache.myfaces.shared_impl.taglib.UIComponentELTagUtils;
import org.apache.myfaces.shared_impl.taglib.UIComponentTagUtils;

public abstract class UIComponentBodyELTagBase
extends UIComponentELTag {
    private static final Log log = LogFactory.getLog(UIComponentBodyTagBase.class);
    private ValueExpression _forceId;
    private ValueExpression _forceIdIndex;
    private static final Boolean DEFAULT_FORCE_ID_INDEX_VALUE = Boolean.TRUE;
    private ValueExpression _value;
    private ValueExpression _converter;

    public int doEndTag() throws JspException {
        UIComponent component2;
        if (log.isWarnEnabled() && (component2 = this.getComponentInstance()) != null && component2.getRendersChildren() && !this.isBodyContentEmpty()) {
            log.warn((Object)("Component with id '" + component2.getClientId(this.getFacesContext()) + "' (" + this.getClass().getName() + " tag) and path : " + RendererUtils.getPathToComponent(component2) + "renders it's children, but has embedded JSP or HTML code. Use the <f:verbatim> tag for nested HTML. For comments use <%/* */%> style JSP comments instead of <!-- --> style HTML comments." + "\n BodyContent:\n" + this.getBodyContent().getString().trim()));
        }
        return super.doEndTag();
    }

    private boolean isBodyContentEmpty() {
        BodyContent bodyContent = this.getBodyContent();
        if (bodyContent == null) {
            return true;
        }
        try {
            int c;
            Reader reader = bodyContent.getReader();
            while ((c = reader.read()) != -1) {
                if (Character.isWhitespace((char)c)) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            log.error((Object)"Error inspecting BodyContent", (Throwable)e);
            return false;
        }
    }

    protected void setProperties(UIComponent component2) {
        super.setProperties(component2);
        this.setBooleanProperty(component2, "forceId", this._forceId);
        this.setBooleanProperty(component2, "forceIdIndex", this._forceIdIndex, DEFAULT_FORCE_ID_INDEX_VALUE);
        this.setValueProperty(component2, this._value);
        this.setConverterProperty(component2, this._converter);
    }

    public void setForceId(ValueExpression aForceId) {
        this._forceId = aForceId;
    }

    public void setForceIdIndex(ValueExpression aForceIdIndex) {
        this._forceIdIndex = aForceIdIndex;
    }

    public void setValue(ValueExpression value) {
        this._value = value;
    }

    public void setConverter(ValueExpression converter) {
        this._converter = converter;
    }

    protected void setIntegerProperty(UIComponent component2, String propName, ValueExpression value) {
        UIComponentELTagUtils.setIntegerProperty(component2, propName, value);
    }

    @Deprecated
    protected void setIntegerProperty(UIComponent component2, String propName, String value) {
        UIComponentTagUtils.setIntegerProperty(this.getFacesContext(), component2, propName, value);
    }

    protected void setStringProperty(UIComponent component2, String propName, ValueExpression value) {
        UIComponentELTagUtils.setStringProperty(component2, propName, value);
    }

    @Deprecated
    protected void setStringProperty(UIComponent component2, String propName, String value) {
        UIComponentTagUtils.setStringProperty(this.getFacesContext(), component2, propName, value);
    }

    protected void setBooleanProperty(UIComponent component2, String propName, ValueExpression value) {
        UIComponentELTagUtils.setBooleanProperty(component2, propName, value);
    }

    protected void setBooleanProperty(UIComponent component2, String propName, ValueExpression value, Boolean defaultValue) {
        UIComponentELTagUtils.setBooleanProperty(component2, propName, value, defaultValue);
    }

    @Deprecated
    protected void setBooleanProperty(UIComponent component2, String propName, String value) {
        UIComponentTagUtils.setBooleanProperty(this.getFacesContext(), component2, propName, value);
    }

    private void setValueProperty(UIComponent component2, ValueExpression value) {
        UIComponentELTagUtils.setValueProperty(this.getFacesContext(), component2, value);
    }

    @Deprecated
    protected void setValueProperty(UIComponent component2, String value) {
        UIComponentTagUtils.setValueProperty(this.getFacesContext(), component2, value);
    }

    private void setConverterProperty(UIComponent component2, ValueExpression value) {
        UIComponentELTagUtils.setConverterProperty(this.getFacesContext(), component2, value);
    }

    @Deprecated
    private void setConverterProperty(UIComponent component2, String value) {
        UIComponentTagUtils.setConverterProperty(this.getFacesContext(), component2, value);
    }

    protected void addValidatorProperty(UIComponent component2, MethodExpression value) {
        UIComponentELTagUtils.addValidatorProperty(this.getFacesContext(), component2, value);
    }

    @Deprecated
    protected void setValidatorProperty(UIComponent component2, String value) {
        UIComponentTagUtils.setValidatorProperty(this.getFacesContext(), component2, value);
    }

    protected void setActionProperty(UIComponent component2, MethodExpression action) {
        UIComponentELTagUtils.setActionProperty(this.getFacesContext(), component2, action);
    }

    @Deprecated
    protected void setActionProperty(UIComponent component2, String action) {
        UIComponentTagUtils.setActionProperty(this.getFacesContext(), component2, action);
    }

    protected void setActionListenerProperty(UIComponent component2, MethodExpression actionListener) {
        UIComponentELTagUtils.addActionListenerProperty(this.getFacesContext(), component2, actionListener);
    }

    @Deprecated
    protected void setActionListenerProperty(UIComponent component2, String actionListener) {
        UIComponentTagUtils.setActionListenerProperty(this.getFacesContext(), component2, actionListener);
    }

    protected void addValueChangedListenerProperty(UIComponent component2, MethodExpression valueChangedListener) {
        UIComponentELTagUtils.addValueChangedListenerProperty(this.getFacesContext(), component2, valueChangedListener);
    }

    @Deprecated
    protected void setValueChangedListenerProperty(UIComponent component2, String valueChangedListener) {
        UIComponentTagUtils.setValueChangedListenerProperty(this.getFacesContext(), component2, valueChangedListener);
    }

    protected void setValueBinding(UIComponent component2, String propName, ValueExpression value) {
        UIComponentELTagUtils.setValueBinding(this.getFacesContext(), component2, propName, value);
    }
}

