/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HTML;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlFormRendererBase;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared_impl.renderkit.html.util.JavascriptUtils;

public class HtmlButtonRendererBase
extends HtmlRenderer {
    private static final String IMAGE_BUTTON_SUFFIX_X = ".x";
    private static final String IMAGE_BUTTON_SUFFIX_Y = ".y";
    public static final String ACTION_FOR_LIST = "org.apache.myfaces.ActionForList";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UICommand.class);
        if (!HtmlButtonRendererBase.isReset(uiComponent) && HtmlButtonRendererBase.isSubmitted(facesContext, uiComponent)) {
            uiComponent.queueEvent(new ActionEvent(uiComponent));
            RendererUtils.initPartialValidationAndModelUpdate(uiComponent, facesContext);
        }
    }

    private static boolean isReset(UIComponent uiComponent) {
        return "reset".equals((String)uiComponent.getAttributes().get("type"));
    }

    private static boolean isSubmitted(FacesContext facesContext, UIComponent uiComponent) {
        String clientId = uiComponent.getClientId(facesContext);
        Map<String, String> paramMap = facesContext.getExternalContext().getRequestParameterMap();
        return paramMap.containsKey(clientId) || paramMap.containsKey(clientId + IMAGE_BUTTON_SUFFIX_X) || paramMap.containsKey(clientId + IMAGE_BUTTON_SUFFIX_Y);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UICommand.class);
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        if (JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext()) && MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isAutoScroll()) {
            HtmlRendererUtils.renderFormSubmitScript(facesContext);
        }
        writer.startElement("input", uiComponent);
        writer.writeAttribute("id", clientId, "id");
        writer.writeAttribute("name", clientId, "id");
        String image = this.getImage(uiComponent);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (image != null) {
            writer.writeAttribute("type", "image", "type");
            String src = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, image);
            writer.writeURIAttribute("src", externalContext.encodeResourceURL(src), "image");
        } else {
            String type = this.getType(uiComponent);
            if (type == null || !HtmlButtonRendererBase.isReset(uiComponent)) {
                type = "submit";
            }
            writer.writeAttribute("type", type, "type");
            Object value = this.getValue(uiComponent);
            if (value != null) {
                writer.writeAttribute("value", value, "value");
            }
        }
        if (JavascriptUtils.isJavascriptAllowed(externalContext)) {
            StringBuffer onClick = this.buildOnClick(uiComponent, facesContext, writer);
            if (onClick.length() != 0) {
                writer.writeAttribute("onclick", onClick.toString(), null);
            }
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.BUTTON_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_ONCLICK);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.BUTTON_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        }
        if (this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", Boolean.TRUE, "disabled");
        }
        if (this.isReadonly(facesContext, uiComponent)) {
            writer.writeAttribute("readonly", Boolean.TRUE, "readonly");
        }
        writer.endElement("input");
        HtmlFormRendererBase.renderScrollHiddenInputIfNecessary(this.findNestingForm(uiComponent, facesContext).getForm(), facesContext, writer);
    }

    protected StringBuffer buildOnClick(UIComponent uiComponent, FacesContext facesContext, ResponseWriter writer) throws IOException {
        FormInfo formInfo = this.findNestingForm(uiComponent, facesContext);
        if (formInfo == null) {
            throw new IllegalArgumentException("Component " + uiComponent.getClientId(facesContext) + " must be embedded in an form");
        }
        String formName = formInfo.getFormName();
        UIComponent nestingForm = formInfo.getForm();
        StringBuffer onClick = new StringBuffer();
        String commandOnClick = (String)uiComponent.getAttributes().get("onclick");
        if (commandOnClick != null) {
            onClick.append(commandOnClick);
            onClick.append(';');
        }
        if (JavascriptUtils.isRenderClearJavascriptOnButton(facesContext.getExternalContext())) {
            HtmlRendererUtils.appendClearHiddenCommandFormParamsFunctionCall(onClick, formName);
        }
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isAutoScroll()) {
            HtmlRendererUtils.appendAutoScrollAssignment(onClick, formName);
        }
        return onClick;
    }

    protected void addHiddenCommandParameter(FacesContext facesContext, UIComponent nestingForm, String hiddenFieldName) {
        if (nestingForm != null) {
            HtmlFormRendererBase.addHiddenCommandParameter(facesContext, nestingForm, hiddenFieldName);
        }
    }

    protected FormInfo findNestingForm(UIComponent uiComponent, FacesContext facesContext) {
        return RendererUtils.findNestingForm(uiComponent, facesContext);
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlCommandButton) {
            return ((HtmlCommandButton)uiComponent).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    protected boolean isReadonly(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlCommandButton) {
            return ((HtmlCommandButton)uiComponent).isReadonly();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "readonly", false);
    }

    private String getImage(UIComponent uiComponent) {
        if (uiComponent instanceof HtmlCommandButton) {
            return ((HtmlCommandButton)uiComponent).getImage();
        }
        return (String)uiComponent.getAttributes().get("image");
    }

    private String getType(UIComponent uiComponent) {
        if (uiComponent instanceof HtmlCommandButton) {
            return ((HtmlCommandButton)uiComponent).getType();
        }
        return (String)uiComponent.getAttributes().get("type");
    }

    private Object getValue(UIComponent uiComponent) {
        if (uiComponent instanceof ValueHolder) {
            return ((ValueHolder)((Object)uiComponent)).getValue();
        }
        return uiComponent.getAttributes().get("value");
    }
}

