/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import javax.crypto.BadPaddingException;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.MyfacesResponseStateManager;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared_impl.util.StateUtils;

public class HtmlResponseStateManager
extends MyfacesResponseStateManager {
    private static final Log log = LogFactory.getLog(HtmlResponseStateManager.class);
    private static final int TREE_PARAM = 0;
    private static final int STATE_PARAM = 1;
    private static final int VIEWID_PARAM = 2;
    public static final String STANDARD_STATE_SAVING_PARAM = "javax.faces.ViewState";

    public void writeState(FacesContext facescontext, StateManager.SerializedView serializedview) throws IOException {
        ResponseWriter responseWriter = facescontext.getResponseWriter();
        Object[] savedState = new Object[3];
        if (facescontext.getApplication().getStateManager().isSavingStateInClient(facescontext)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Writing state in client");
            }
            Object treeStruct = serializedview.getStructure();
            Object compStates = serializedview.getState();
            if (treeStruct != null) {
                savedState[0] = treeStruct;
            } else {
                log.error((Object)"No tree structure to be saved in client response!");
            }
            if (compStates != null) {
                savedState[1] = compStates;
            } else {
                log.error((Object)"No component states to be saved in client response!");
            }
        } else {
            Object treeStruct;
            if (log.isTraceEnabled()) {
                log.trace((Object)"Writing state in server");
            }
            if ((treeStruct = serializedview.getStructure()) != null && treeStruct instanceof String) {
                savedState[0] = treeStruct;
            }
        }
        savedState[2] = facescontext.getViewRoot().getViewId();
        if (log.isTraceEnabled()) {
            log.trace((Object)"Writing view state and renderKit fields");
        }
        this.writeViewStateField(facescontext, responseWriter, savedState);
        this.writeRenderKitIdField(facescontext, responseWriter);
    }

    private void writeViewStateField(FacesContext facesContext, ResponseWriter responseWriter, Object savedState) throws IOException {
        String serializedState = StateUtils.construct(savedState, facesContext.getExternalContext());
        ExternalContext extContext = facesContext.getExternalContext();
        MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance(extContext);
        if (JavascriptUtils.isJavascriptAllowed(extContext) && myfacesConfig.isViewStateJavascript()) {
            HtmlRendererUtils.renderViewStateJavascript(facesContext, STANDARD_STATE_SAVING_PARAM, serializedState);
        } else {
            responseWriter.startElement("input", null);
            responseWriter.writeAttribute("type", "hidden", null);
            responseWriter.writeAttribute("name", STANDARD_STATE_SAVING_PARAM, null);
            if (myfacesConfig.isRenderViewStateId()) {
                responseWriter.writeAttribute("id", STANDARD_STATE_SAVING_PARAM, null);
            }
            responseWriter.writeAttribute("value", serializedState, null);
            responseWriter.endElement("input");
        }
    }

    private void writeRenderKitIdField(FacesContext facesContext, ResponseWriter responseWriter) throws IOException {
        String defaultRenderKitId = facesContext.getApplication().getDefaultRenderKitId();
        if (defaultRenderKitId != null && !"HTML_BASIC".equals(defaultRenderKitId)) {
            responseWriter.startElement("input", null);
            responseWriter.writeAttribute("type", "hidden", null);
            responseWriter.writeAttribute("name", "javax.faces.RenderKitId", null);
            responseWriter.writeAttribute("value", defaultRenderKitId, null);
            responseWriter.endElement("input");
        }
    }

    public Object getState(FacesContext facesContext, String viewId) {
        Object[] savedState = this.getSavedState(facesContext);
        if (savedState == null) {
            return null;
        }
        return new Object[]{savedState[0], savedState[1]};
    }

    public Object getTreeStructureToRestore(FacesContext facesContext, String viewId) {
        Object[] savedState = this.getSavedState(facesContext);
        if (savedState == null) {
            return null;
        }
        return savedState[0];
    }

    public Object getComponentStateToRestore(FacesContext facesContext) {
        Object[] savedState = this.getSavedState(facesContext);
        if (savedState == null) {
            return null;
        }
        return savedState[1];
    }

    private Object[] getSavedState(FacesContext facesContext) {
        String encodedState = facesContext.getExternalContext().getRequestParameterMap().get(STANDARD_STATE_SAVING_PARAM);
        if (encodedState == null) {
            return null;
        }
        Object[] savedState = null;
        try {
            savedState = (Object[])StateUtils.reconstruct(encodedState, facesContext.getExternalContext());
        }
        catch (FacesException e) {
            if (e.getCause().getClass().equals(new BadPaddingException().getClass())) {
                return null;
            }
            throw e;
        }
        String restoredViewId = (String)savedState[2];
        if (restoredViewId == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("No saved state or state of a different viewId: " + restoredViewId));
            }
            return null;
        }
        return savedState;
    }

    public boolean isPostback(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(STANDARD_STATE_SAVING_PARAM);
    }
}

