/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.portlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.myfaces.context.ReleaseableExternalContext;
import org.apache.myfaces.context.portlet.ApplicationMap;
import org.apache.myfaces.context.portlet.InitParameterMap;
import org.apache.myfaces.context.portlet.RequestHeaderMap;
import org.apache.myfaces.context.portlet.RequestHeaderValuesMap;
import org.apache.myfaces.context.portlet.RequestMap;
import org.apache.myfaces.context.portlet.RequestParameterMap;
import org.apache.myfaces.context.portlet.RequestParameterValuesMap;
import org.apache.myfaces.context.portlet.SessionMap;
import org.apache.myfaces.util.EnumerationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletExternalContextImpl
extends ExternalContext
implements ReleaseableExternalContext {
    private static final String INIT_PARAMETER_MAP_ATTRIBUTE = InitParameterMap.class.getName();
    PortletContext _portletContext;
    PortletRequest _portletRequest;
    PortletResponse _portletResponse;
    private Map<String, Object> _applicationMap;
    private Map<String, Object> _sessionMap;
    private Map<String, Object> _requestMap;
    private Map<String, String> _requestParameterMap;
    private Map<String, String[]> _requestParameterValuesMap;
    private Map<String, String> _requestHeaderMap;
    private Map<String, String[]> _requestHeaderValuesMap;
    private Map<String, String> _initParameterMap;
    private ActionRequest _actionRequest;

    public PortletExternalContextImpl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        this._portletContext = portletContext;
        this._portletRequest = portletRequest;
        this._portletResponse = portletResponse;
        this._actionRequest = this.isActionRequest(portletRequest) ? (ActionRequest)portletRequest : null;
    }

    @Override
    public void dispatch(String path) throws IOException {
        if (this._actionRequest != null) {
            String msg = "Can not call dispatch() during a portlet ActionRequest";
            throw new UnsupportedOperationException(msg);
        }
        PortletRequestDispatcher requestDispatcher = this._portletContext.getRequestDispatcher(path);
        try {
            requestDispatcher.include((RenderRequest)this._portletRequest, (RenderResponse)this._portletResponse);
        }
        catch (PortletException e) {
            if (e.getMessage() != null) {
                throw new FacesException(e.getMessage(), e);
            }
            throw new FacesException(e);
        }
    }

    @Override
    public String encodeActionURL(String url) {
        this.checkNull(url, "url");
        return this._portletResponse.encodeURL(url);
    }

    @Override
    public String encodeNamespace(String name) {
        if (this._actionRequest != null) {
            throw new UnsupportedOperationException("Can not call encodeNamespace() during a portlet ActionRequest");
        }
        return name + ((RenderResponse)this._portletResponse).getNamespace();
    }

    @Override
    public String encodeResourceURL(String url) {
        this.checkNull(url, "url");
        return this._portletResponse.encodeURL(url);
    }

    @Override
    public Map<String, Object> getApplicationMap() {
        if (this._applicationMap == null) {
            this._applicationMap = new ApplicationMap(this._portletContext);
        }
        return this._applicationMap;
    }

    @Override
    public String getAuthType() {
        return this._portletRequest.getAuthType();
    }

    @Override
    public Object getContext() {
        return this._portletContext;
    }

    @Override
    public String getInitParameter(String name) {
        return this._portletContext.getInitParameter(name);
    }

    @Override
    public Map<String, String> getInitParameterMap() {
        if (this._initParameterMap == null && (this._initParameterMap = (Map)this._portletContext.getAttribute(INIT_PARAMETER_MAP_ATTRIBUTE)) == null) {
            this._initParameterMap = new InitParameterMap(this._portletContext);
            this._portletContext.setAttribute(INIT_PARAMETER_MAP_ATTRIBUTE, this._initParameterMap);
        }
        return this._initParameterMap;
    }

    @Override
    public String getRemoteUser() {
        return this._portletRequest.getRemoteUser();
    }

    @Override
    public Object getRequest() {
        return this._portletRequest;
    }

    @Override
    public String getRequestContentType() {
        return null;
    }

    @Override
    public String getRequestContextPath() {
        return this._portletRequest.getContextPath();
    }

    @Override
    public Map<String, Object> getRequestCookieMap() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Map<String, String> getRequestHeaderMap() {
        if (this._requestHeaderMap == null) {
            this._requestHeaderMap = new RequestHeaderMap(this._portletRequest);
        }
        return this._requestHeaderMap;
    }

    @Override
    public Map<String, String[]> getRequestHeaderValuesMap() {
        if (this._requestHeaderValuesMap == null) {
            this._requestHeaderValuesMap = new RequestHeaderValuesMap(this._portletRequest);
        }
        return this._requestHeaderValuesMap;
    }

    @Override
    public Locale getRequestLocale() {
        return this._portletRequest.getLocale();
    }

    @Override
    public Iterator<Locale> getRequestLocales() {
        return new EnumerationIterator(this._portletRequest.getLocales());
    }

    @Override
    public Map<String, Object> getRequestMap() {
        if (this._requestMap == null) {
            this._requestMap = new RequestMap(this._portletRequest);
        }
        return this._requestMap;
    }

    @Override
    public Map<String, String> getRequestParameterMap() {
        if (this._requestParameterMap == null) {
            this._requestParameterMap = new RequestParameterMap(this._portletRequest);
        }
        return this._requestParameterMap;
    }

    @Override
    public Iterator<String> getRequestParameterNames() {
        return new EnumerationIterator(this._portletRequest.getParameterNames());
    }

    @Override
    public Map<String, String[]> getRequestParameterValuesMap() {
        if (this._requestParameterValuesMap == null) {
            this._requestParameterValuesMap = new RequestParameterValuesMap(this._portletRequest);
        }
        return this._requestParameterValuesMap;
    }

    @Override
    public String getRequestPathInfo() {
        return null;
    }

    @Override
    public String getRequestServletPath() {
        return null;
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        this.checkNull(path, "path");
        return this._portletContext.getResource(path);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        this.checkNull(path, "path");
        return this._portletContext.getResourceAsStream(path);
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        this.checkNull(path, "path");
        return this._portletContext.getResourcePaths(path);
    }

    @Override
    public Object getResponse() {
        return this._portletResponse;
    }

    @Override
    public String getResponseContentType() {
        return null;
    }

    @Override
    public Object getSession(boolean create) {
        return this._portletRequest.getPortletSession(create);
    }

    @Override
    public Map<String, Object> getSessionMap() {
        if (this._sessionMap == null) {
            this._sessionMap = new SessionMap(this._portletRequest);
        }
        return this._sessionMap;
    }

    @Override
    public Principal getUserPrincipal() {
        return this._portletRequest.getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(String role) {
        this.checkNull(role, "role");
        return this._portletRequest.isUserInRole(role);
    }

    @Override
    public void log(String message) {
        this.checkNull(message, "message");
        this._portletContext.log(message);
    }

    @Override
    public void log(String message, Throwable exception) {
        this.checkNull(message, "message");
        this.checkNull(exception, "exception");
        this._portletContext.log(message, exception);
    }

    @Override
    public void redirect(String url) throws IOException {
        if (!(this._actionRequest instanceof ActionResponse)) {
            throw new IllegalArgumentException("Only ActionResponse supported");
        }
        ((ActionResponse)this._portletResponse).sendRedirect(url);
    }

    @Override
    public void release() {
        this._portletContext = null;
        this._portletRequest = null;
        this._portletResponse = null;
        this._applicationMap = null;
        this._sessionMap = null;
        this._requestMap = null;
        this._requestParameterMap = null;
        this._requestParameterValuesMap = null;
        this._requestHeaderMap = null;
        this._requestHeaderValuesMap = null;
        this._initParameterMap = null;
        this._actionRequest = null;
    }

    @Override
    public void setRequest(Object request) {
        this._portletRequest = (PortletRequest)request;
        this._actionRequest = this.isActionRequest(this._portletRequest) ? (ActionRequest)request : null;
    }

    @Override
    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._actionRequest == null) {
            throw new UnsupportedOperationException("Can not set request character encoding to value '" + encoding + "'. Request is not an action request");
        }
        this._actionRequest.setCharacterEncoding(encoding);
    }

    @Override
    public String getRequestCharacterEncoding() {
        if (this._actionRequest != null) {
            return this._actionRequest.getCharacterEncoding();
        }
        throw new UnsupportedOperationException("Can not get request character encoding. Request is not an action request");
    }

    @Override
    public String getResponseCharacterEncoding() {
        return null;
    }

    @Override
    public void setResponse(Object response) {
        this._portletResponse = (PortletResponse)response;
    }

    @Override
    public void setResponseCharacterEncoding(String encoding) {
    }

    private void checkNull(Object o, String param) {
        if (o == null) {
            throw new NullPointerException(param + " can not be null.");
        }
    }

    private boolean isActionRequest(PortletRequest portletRequest) {
        return portletRequest instanceof ActionRequest;
    }
}

