/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import com.ibm.ejs.ras.TraceComponent;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.jasper.runtime.JspWriterImpl;

public class BodyContentImpl
extends BodyContent {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "org.apache.jasper.runtime.BodyContentImpl";
    public static final int DEFAULT_TAG_BUFFER_SIZE = 512;
    private static final String LINE_SEPARATOR = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("line.separator");
        }
    });
    protected int bodyContentBuffSize = 512;
    private StringBuffer strBuffer;
    private int nextChar;
    private boolean closed;
    private Writer writer;
    private int bufferSizeSave;

    public BodyContentImpl(JspWriter enclosingWriter) {
        this(enclosingWriter, 512);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "BodyContentImpl", "BodyContentImpl ctor 1 buffsize=[512]  this=[" + this + "]");
        }
    }

    public BodyContentImpl(JspWriter enclosingWriter, int bodyContentBuffSize) {
        super(enclosingWriter);
        this.bodyContentBuffSize = bodyContentBuffSize;
        this.bufferSizeSave = this.bufferSize = bodyContentBuffSize;
        this.strBuffer = new StringBuffer(this.bufferSize);
        this.nextChar = 0;
        this.closed = false;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "BodyContentImpl", "BodyContentImpl ctor 2 buffsize=[" + this.bodyContentBuffSize + "]  this=[" + this + "]");
        }
    }

    public void write(int c) throws IOException {
        if (this.writer != null) {
            this.writer.write(c);
        } else {
            this.ensureOpen();
            this.strBuffer.append((char)c);
            ++this.nextChar;
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.writer != null) {
            this.writer.write(cbuf, off, len);
        } else {
            this.ensureOpen();
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.strBuffer.append(cbuf, off, len);
            this.nextChar += len;
        }
    }

    public void write(char[] buf) throws IOException {
        if (this.writer != null) {
            this.writer.write(buf);
        } else {
            this.write(buf, 0, buf.length);
        }
    }

    public void write(String s, int off, int len) throws IOException {
        if (this.writer != null) {
            this.writer.write(s, off, len);
        } else {
            this.ensureOpen();
            this.strBuffer.append(s.substring(off, off + len));
            this.nextChar += len;
        }
    }

    public void write(String s) throws IOException {
        if (this.writer != null) {
            this.writer.write(s);
        } else {
            this.write(s, 0, s.length());
        }
    }

    public void newLine() throws IOException {
        if (this.writer != null) {
            this.writer.write(LINE_SEPARATOR);
        } else {
            this.write(LINE_SEPARATOR);
        }
    }

    public void print(boolean b) throws IOException {
        if (this.writer != null) {
            this.writer.write(b ? "true" : "false");
        } else {
            this.write(b ? "true" : "false");
        }
    }

    public void print(char c) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(c));
        } else {
            this.write(String.valueOf(c));
        }
    }

    public void print(int i) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(i));
        } else {
            this.write(String.valueOf(i));
        }
    }

    public void print(long l) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(l));
        } else {
            this.write(String.valueOf(l));
        }
    }

    public void print(float f) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(f));
        } else {
            this.write(String.valueOf(f));
        }
    }

    public void print(double d) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(d));
        } else {
            this.write(String.valueOf(d));
        }
    }

    public void print(char[] s) throws IOException {
        if (this.writer != null) {
            this.writer.write(s);
        } else {
            this.write(s);
        }
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        if (this.writer != null) {
            this.writer.write(s);
        } else {
            this.write(s);
        }
    }

    public void print(Object obj) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(obj));
        } else {
            this.write(String.valueOf(obj));
        }
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(char x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(int x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(long x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(float x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(double x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(char[] x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(String x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(Object x) throws IOException {
        this.print(x);
        this.println();
    }

    public void clear() throws IOException {
        if (this.writer != null) {
            throw new IOException();
        }
        this.nextChar = 0;
        this.strBuffer.setLength(0);
    }

    public void clearBuffer() throws IOException {
        if (this.writer == null) {
            this.clear();
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else {
            this.closed = true;
            this.strBuffer = null;
        }
    }

    public int getRemaining() {
        return this.writer == null ? this.strBuffer.capacity() - this.strBuffer.length() : 0;
    }

    public Reader getReader() {
        char[] charBuffer = new char[this.strBuffer.length()];
        this.strBuffer.getChars(0, this.strBuffer.length(), charBuffer, 0);
        return this.writer == null ? new CharArrayReader(charBuffer, 0, this.strBuffer.length()) : null;
    }

    public String getString() {
        return this.writer == null ? this.strBuffer.toString() : null;
    }

    public void writeOut(Writer out) throws IOException {
        if (this.writer == null) {
            out.write(this.strBuffer.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        char[] buff = new char[]{'f', 'o', 'o', 'b', 'a', 'r', 'b', 'a', 'z', 'y'};
        BodyContentImpl bodyContent = new BodyContentImpl(new JspWriterImpl(null, 100, false));
        bodyContent.println(buff);
        System.out.println(bodyContent.getString());
        bodyContent.writeOut(new PrintWriter(System.out));
    }

    void setWriter(Writer writer) {
        this.writer = writer;
        if (writer != null) {
            if (this.bufferSize != 0) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setWriter", "BodyContentImpl setWriter A. bufferSize=[" + this.bufferSize + "]  this=[" + this + "]");
                }
                this.bufferSizeSave = this.bufferSize;
                this.bufferSize = 0;
            }
        } else {
            this.bufferSize = this.bufferSizeSave;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setWriter", "BodyContentImpl setWriter B. bufferSize=[" + this.bufferSize + "]  this=[" + this + "]");
            }
            this.clearBody();
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }
}

