/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationService;
import javax.management.relation.RelationServiceMBean;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupportMBean;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.Role;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;
import javax.management.relation.RoleUnresolved;
import javax.management.relation.RoleUnresolvedList;
import mx4j.log.Log;
import mx4j.log.Logger;

public class RelationSupport
implements RelationSupportMBean,
MBeanRegistration {
    private String m_relationId;
    private String m_relationTypeName;
    private ObjectName m_relationServiceObjectName;
    private MBeanServer m_server;
    private RelationServiceMBean m_proxy;
    private Boolean m_isInRelationService = null;
    private Map m_roleNameToRole = new HashMap();
    static /* synthetic */ Class class$javax$management$relation$RelationServiceMBean;

    public RelationSupport(String relationId, ObjectName relationServiceObjectName, MBeanServer server, String relationTypeName, RoleList roleList) throws InvalidRoleValueException, IllegalArgumentException {
        if (relationId == null) {
            throw new IllegalArgumentException("Illegal Null RelationId");
        }
        if (relationServiceObjectName == null) {
            throw new IllegalArgumentException("Illegal Null RelatiobService ObjectName");
        }
        if (relationTypeName == null) {
            throw new IllegalArgumentException("Illegal Null RelationTypeName");
        }
        this.m_relationId = relationId;
        this.m_relationServiceObjectName = relationServiceObjectName;
        this.m_server = server;
        this.m_proxy = (RelationServiceMBean)MBeanServerInvocationHandler.newProxyInstance(this.m_server, relationServiceObjectName, class$javax$management$relation$RelationServiceMBean == null ? (class$javax$management$relation$RelationServiceMBean = RelationSupport.class$("javax.management.relation.RelationServiceMBean")) : class$javax$management$relation$RelationServiceMBean, false);
        this.m_relationTypeName = relationTypeName;
        this.initializeRoleList(roleList);
        this.m_isInRelationService = new Boolean(false);
    }

    public RelationSupport(String relationId, ObjectName relationServiceObjectName, String relationTypeName, RoleList roleList) throws InvalidRoleValueException, IllegalArgumentException {
        this(relationId, relationServiceObjectName, null, relationTypeName, roleList);
    }

    public List getRole(String roleName) throws IllegalArgumentException, RoleNotFoundException, RelationServiceNotRegisteredException {
        Role role;
        int problemType;
        Logger logger = this.getLogger();
        if (roleName == null) {
            throw new IllegalArgumentException("Role name cannot be null");
        }
        if (logger.isEnabledFor(20)) {
            logger.info((Object)("getting roles whith RoleName: " + roleName + " from RelationSupport"));
        }
        if ((problemType = this.getReadingProblemType(role = this.getRoleFromRoleName(roleName), roleName, this.m_relationTypeName)) == 0) {
            return role.getRoleValue();
        }
        if (problemType == 1) {
            logger.error((Object)("RoleName: " + roleName + " not found"));
            throw new RoleNotFoundException("RoleName: " + roleName + " does not exist in the relation");
        }
        if (problemType == 2) {
            logger.error((Object)("Role with roleName: " + roleName + " cannot be read."));
            throw new RoleNotFoundException("RoleName: " + roleName + " is not readable");
        }
        return null;
    }

    int getReadingProblemType(Role role, String roleName, String relationTypeName) throws RelationServiceNotRegisteredException, IllegalArgumentException {
        if (roleName == null) {
            throw new IllegalArgumentException("Null Role Name.");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info((Object)"Checking the Role reading...");
        }
        if (role == null) {
            return 1;
        }
        try {
            return this.m_proxy.checkRoleReading(roleName, relationTypeName);
        }
        catch (RelationTypeNotFoundException ex) {
            logger.error((Object)("Unable to find the Relation Type with name " + relationTypeName));
            throw new RuntimeOperationsException(null, "Relation Type with name: " + relationTypeName + " was not found");
        }
    }

    public RoleResult getRoles(String[] roleNames) throws IllegalArgumentException, RelationServiceNotRegisteredException {
        if (roleNames == null) {
            throw new IllegalArgumentException("Null RoleName Array.");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info((Object)"Getting roles");
        }
        RoleList roleList = new RoleList();
        RoleUnresolvedList unresolvedList = new RoleUnresolvedList();
        for (int i = 0; i < roleNames.length; ++i) {
            String currentRoleName = roleNames[i];
            Role role = this.getRoleFromRoleName(currentRoleName);
            int problemType = this.getReadingProblemType(role, currentRoleName, this.m_relationTypeName);
            if (problemType == 0) {
                roleList.add((Role)role.clone());
                continue;
            }
            unresolvedList.add(new RoleUnresolved(currentRoleName, null, problemType));
        }
        return new RoleResult(roleList, unresolvedList);
    }

    public RoleResult getAllRoles() throws RelationServiceNotRegisteredException {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info((Object)"getting all roles");
        }
        List roleNameList = this.getAllRoleNamesList();
        String[] roleNames = new String[roleNameList.size()];
        int index = 0;
        Iterator i = roleNameList.iterator();
        while (i.hasNext()) {
            roleNames[index] = (String)i.next();
            ++index;
        }
        return this.getRoles(roleNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleList retrieveAllRoles() {
        Map map = this.m_roleNameToRole;
        synchronized (map) {
            return new RoleList(new ArrayList(this.m_roleNameToRole.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getAllRolesList() {
        Map map = this.m_roleNameToRole;
        synchronized (map) {
            return new ArrayList(this.m_roleNameToRole.values());
        }
    }

    public void setRole(Role role) throws IllegalArgumentException, RoleNotFoundException, RelationTypeNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationNotFoundException {
        if (role == null) {
            throw new IllegalArgumentException("RelationSupport setRole has recieved a null Role.");
        }
        String roleName = role.getRoleName();
        Role oldRole = this.getRoleFromRoleName(roleName);
        ArrayList oldRoleValue = null;
        Boolean toBeInitialized = null;
        if (oldRole == null) {
            toBeInitialized = new Boolean(true);
            oldRoleValue = new ArrayList();
        } else {
            toBeInitialized = new Boolean(false);
            oldRoleValue = oldRole.getRoleValue();
        }
        int problemType = this.getRoleWritingValue(role, this.m_relationTypeName, toBeInitialized);
        if (problemType == 0) {
            if (!toBeInitialized.booleanValue()) {
                this.sendUpdateRoleNotification(this.m_relationId, role, oldRoleValue);
                this.updateRelationServiceMap(this.m_relationId, role, oldRoleValue);
            }
            this.addRolesToRoleMap(roleName, role);
        } else {
            RelationService.throwRoleProblemException(problemType, roleName);
        }
    }

    int getRoleWritingValue(Role role, String relationTypeName, Boolean toBeInitialized) throws RelationTypeNotFoundException {
        if (this.m_proxy == null) {
            throw new IllegalArgumentException("Please check the RelationService is running");
        }
        return this.m_proxy.checkRoleWriting(role, relationTypeName, toBeInitialized);
    }

    public RoleResult setRoles(RoleList roleList) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        Logger logger = this.getLogger();
        if (roleList == null) {
            throw new IllegalArgumentException("RoleList cannot be null");
        }
        if (logger.isEnabledFor(20)) {
            logger.info((Object)"setting roles");
        }
        RoleList newRoleList = new RoleList();
        RoleUnresolvedList roleUnresolvedList = new RoleUnresolvedList();
        ArrayList oldRoleValue = null;
        Boolean needsInitializing = null;
        Iterator i = roleList.iterator();
        while (i.hasNext()) {
            Role currentRole = (Role)i.next();
            String roleName = currentRole.getRoleName();
            Role oldRole = this.getRoleFromRoleName(roleName);
            if (oldRole == null) {
                needsInitializing = new Boolean(true);
                oldRoleValue = new ArrayList();
            } else {
                needsInitializing = new Boolean(false);
                oldRoleValue = oldRole.getRoleValue();
            }
            int problemType = this.getRoleWritingValue(currentRole, this.m_relationTypeName, needsInitializing);
            if (problemType == 0) {
                if (!needsInitializing.booleanValue()) {
                    this.sendUpdateRoleNotification(this.m_relationId, currentRole, oldRoleValue);
                    this.updateRelationServiceMap(this.m_relationId, currentRole, oldRoleValue);
                }
                this.addRolesToRoleMap(roleName, currentRole);
                newRoleList.add(currentRole);
                continue;
            }
            if (logger.isEnabledFor(30)) {
                logger.warn((Object)"We have some unresolved roles adding them to RoleUnresolvedList");
            }
            roleUnresolvedList.add(new RoleUnresolved(roleName, currentRole.getRoleValue(), problemType));
        }
        return new RoleResult(newRoleList, roleUnresolvedList);
    }

    public Integer getRoleCardinality(String roleName) throws IllegalArgumentException, RoleNotFoundException {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info((Object)("checking role cardinality with role named: " + roleName));
        }
        if (roleName == null) {
            throw new IllegalArgumentException("Role name should not be null.");
        }
        Role role = this.getRoleFromRoleName(roleName);
        if (role == null) {
            int problemType = 1;
            try {
                RelationService.throwRoleProblemException(problemType, roleName);
            }
            catch (InvalidRoleValueException ex) {
                new RuntimeOperationsException(null, "Invalid role value");
            }
        }
        List roleValue = role.getRoleValue();
        return new Integer(roleValue.size());
    }

    public void handleMBeanUnregistration(ObjectName objectName, String roleName) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        Logger logger = this.getLogger();
        if (objectName == null) {
            throw new IllegalArgumentException("ObjectName is null");
        }
        if (roleName == null) {
            throw new IllegalArgumentException("Null roleName");
        }
        if (logger.isEnabledFor(20)) {
            logger.info((Object)("MBean with ObjectName: " + objectName.getCanonicalName() + " has been unregistered from the" + " MBeanServer. Setting new Role values"));
        }
        Role newRole = this.createNewRole(roleName, objectName);
        this.setRole(newRole);
    }

    private Role createNewRole(String roleName, ObjectName objectName) throws RoleNotFoundException {
        Role role = this.getRoleFromRoleName(roleName);
        if (role == null) {
            throw new RoleNotFoundException("No role found for role name: " + roleName);
        }
        ArrayList newRoleValue = (ArrayList)((ArrayList)role.getRoleValue()).clone();
        newRoleValue.remove(objectName);
        Role newRole = new Role(roleName, newRoleValue);
        return newRole;
    }

    public Map getReferencedMBeans() {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info((Object)"getting mbeanReferenced in RelationService");
        }
        HashMap<ObjectName, ArrayList<String>> referencedMBeansMap = new HashMap<ObjectName, ArrayList<String>>();
        Iterator i = this.getAllRolesList().iterator();
        while (i.hasNext()) {
            Role currentRole = (Role)i.next();
            String currentRoleName = currentRole.getRoleName();
            List mbeanList = currentRole.getRoleValue();
            Iterator iter = mbeanList.iterator();
            while (iter.hasNext()) {
                ObjectName currentObjectName = (ObjectName)iter.next();
                ArrayList<String> mbeanRoleNameList = (ArrayList<String>)referencedMBeansMap.get(currentObjectName);
                boolean newReference = false;
                if (mbeanRoleNameList == null) {
                    newReference = true;
                    mbeanRoleNameList = new ArrayList<String>();
                }
                mbeanRoleNameList.add(currentRoleName);
                if (!newReference) continue;
                referencedMBeansMap.put(currentObjectName, mbeanRoleNameList);
            }
        }
        return referencedMBeansMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Role getRoleFromRoleName(String roleName) {
        Map map = this.m_roleNameToRole;
        synchronized (map) {
            return (Role)this.m_roleNameToRole.get(roleName);
        }
    }

    public String getRelationTypeName() {
        return this.m_relationTypeName;
    }

    public ObjectName getRelationServiceName() {
        return this.m_relationServiceObjectName;
    }

    public String getRelationId() {
        return this.m_relationId;
    }

    public Boolean isInRelationService() {
        return new Boolean(this.m_isInRelationService);
    }

    public void setRelationServiceManagementFlag(Boolean isHandledByRelationService) throws IllegalArgumentException {
        if (isHandledByRelationService == null) {
            throw new IllegalArgumentException("Null flag");
        }
        this.m_isInRelationService = new Boolean(isHandledByRelationService);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (server == null) {
            throw new IllegalArgumentException("MBean Server is null cannot pre-register.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Cannot register a null ObjectName");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info((Object)"pre Registering the RelationSupport");
        }
        this.m_server = server;
        this.m_proxy = (RelationServiceMBean)MBeanServerInvocationHandler.newProxyInstance(this.m_server, this.m_relationServiceObjectName, class$javax$management$relation$RelationServiceMBean == null ? (class$javax$management$relation$RelationServiceMBean = RelationSupport.class$("javax.management.relation.RelationServiceMBean")) : class$javax$management$relation$RelationServiceMBean, false);
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        Logger logger = this.getLogger();
        boolean done = registrationDone;
        if (!done) {
            this.m_server = null;
            logger.warn((Object)"RelationSupport was NOT registered");
        } else if (logger.isEnabledFor(0)) {
            logger.trace((Object)"RelationSupport postRegistered");
        }
    }

    public void preDeregister() throws Exception {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.debug((Object)"RelationSupport preDeregistered");
        }
    }

    public void postDeregister() {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.debug((Object)"RelationSupport postDeregistered");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getAllRoleNamesList() {
        Map map = this.m_roleNameToRole;
        synchronized (map) {
            return new ArrayList(this.m_roleNameToRole.keySet());
        }
    }

    private void initializeRoleList(RoleList roleList) throws InvalidRoleValueException {
        if (roleList == null) {
            return;
        }
        Iterator i = roleList.iterator();
        while (i.hasNext()) {
            Role currentRole = (Role)i.next();
            String currentRoleName = currentRole.getRoleName();
            if (this.m_roleNameToRole.containsKey(currentRoleName)) {
                throw new InvalidRoleValueException("RoleName already in use.");
            }
            this.addRolesToRoleMap(currentRoleName, currentRole);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRolesToRoleMap(String roleName, Role role) {
        Map map = this.m_roleNameToRole;
        synchronized (map) {
            this.m_roleNameToRole.put(roleName, role.clone());
        }
    }

    void updateRelationServiceMap(String relationId, Role role, List oldRoleValue) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        Logger logger = this.getLogger();
        if (this.m_proxy == null) {
            logger.error((Object)"The RelationService cannot be registered.");
            throw new RelationServiceNotRegisteredException("Please check the RelationService is registered in the server");
        }
        this.m_proxy.updateRoleMap(relationId, role, oldRoleValue);
    }

    void sendUpdateRoleNotification(String relationId, Role role, List oldRoleValue) throws RelationServiceNotRegisteredException, RelationNotFoundException {
        Logger logger = this.getLogger();
        if (relationId == null) {
            throw new IllegalArgumentException("Null RelationId passed into sendUpdateRoleNotification");
        }
        if (role == null) {
            throw new IllegalArgumentException("Null role passed into sendUpdateRoleNotification");
        }
        if (oldRoleValue == null) {
            throw new IllegalArgumentException("Null list of role Values passed into sendUpdateRoleNotification");
        }
        if (this.m_proxy == null) {
            logger.error((Object)"cannot send an update notification as RelationService may not be registered, please check.");
            throw new RelationServiceNotRegisteredException("Please check the relation service has been registered in the MBeanServer");
        }
        this.m_proxy.sendRoleUpdateNotification(relationId, role, oldRoleValue);
    }

    private Logger getLogger() {
        return Log.getLogger((String)this.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

