/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ArrayType
extends OpenType
implements Serializable {
    private static final long serialVersionUID = 720504429830309770L;
    private int dimension = 0;
    private OpenType elementType = null;
    private transient int hashCode = 0;

    public ArrayType(int dimension, OpenType elementType) throws OpenDataException {
        super(ArrayType.createArrayName(elementType, dimension), ArrayType.createArrayName(elementType, dimension), ArrayType.createDescription(elementType, dimension));
        if (elementType instanceof ArrayType) {
            throw new OpenDataException("elementType can't be instance of ArrayType");
        }
        if (dimension <= 0) {
            throw new IllegalArgumentException("int type dimension must be greater than or equal to 1");
        }
        this.dimension = dimension;
        this.elementType = elementType;
    }

    public int getDimension() {
        return this.dimension;
    }

    public OpenType getElementOpenType() {
        return this.elementType;
    }

    public boolean isValue(Object object) {
        boolean result = false;
        if (object == null || !object.getClass().isArray()) {
            result = false;
        } else if (this.elementType instanceof SimpleType) {
            result = this.getClassName().equals(object.getClass().getName());
        } else {
            try {
                Class<?> elementClass = Class.forName(this.getClassName(), false, Thread.currentThread().getContextClassLoader());
                if (elementClass.isInstance(object)) {
                    result = this.isValidDimension(this.dimension, (Object[])object);
                }
            }
            catch (ClassNotFoundException e) {
                result = false;
            }
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof ArrayType) {
            ArrayType checkedType = (ArrayType)object;
            if (checkedType.dimension != this.dimension) {
                return false;
            }
            if (this.getElementOpenType().equals(checkedType.getElementOpenType())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.computeHashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.elementType.getClassName());
        sb.append("(typename=");
        sb.append(this.getTypeName());
        sb.append(",dimension=");
        sb.append("" + this.dimension);
        sb.append(",elementType=");
        sb.append(this.elementType.toString());
        sb.append(")");
        return sb.toString();
    }

    private static String createDescription(OpenType type, int size) {
        StringBuffer sb = new StringBuffer("" + size);
        sb.append("-dimension array of ");
        sb.append(type.getClassName());
        return sb.toString();
    }

    private static String createArrayName(OpenType type, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("int type dimension must be greater than or equal to 1");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            sb.append("[");
        }
        sb.append("L");
        sb.append(type.getClassName());
        sb.append(";");
        return sb.toString();
    }

    private void computeHashCode() {
        this.hashCode = this.dimension + this.elementType.hashCode();
    }

    private static boolean arrayHasNull(Object[] obj) {
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] == null) {
                return true;
            }
            if (!obj[i].getClass().isArray() || !ArrayType.arrayHasNull((Object[])obj[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isValidDimension(int dimension, Object[] data) {
        boolean result = true;
        if (dimension == 1) {
            for (int i = 0; i < data.length && result; ++i) {
                if (data[i] == null || this.elementType.isValue(data[i])) continue;
                result = false;
            }
        } else {
            for (int i = 0; i < data.length && result; ++i) {
                result = this.isValidDimension(dimension - 1, (Object[])data[i]);
            }
        }
        return result;
    }
}

