/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import java.io.IOException;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ImageRenderer
extends HtmlBasicRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.GRAPHICIMAGE);

    public void encodeBegin(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
    }

    public void encodeEnd(FacesContext context, UIComponent component2) throws IOException {
        String styleClass;
        this.rendererParamsNotNull(context, component2);
        if (!this.shouldEncode(component2)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.startElement("img", component2);
        this.writeIdAttributeIfNecessary(context, writer, component2);
        writer.writeURIAttribute("src", ImageRenderer.src(context, component2), "value");
        if (writer.getContentType().equals("application/xhtml+xml") && null == component2.getAttributes().get("alt")) {
            writer.writeAttribute("alt", "", "alt");
        }
        RenderKitUtils.renderPassThruAttributes(writer, component2, ATTRIBUTES);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component2);
        String altText = null;
        if (component2 instanceof HtmlGraphicImage) {
            styleClass = ((HtmlGraphicImage)component2).getStyleClass();
            altText = ((HtmlGraphicImage)component2).getAlt();
        } else {
            styleClass = (String)component2.getAttributes().get("styleClass");
            altText = (String)component2.getAttributes().get("alt");
        }
        if (null != styleClass) {
            writer.writeAttribute("class", styleClass, "styleClass");
        }
        if (altText == null) {
            writer.writeAttribute("alt", "", "alt");
        }
        writer.endElement("img");
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding component " + component2.getId());
        }
    }

    private static String src(FacesContext context, UIComponent component2) {
        String value = (String)((UIGraphic)component2).getValue();
        if (value == null) {
            return "";
        }
        value = context.getApplication().getViewHandler().getResourceURL(context, value);
        return context.getExternalContext().encodeResourceURL(value);
    }
}

