/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;

public class CheckboxRenderer
extends HtmlBasicInputRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.SELECTBOOLEANCHECKBOX);

    public void decode(FacesContext context, UIComponent component2) {
        this.rendererParamsNotNull(context, component2);
        if (!this.shouldDecode(component2)) {
            return;
        }
        String clientId = component2.getClientId(context);
        assert (clientId != null);
        Map<String, String> requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String isChecked = CheckboxRenderer.isChecked(requestParameterMap.get(clientId));
        this.setSubmittedValue(component2, isChecked);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "new value after decoding: {0}", isChecked);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component2, Object submittedValue) throws ConverterException {
        String newValue = (String)submittedValue;
        return Boolean.valueOf(newValue);
    }

    protected void getEndTextToRender(FacesContext context, UIComponent component2, String currentValue) throws IOException {
        String styleClass;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.startElement("input", component2);
        this.writeIdAttributeIfNecessary(context, writer, component2);
        writer.writeAttribute("type", "checkbox", "type");
        writer.writeAttribute("name", component2.getClientId(context), "clientId");
        if ("true".equals(currentValue)) {
            writer.writeAttribute("checked", Boolean.TRUE, "value");
        }
        if (null != (styleClass = (String)component2.getAttributes().get("styleClass"))) {
            writer.writeAttribute("class", styleClass, "styleClass");
        }
        RenderKitUtils.renderPassThruAttributes(writer, component2, ATTRIBUTES);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component2);
        writer.endElement("input");
    }

    private static String isChecked(String value) {
        return Boolean.toString("on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value));
    }
}

