/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.wsspi.wssecurity.token.UsernameTokenConsumer;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IDAssertionUsernameTokenConsumer
implements TokenConsumerComponent {
    private static final TraceComponent tc = Tr.register(IDAssertionUsernameTokenConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = IDAssertionUsernameTokenConsumer.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node node, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)node) + "], " + "Map context)"));
        }
        TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)map.remove("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenConsumerConfig [" + tokenConsumerConfig + "]."));
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
        int n = 0;
        Object v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string = Constants.NAMESPACES[0][n];
        String string2 = Constants.NAMESPACES[1][n];
        NonceManager nonceManager = (NonceManager)map.remove(NonceManager.class);
        if (node.getNodeType() == 1) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            UsernameToken usernameToken;
            Element element = (Element)node;
            String string3 = null;
            String string4 = IdUtil.getInstance().getIdAttributeName(element);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The identifier attribute of the target element is [" + string4 + "]."));
            }
            if (string4 != null) {
                string3 = element.getAttribute(string4);
            }
            Boolean bl = (Boolean)tokenConsumerConfig.getProperties().get("com.ibm.wsspi.wssecurity.token.decouple");
            boolean bl2 = true;
            if (bl != null) {
                bl2 = bl;
            }
            Element element2 = null;
            element2 = !bl2 ? element : DOMUtil.clone((Element)element);
            final UsernameToken usernameToken2 = usernameToken = new UsernameToken(string3, null, null, element2);
            final TokenConsumerConfig tokenConsumerConfig2 = tokenConsumerConfig;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    usernameToken2.setUsedTokenConsumer(tokenConsumerConfig2);
                    return null;
                }
            });
            IDAssertionUsernameTokenConsumer.setTokenToSubject(map, usernameToken);
            Element element3 = DOMUtil.getOneElement((Element)element, (String)string, (String)"Username");
            String string5 = null;
            if (element3 != null) {
                string5 = DOMUtil.getStringValue((Node)element3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Username [" + string5 + "]."));
                Tr.debug((TraceComponent)tc, (String)("isCallerRequired [" + tokenConsumerConfig.isCallerRequired() + "]."));
            }
            if (!tokenConsumerConfig.isCallerRequired()) {
                throw SoapSecurityException.format("security.wssecurity.IDAssertionUsernameTokenConsumer.s01", "isCalerRequired()=false");
            }
            element3 = DOMUtil.getZeroOrOneElement((Element)element, (String)string, (String)"Password");
            if (element3 != null) {
                throw SoapSecurityException.format("security.wssecurity.IDAssertionUsernameTokenConsumer.s02", "<wsse:Password> != null.");
            }
            Date date = UsernameTokenConsumer.checkNonce(element, tokenConsumerConfig, string, string2, nonceManager);
            usernameToken.setDate(date);
            boolean bl3 = false;
            if (tokenConsumerConfig.getTrustedIDEvaluator() == null) {
                object4 = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
                object3 = object4.getCallers();
                object2 = Constants.UNTOKEN;
                if (object3 != null) {
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        object = (WSSConsumerConfig.CallerConfig)iterator.next();
                        QName qName = object.getTokenType();
                        WSSConsumerConfig.CallerConfig callerConfig = object.getTrustMethod();
                        if (!qName.equals(object2) || callerConfig == null) continue;
                        bl3 = true;
                        break;
                    }
                }
            }
            if ((object4 = UsernameTokenConsumer.invokeLoginModule(tokenConsumerConfig, string5, null, sOAPMessageContext, map, bl3)) != null) {
                string5 = ((UsernameToken)object4).getUsername();
            }
            object3 = usernameToken;
            object2 = string5;
            AccessController.doPrivileged(new PrivilegedAction((UsernameToken)object3, (String)object2){
                final /* synthetic */ UsernameToken val$tokenPriv;
                final /* synthetic */ String val$usernamePriv;
                {
                    this.val$tokenPriv = usernameToken;
                    this.val$usernamePriv = string;
                }

                public Object run() {
                    this.val$tokenPriv.setUsername(this.val$usernamePriv);
                    return null;
                }
            });
            if (tokenConsumerConfig.getTrustedIDEvaluator() != null) {
                boolean bl4 = tokenConsumerConfig.getTrustedIDEvaluator().evaluate(string5);
                object = usernameToken;
                if (!bl4) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.UsernameTokenConsumer.s02", (Object)new Object[]{string5});
                }
                AccessController.doPrivileged(new PrivilegedAction((UsernameToken)object, bl4){
                    final /* synthetic */ UsernameToken val$tokenPrivSetTrusted;
                    final /* synthetic */ boolean val$trusted;
                    {
                        this.val$tokenPrivSetTrusted = usernameToken;
                        this.val$trusted = bl;
                    }

                    public Object run() {
                        this.val$tokenPrivSetTrusted.setTrusted(this.val$trusted);
                        return null;
                    }
                });
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Acquired token is [" + usernameToken + "]."));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WARNING: Unsupported node type: " + node.getNodeName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Element target, Map context)");
        }
    }

    private static void setTokenToSubject(Map map, UsernameToken usernameToken) {
        TokenManager.setToken((Map)map, (Token)usernameToken);
    }
}

