/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.osgi;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.osgi.BundleClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public abstract class BaseWebContainerExtensionPoint {
    private static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.wsspi.webcontainer.osgi");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.osgi.BaseWebContainerExtensionPoint";

    public void loadExtensionPoint(String string, String string2, String string3) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "loadExtensionPoint", "");
        }
        try {
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            for (int i = 0; i < iExtensionArray.length; ++i) {
                IExtension iExtension = iExtensionArray[i];
                Bundle bundle = Platform.getBundle((String)iExtensionArray[i].getNamespace());
                BundleClassLoader bundleClassLoader = new BundleClassLoader(bundle);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "loadExtensionPoint", "scfBundle location -->" + bundle.getLocation());
                }
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                    String string4 = iConfigurationElementArray[j].getName();
                    if (string4 == null || !string4.equals(string2)) continue;
                    IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[j].getChildren(string3);
                    for (int k = 0; iConfigurationElementArray2 != null && k < iConfigurationElementArray2.length; ++k) {
                        this.handleExtensionPointElement(bundleClassLoader, iConfigurationElementArray2[k]);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            logger.logp(Level.SEVERE, CLASS_NAME, "loadServletContextFacadeRegistry", "Failed to register ServletContextFacadeRegistryItem ", throwable);
        }
    }

    public abstract void handleExtensionPointElement(BundleClassLoader var1, IConfigurationElement var2);
}

