/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.token;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.ValidationFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.ValidationResultImpl;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.ValidationResult;
import java.security.Permission;

public class WSSecurityPropagationHelper {
    private static WSSecurityPropagationHelper wsSecurityPropagationHelper = null;
    public static boolean rmiInboundPropagationEnabled = false;
    public static boolean rmiOutboundPropagationEnabled = false;
    public static boolean webInboundPropagationEnabled = false;
    private static final WebSphereRuntimePermission UPDATE_PROP = new WebSphereRuntimePermission("setPropagationToken");
    private static final WebSphereRuntimePermission VALIDATE_TOKEN = new WebSphereRuntimePermission("validateLTPAToken");
    private static final TraceComponent tc = Tr.register(WSSecurityPropagationHelper.class, null, "com.ibm.ejs.resources.security");

    public static WSSecurityPropagationHelper getInstance() {
        if (wsSecurityPropagationHelper == null) {
            wsSecurityPropagationHelper = new WSSecurityPropagationHelper();
            ContextManager contextManager = ContextManagerFactory.getInstance();
            rmiInboundPropagationEnabled = Boolean.valueOf(contextManager.getProperty("com.ibm.CSI.rmiInboundPropagationEnabled"));
            rmiOutboundPropagationEnabled = Boolean.valueOf(contextManager.getProperty("com.ibm.CSI.rmiOutboundPropagationEnabled"));
            webInboundPropagationEnabled = Boolean.valueOf(contextManager.getProperty("com.ibm.ws.security.webInboundPropagationEnabled"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RMI inbound propagation enabled: " + rmiInboundPropagationEnabled);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RMI outbound propagation enabled: " + rmiOutboundPropagationEnabled);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WEB inbound propagation enabled: " + webInboundPropagationEnabled);
            }
        }
        return wsSecurityPropagationHelper;
    }

    private WSSecurityPropagationHelper() {
    }

    public boolean isRMIInboundPropagationEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRMIInboundPropagationEnabled()");
        }
        boolean bl = false;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        bl = Boolean.valueOf(contextManager.getProperty("com.ibm.CSI.rmiInboundPropagationEnabled"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRMIInboundPropagationEnabled()", bl);
        }
        return bl;
    }

    public boolean isRMIOutboundPropagationEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRMIOutboundPropagationEnabled()");
        }
        boolean bl = false;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        bl = Boolean.valueOf(contextManager.getProperty("com.ibm.CSI.rmiOutboundPropagationEnabled"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRMIOutboundPropagationEnabled()", bl);
        }
        return bl;
    }

    public boolean isWebInboundPropagationEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isWebInboundPropagationEnabled()");
        }
        boolean bl = false;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        bl = Boolean.valueOf(contextManager.getProperty("com.ibm.ws.security.webInboundPropagationEnabled"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "webInboundPropagationEnabled()", bl);
        }
        return bl;
    }

    public static PropagationToken getPropagationToken(String string, int n) throws WSSecurityException {
        String string2 = string + ":" + n;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Looking up propagation token with key " + string2);
        }
        return ContextManagerFactory.getInstance().getPropagationToken(string2);
    }

    public static PropagationToken addPropagationToken(PropagationToken propagationToken) throws WSSecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + UPDATE_PROP.toString());
            }
            securityManager.checkPermission((Permission)UPDATE_PROP);
        }
        String string = propagationToken.getName() + ":" + propagationToken.getVersion();
        ContextManager contextManager = ContextManagerFactory.getInstance();
        PropagationToken propagationToken2 = contextManager.getPropagationToken(string);
        if (propagationToken2 != null) {
            Tr.warning(tc, "security.sap.warning.propagation.token.exists", new Object[]{propagationToken.getName(), new Short(propagationToken.getVersion())});
            return propagationToken2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting propagation token with key " + string);
        }
        return contextManager.setPropagationToken(string, propagationToken);
    }

    public static String validateLTPAToken(byte[] byArray) throws WSLoginFailedException {
        block11: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + VALIDATE_TOKEN.toString());
                }
                securityManager.checkPermission((Permission)VALIDATE_TOKEN);
            }
            try {
                Token token = ContextManagerFactory.getInstance().getWSCredTokenMapper().validateLTPAToken(byArray);
                if (token != null) {
                    String[] stringArray = token.getAttributes("u");
                    String string = null;
                    if (stringArray != null && stringArray[0] != null) {
                        int n = stringArray[0].indexOf(":");
                        string = stringArray[0].startsWith("user:") ? stringArray[0].substring(n + 1) : stringArray[0];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Returning securityName: " + string);
                        }
                        return string;
                    }
                    break block11;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Throwing WSLoginFailedException, token was null.");
                }
                throw new WSLoginFailedException("Invalid token, token returned from validation is null.");
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received exception during validation.", new Object[]{exception});
                }
                Manager.Ffdc.log((Throwable)exception, WSSecurityPropagationHelper.class, "com.ibm.ws.security.token.WSSecurityPropagationHelper.validateLTPAToken", "289");
                if (exception instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)exception;
                }
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning null.");
        }
        return null;
    }

    public static ValidationResult validateToken(byte[] byArray) throws ValidationFailedException {
        ValidationResultImpl validationResultImpl = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken(byte[])", "token=" + byArray);
        }
        try {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            String string = WSSecurityPropagationHelper.validateLTPAToken(byArray);
            validationResultImpl = new ValidationResultImpl(contextManager, string);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Manager.Ffdc.log((Throwable)wSLoginFailedException, WSSecurityPropagationHelper.class, "com.ibm.ws.security.token.WSSecurityPropagationHelper.validateToken", "311");
            throw new ValidationFailedException("An exception was thrown while validating received token.", wSLoginFailedException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken(byte[])", "ValidationResult=" + validationResultImpl);
        }
        return validationResultImpl;
    }

    public static ValidationResult validateToken(byte[] byArray, boolean bl) throws ValidationFailedException {
        ValidationResultImpl validationResultImpl = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken(byte[], boolean)", "token=" + byArray + " boolean = " + bl);
        }
        try {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            String string = WSSecurityPropagationHelper.validateLTPAToken(byArray);
            if (bl) {
                WSSecurityPropagationHelper.validateTokenRealm(byArray);
            }
            validationResultImpl = new ValidationResultImpl(contextManager, string);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Manager.Ffdc.log((Throwable)wSLoginFailedException, WSSecurityPropagationHelper.class, "com.ibm.ws.security.token.WSSecurityPropagationHelper.validateToken", "311");
            throw new ValidationFailedException("An exception was thrown while validating received token.", wSLoginFailedException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken(byte[], boolean)", "ValidationResult=" + validationResultImpl);
        }
        return validationResultImpl;
    }

    public static void validateTokenRealm(byte[] byArray) throws ValidationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateTokenRealm(byte[])", "token=" + byArray);
        }
        try {
            Token token = ContextManagerFactory.getInstance().getWSCredTokenMapper().validateLTPAToken(byArray);
            ContextManagerFactory.getInstance().getWSCredTokenMapper().validateTokenRealm(token);
        }
        catch (Exception exception) {
            throw new ValidationFailedException("An exception was thrown while validating realm in received token.", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateTokenRealm(byte[])");
        }
    }

    public static String getUserFromUniqueID(String string) {
        return RealmSecurityName.getSecurityName((String)string);
    }

    public static String getRealmFromUniqueID(String string) {
        int n = string.indexOf(":");
        if (string.startsWith("user:")) {
            string = string.substring(n + 1);
        }
        return RealmSecurityName.getRealm((String)string);
    }
}

