/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.token;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSSMarkerObject;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.Token;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;

public class WSOpaqueTokenHelper {
    private static WSOpaqueTokenHelper wsOpaqueTokenHelper = null;
    public static final String tokenHeader = "WSOPAQUE";
    private final byte[] tokenHeaderBytes = StringBytesConversion.getConvertedBytes((String)"WSOPAQUE");
    private final int tokenHeaderSize = this.tokenHeaderBytes.length;
    private final int tokenVersion = 1;
    private final String tokenHeaderLookup = "WSOPAQUE:1";
    public static final String wsCredHashHeader = "WSCREDHASH";
    private final byte[] wsCredHashHeaderBytes = StringBytesConversion.getConvertedBytes((String)"WSCREDHASH");
    private final int wsCredHashHeaderSize = this.wsCredHashHeaderBytes.length;
    public static final String wsTokensHeader = "WSTOKEN";
    private final byte[] wsTokensHeaderBytes = StringBytesConversion.getConvertedBytes((String)"WSTOKEN");
    private final int wsTokensHeaderSize = this.wsTokensHeaderBytes.length;
    public static final String customTokensHeader = "CUSTOM";
    private final byte[] customTokensHeaderBytes = StringBytesConversion.getConvertedBytes((String)"CUSTOM");
    private final int customTokensHeaderSize = this.customTokensHeaderBytes.length;
    public static final String customPublicTokensHeader = "CUSTOM_PUBLIC";
    public static final String customPublicTokensHeaderEnding = " (1)";
    public static final String customPrivateTokensHeader = "CUSTOM_PRIVATE";
    public static final String customPrivateTokensHeaderEnding = " (2)";
    public static final String customPrincipalTokensHeader = "CUSTOM_PRINCIPAL";
    public static final String customPrincipalTokensHeaderEnding = " (3)";
    private static ArrayList excludeList = null;
    private static boolean throwExceptionForAllPropagationSerializationProblems = false;
    private static final TraceComponent tc = Tr.register(WSOpaqueTokenHelper.class, "SASRas", "com.ibm.ejs.resources.security");

    public static WSOpaqueTokenHelper getInstance() {
        if (wsOpaqueTokenHelper == null) {
            wsOpaqueTokenHelper = new WSOpaqueTokenHelper();
        }
        return wsOpaqueTokenHelper;
    }

    private WSOpaqueTokenHelper() {
        ContextManager contextManager = ContextManagerFactory.getInstance();
        try {
            SecurityConfigObject securityConfigObject = null;
            String string = null;
            SecurityConfigManager securityConfigManager = SecurityObjectLocator.getSecurityConfigManager();
            if (securityConfigManager != null) {
                securityConfigObject = securityConfigManager.getObject("security");
            }
            if (securityConfigObject != null) {
                string = securityConfigObject.getProperties().getProperty("com.ibm.CSI.throwExceptionForAllPropagationSerializationProblems");
                throwExceptionForAllPropagationSerializationProblems = string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"));
            }
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.wsspi.security.token.WSOpaqueTokenHelper.init", "155", new Object[]{this});
            Tr.debug(tc, "Exception getting ContextManager.", new Object[]{exception});
            contextManager.setRootException((Throwable)exception);
        }
    }

    public String getOpaqueTokenName() {
        return tokenHeader;
    }

    public String getOpaqueTokenLookup() {
        return "WSOPAQUE:1";
    }

    public int getOpaqueTokenVersion() {
        return 1;
    }

    public byte[] createOpaqueTokenFromSubject(final Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createOpaqueTokenFromSubject");
        }
        if (subject == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromSubject");
            }
            return null;
        }
        try {
            int n;
            Object object;
            ArrayList arrayList = null;
            ArrayList arrayList2 = null;
            if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                try {
                    arrayList = (ArrayList)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws WSLoginFailedException {
                            return WSOpaqueTokenHelper.this.getForwardableTokensFromSubject(subject);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Manager.Ffdc.log((Throwable)privilegedActionException.getException(), (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromSubject", "267", new Object[]{this});
                    Tr.debug(tc, "Exception getting private/public tokens from Subject.", new Object[]{privilegedActionException.getException()});
                    return null;
                }
                if (arrayList == null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token list is null.");
                }
                if ((arrayList2 = ContextManagerFactory.getInstance().getWSCredTokenMapper().getForwardablePropagationTokensFromContext()) == null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "propagation token list is null.");
                }
            }
            if (arrayList2 == null && arrayList == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Propagation and subject token lists are null.");
            }
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            if (arrayList2 != null) {
                object = arrayList2.toArray();
                for (n = 0; n < ((Object[])object).length; ++n) {
                    arrayList3.add(object[n]);
                }
            }
            if (arrayList != null) {
                object = arrayList.toArray();
                for (n = 0; n < ((Object[])object).length; ++n) {
                    arrayList3.add(object[n]);
                }
            }
            if (arrayList3.size() > 0 && SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
                object = ContextManagerFactory.getInstance().getWSCredTokenMapper().createUniqueIDFromAllTokens(subject);
                if (object == null) {
                    WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                    object = wSCredential.getRealmName() + ":" + wSCredential.getUniqueSecurityName();
                }
                TokenHolder tokenHolder = new TokenHolder(StringBytesConversion.getConvertedBytes((String)object), "com.ibm.wsspi.security.cred.cacheKey", 1);
                arrayList3.add(tokenHolder);
            } else if (arrayList3.size() > 0) {
                object = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                String string = object.getRealmName() + ":" + object.getUniqueSecurityName();
                TokenHolder tokenHolder = new TokenHolder(StringBytesConversion.getConvertedBytes((String)string), "com.ibm.wsspi.security.cred.cacheKey", 1);
                arrayList3.add(tokenHolder);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromSubject");
            }
            return this.createOpaqueTokenFromTokenHolderList(subject, arrayList3);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSLoginFailedException occurred creating opaque token.", new Object[]{wSLoginFailedException});
            }
            Manager.Ffdc.log((Throwable)wSLoginFailedException, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.updatePropagationTokenWithSubjectChange", "345", new Object[]{this});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromSubject");
            }
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating opaque token.", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.updatePropagationTokenWithSubjectChange", "352", new Object[]{this});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromSubject");
            }
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    public synchronized byte[] createOpaqueTokenFromTokenHolderList(Subject subject, ArrayList arrayList) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createOpaqueTokenFromTokenHolderList");
        }
        if ((arrayList == null || arrayList.size() == 0) && tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning null token.", new Object[]{arrayList});
        }
        try {
            Object object;
            DataOutputStream dataOutputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            block35: {
                byteArrayOutputStream = new ByteArrayOutputStream(500);
                dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token header size: " + this.tokenHeaderSize);
                }
                dataOutputStream.write(this.tokenHeaderBytes, 0, this.tokenHeaderSize);
                dataOutputStream.write(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing opaque token header/version: WSOPAQUE/V1");
                }
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                Hashtable hashtable = null;
                if (wSCredential != null) {
                    hashtable = ((WSCredentialImpl)wSCredential).getTable();
                }
                byte[] byArray = null;
                int n = 0;
                if (hashtable != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Attempting to write wsCred hashtable.");
                    }
                    try {
                        byArray = this.serialize_internal(hashtable, ObjectOutputStream.class);
                        if (byArray != null) {
                            n = byArray.length;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Offset size: " + byteArrayOutputStream.size());
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "wsCredHashHeaderSize: " + this.wsCredHashHeaderSize);
                            }
                            dataOutputStream.write(this.wsCredHashHeaderBytes, 0, this.wsCredHashHeaderSize);
                            dataOutputStream.writeInt(n);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Writing wsCred hashtable, length: " + n);
                            }
                            dataOutputStream.write(byArray, 0, n);
                        }
                    }
                    catch (Exception exception) {
                        byArray = null;
                        n = 0;
                        Tr.warning(tc, "security.sap.warning.serializing.custom.objects.from.subject", new Object[]{hashtable});
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred writing wsCred hashtable.", new Object[]{exception});
                        }
                        if (!throwExceptionForAllPropagationSerializationProblems) break block35;
                        throw exception;
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total tokens to write: " + arrayList.size());
            }
            dataOutputStream.write(this.wsTokensHeaderBytes, 0, this.wsTokensHeaderSize);
            dataOutputStream.write(arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                object = null;
                int n = 0;
                byte[] byArray = null;
                int n2 = 0;
                byte[] byArray2 = null;
                int n3 = 0;
                TokenHolder tokenHolder = (TokenHolder)arrayList.get(i);
                if (tokenHolder == null) continue;
                object = tokenHolder.getName();
                n2 = tokenHolder.getVersion();
                byArray2 = tokenHolder.getBytes();
                if (object == null || n2 == 0 || byArray2 == null) continue;
                byArray = StringBytesConversion.getConvertedBytes((String)object);
                n = byArray.length;
                n3 = byArray2.length;
                dataOutputStream.writeInt(n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing token name: " + (String)object);
                }
                dataOutputStream.write(byArray, 0, n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing token version: " + n2);
                }
                dataOutputStream.write(n2);
                dataOutputStream.writeInt(n3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing token bytes, length: " + n3);
                }
                dataOutputStream.write(byArray2, 0, n3);
            }
            ArrayList arrayList2 = null;
            try {
                if (subject != null) {
                    object = subject;
                    arrayList2 = (ArrayList)AccessController.doPrivileged(new PrivilegedExceptionAction((Subject)object){
                        final /* synthetic */ Subject val$subjectPriv;
                        {
                            this.val$subjectPriv = subject;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object run() throws Exception {
                            Subject subject = this.val$subjectPriv;
                            synchronized (subject) {
                                String string;
                                Object object;
                                ArrayList<TokenHolder> arrayList = new ArrayList<TokenHolder>();
                                Object object22 = null;
                                byte[] byArray = null;
                                for (Object object2 : this.val$subjectPriv.getPublicCredentials()) {
                                    if (object2 instanceof Token || object2 instanceof KRBAuthnToken || object2 instanceof WSCredential || WSOpaqueTokenHelper.this.isExcluded(object2)) continue;
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Serializing custom public object: ", new Object[]{object2});
                                        }
                                        byArray = WSOpaqueTokenHelper.this.serialize_internal(object2, ObjectOutputStream.class);
                                        Object object3 = null;
                                        try {
                                            object = object2.getClass().getName();
                                            object3 = (String)object + WSOpaqueTokenHelper.customPublicTokensHeaderEnding;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        if (object3 == null) {
                                            object3 = WSOpaqueTokenHelper.customPublicTokensHeader;
                                        }
                                        if (byArray == null) continue;
                                        arrayList.add(new TokenHolder(byArray, (String)object3, 1));
                                    }
                                    catch (Exception exception) {
                                        Tr.warning(tc, "security.sap.warning.serializing.custom.objects.from.subject", new Object[]{object2});
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Exception occurred serializing custom public object.", new Object[]{exception});
                                        }
                                        Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", "536", new Object[]{this});
                                        if (!throwExceptionForAllPropagationSerializationProblems) continue;
                                        throw exception;
                                    }
                                }
                                for (Object object4 : this.val$subjectPriv.getPrivateCredentials()) {
                                    if (object4 instanceof Token || object4 instanceof KRBAuthnToken || object4 instanceof WSCredential || WSOpaqueTokenHelper.this.isExcluded(object4)) continue;
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Serializing custom private object: ", new Object[]{object4});
                                        }
                                        byArray = WSOpaqueTokenHelper.this.serialize_internal(object4, ObjectOutputStream.class);
                                        object = null;
                                        try {
                                            string = object4.getClass().getName();
                                            object = string + WSOpaqueTokenHelper.customPrivateTokensHeaderEnding;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        if (object == null) {
                                            object = WSOpaqueTokenHelper.customPrivateTokensHeader;
                                        }
                                        if (byArray == null) continue;
                                        arrayList.add(new TokenHolder(byArray, (String)object, 1));
                                    }
                                    catch (Exception exception) {
                                        Tr.warning(tc, "security.sap.warning.serializing.custom.objects.from.subject", new Object[]{object4});
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Exception occurred serializing custom public object.", new Object[]{exception});
                                        }
                                        Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", "578", new Object[]{this});
                                        if (!throwExceptionForAllPropagationSerializationProblems) continue;
                                        throw exception;
                                    }
                                }
                                for (Principal principal : this.val$subjectPriv.getPrincipals()) {
                                    if (principal instanceof WSPrincipal || WSOpaqueTokenHelper.this.isExcluded(principal)) continue;
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Serializing custom principal object: ", new Object[]{principal});
                                        }
                                        byArray = WSOpaqueTokenHelper.this.serialize_internal(principal, ObjectOutputStream.class);
                                        string = null;
                                        try {
                                            String string2 = principal.getClass().getName();
                                            string = string2 + WSOpaqueTokenHelper.customPrincipalTokensHeaderEnding;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        if (string == null) {
                                            string = WSOpaqueTokenHelper.customPrincipalTokensHeader;
                                        }
                                        if (byArray == null) continue;
                                        arrayList.add(new TokenHolder(byArray, string, 1));
                                    }
                                    catch (Exception exception) {
                                        Tr.warning(tc, "security.sap.warning.serializing.custom.objects.from.subject", new Object[]{principal});
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Exception occurred serializing custom public object.", new Object[]{exception});
                                        }
                                        Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", "619", new Object[]{this});
                                        if (!throwExceptionForAllPropagationSerializationProblems) continue;
                                        throw exception;
                                    }
                                }
                                return arrayList;
                            }
                        }
                    });
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                Manager.Ffdc.log((Throwable)privilegedActionException.getException(), (Object)this, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.commit", "636", new Object[]{this});
                ContextManager contextManager = ContextManagerFactory.getInstance();
                contextManager.setRootException((Throwable)privilegedActionException.getException());
                throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
            }
            if (arrayList2 != null && arrayList2.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Total custom tokens to write: " + arrayList2.size());
                }
                dataOutputStream.write(this.customTokensHeaderBytes, 0, this.customTokensHeaderSize);
                dataOutputStream.write(arrayList2.size());
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string = null;
                    int n = 0;
                    byte[] byArray = null;
                    int n4 = 0;
                    byte[] byArray3 = null;
                    int n5 = 0;
                    TokenHolder tokenHolder = (TokenHolder)arrayList2.get(i);
                    if (tokenHolder == null) continue;
                    string = tokenHolder.getName();
                    n4 = tokenHolder.getVersion();
                    byArray3 = tokenHolder.getBytes();
                    if (string == null || n4 == 0 || byArray3 == null) continue;
                    byArray = StringBytesConversion.getConvertedBytes((String)string);
                    n = byArray.length;
                    n5 = byArray3.length;
                    dataOutputStream.writeInt(n);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Writing token name: " + string);
                    }
                    dataOutputStream.write(byArray, 0, n);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Writing token version: " + n4);
                    }
                    dataOutputStream.write(n4);
                    dataOutputStream.writeInt(n5);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Writing token bytes, length: " + n5);
                    }
                    dataOutputStream.write(byArray3, 0, n5);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total opaque token length: " + byteArrayOutputStream.size());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromTokenHolderList");
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", "704", new Object[]{this});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating opaque token.", new Object[]{exception});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromTokenHolderList");
            }
            if (throwExceptionForAllPropagationSerializationProblems) {
                throw exception;
            }
            return null;
        }
    }

    public ArrayList createTokenHolderListFromOpaqueToken(byte[] byArray) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTokenHolderListFromOpaqueToken");
        }
        if (byArray == null || byArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning null token holder ArrayList.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTokenHolderListFromOpaqueToken");
            }
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            boolean bl = this.checkOpaqueTokenHeader(dataInputStream);
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Successfully read the opaque token header, beginning to process token.");
                }
                ArrayList<TokenHolder> arrayList = new ArrayList<TokenHolder>();
                boolean bl2 = this.checkCredHashHeader(dataInputStream);
                if (bl2) {
                    byte[] byArray2 = null;
                    byArray2 = this.readCredHashTableBytes(dataInputStream);
                    if (byArray2 != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Successfully retrieved wsCredHash bytes.");
                        }
                        arrayList.add(new TokenHolder(byArray2, wsCredHashHeader, 1));
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "wsCredHash bytes could not be read from InputStream.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The wsCred hashtable not present in opaque byte array.");
                }
                boolean bl3 = this.checkTokensHeader(dataInputStream);
                if (bl3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reading standard tokens from opaque token.");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There are no tokens present in opaque byte array.");
                    }
                    throw new WSSecurityException("There are no tokens present in opaque byte array.");
                }
                this.readTokens(dataInputStream, arrayList);
                bl3 = this.checkCustomTokensHeader(dataInputStream);
                if (bl3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reading custom tokens from opaque token.");
                    }
                    this.readTokens(dataInputStream, arrayList);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There are no custom tokens present in opaque byte array.");
                }
                return arrayList;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not a WAS opaque authorization token, returning null.");
            }
            return null;
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", "817", new Object[]{this});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating opaque token.", new Object[]{exception});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTokenHolderListFromOpaqueToken");
            }
            if (throwExceptionForAllPropagationSerializationProblems) {
                if (exception instanceof WSSecurityException) {
                    throw (WSSecurityException)exception;
                }
                throw new WSSecurityException(exception.getMessage(), exception);
            }
            return null;
        }
    }

    private void readTokens(DataInputStream dataInputStream, ArrayList arrayList) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readTokens");
        }
        try {
            int n = dataInputStream.readByte();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of tokens to be handled: " + n);
            }
            for (int i = 0; i < n; ++i) {
                String string = null;
                byte[] byArray = null;
                int n2 = 0;
                byte by = 0;
                byte[] byArray2 = null;
                int n3 = 0;
                n2 = dataInputStream.readInt();
                byArray = new byte[n2];
                dataInputStream.read(byArray, 0, n2);
                string = StringBytesConversion.getConvertedString((byte[])byArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found token name: " + string);
                }
                by = dataInputStream.readByte();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token version: " + by);
                }
                n3 = dataInputStream.readInt();
                byArray2 = new byte[n3];
                dataInputStream.read(byArray2, 0, n3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token bytes length: " + n3);
                }
                if (byArray2 == null || string == null) {
                    throw new WSSecurityException("malformed token, cannot retrieve token bytes.");
                }
                arrayList.add(new TokenHolder(byArray2, string, by));
            }
        }
        catch (WSSecurityException wSSecurityException) {
            Manager.Ffdc.log((Throwable)wSSecurityException, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.readTokens", "885", new Object[]{this});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readTokens exception", new Object[]{wSSecurityException});
            }
            throw wSSecurityException;
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.readTokens", "891", new Object[]{this});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readTokens exception", new Object[]{exception});
            }
            throw new WSSecurityException(exception.getMessage(), exception);
        }
    }

    private byte[] readCredHashTableBytes(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readCredHashTableBytes");
        }
        try {
            dataInputStream.mark(dataInputStream.available());
            int n = 0;
            byte[] byArray = null;
            n = dataInputStream.readInt();
            if (n > 0) {
                byArray = new byte[n];
                dataInputStream.read(byArray, 0, n);
                return byArray;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readCredHashTableBytes, invalid size = " + n);
            }
            return null;
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.readCredHashTableBytes", "932", new Object[]{this});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readCredHashTableBytes exception", new Object[]{exception});
            }
            return null;
        }
    }

    private boolean checkOpaqueTokenHeader(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkOpaqueTokenHeader");
        }
        try {
            byte[] byArray = null;
            String string = null;
            byArray = new byte[this.tokenHeaderSize];
            dataInputStream.read(byArray, 0, this.tokenHeaderSize);
            if (byArray != null) {
                string = StringBytesConversion.getConvertedString((byte[])byArray);
                if (string.equals(tokenHeader)) {
                    byte by = dataInputStream.readByte();
                    if (by == 1) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "checkOpaqueTokenHeader, true");
                        }
                        return true;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkOpaqueTokenHeader, version mismatch, version = " + by);
                    }
                    return false;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkOpaqueTokenHeader, invalid header, false");
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkOpaqueTokenHeader, no header, false");
            }
            return false;
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.checkOpaqueTokenHeader", "987", new Object[]{this});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkOpaqueTokenHeader exception", new Object[]{exception});
            }
            return false;
        }
    }

    private boolean checkCredHashHeader(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCredHashHeader");
        }
        try {
            dataInputStream.mark(dataInputStream.available());
            byte[] byArray = null;
            String string = null;
            byArray = new byte[this.wsCredHashHeaderSize];
            dataInputStream.read(byArray, 0, this.wsCredHashHeaderSize);
            if (byArray != null) {
                string = StringBytesConversion.getConvertedString((byte[])byArray);
                if (string.equals(wsCredHashHeader)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkCredHashHeader, true");
                    }
                    return true;
                }
                dataInputStream.reset();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkCredHashHeader, false");
                }
                return false;
            }
            dataInputStream.reset();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCredHashHeader, no header, false");
            }
            return false;
        }
        catch (Exception exception) {
            try {
                dataInputStream.reset();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.checkCredHashHeader", "1041", new Object[]{this});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCredHashHeader exception", new Object[]{exception});
            }
            return false;
        }
    }

    private boolean checkTokensHeader(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTokensHeader");
        }
        try {
            dataInputStream.mark(dataInputStream.available());
            byte[] byArray = null;
            String string = null;
            byArray = new byte[this.wsTokensHeaderSize];
            dataInputStream.read(byArray, 0, this.wsTokensHeaderSize);
            if (byArray != null) {
                string = StringBytesConversion.getConvertedString((byte[])byArray);
                if (string.equals(wsTokensHeader)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkTokensHeader, true");
                    }
                    return true;
                }
                dataInputStream.reset();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkTokensHeader, false");
                }
                return false;
            }
            dataInputStream.reset();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkTokensHeader, no header, false");
            }
            return false;
        }
        catch (Exception exception) {
            try {
                dataInputStream.reset();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.checkTokensHeader", "1095", new Object[]{this});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkTokensHeader exception", new Object[]{exception});
            }
            return false;
        }
    }

    private boolean checkCustomTokensHeader(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCustomTokensHeader");
        }
        try {
            dataInputStream.mark(dataInputStream.available());
            byte[] byArray = null;
            String string = null;
            byArray = new byte[this.customTokensHeaderSize];
            dataInputStream.read(byArray, 0, this.customTokensHeaderSize);
            if (byArray != null) {
                string = StringBytesConversion.getConvertedString((byte[])byArray);
                if (string.equals(customTokensHeader)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkCustomTokensHeader, true");
                    }
                    return true;
                }
                dataInputStream.reset();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkCustomTokensHeader, false");
                }
                return false;
            }
            dataInputStream.reset();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCustomTokensHeader, no header, false");
            }
            return false;
        }
        catch (Exception exception) {
            try {
                dataInputStream.reset();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.checkCustomTokensHeader", "1149", new Object[]{this});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCustomTokensHeader exception", new Object[]{exception});
            }
            return false;
        }
    }

    private byte[] serialize_internal(Object object, Class clazz) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        byte[] byArray = null;
        try {
            objectOutputStream.writeObject(object);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception serializing object. ", new Object[]{exception});
            }
            throw exception;
        }
        finally {
            try {
                objectOutputStream.close();
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    public static byte[] serialize(Object object) throws Exception {
        return WSOpaqueTokenHelper.serialize(object, ObjectOutputStream.class);
    }

    private static byte[] serialize(Object object, Class clazz) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        byte[] byArray = null;
        try {
            objectOutputStream.writeObject(object);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception serializing object. ", new Object[]{exception});
            }
            throw exception;
        }
        finally {
            try {
                objectOutputStream.close();
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    public static Object deserialize(byte[] byArray) throws Exception {
        return WSOpaqueTokenHelper.deserialize(byArray, WsObjectInputStream.class);
    }

    private static Object deserialize(byte[] byArray, Class clazz) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        WsObjectInputStream wsObjectInputStream = new WsObjectInputStream((InputStream)byteArrayInputStream);
        Object object = null;
        try {
            object = wsObjectInputStream.readObject();
        }
        catch (Exception exception) {
            Tr.warning(tc, "security.sap.warning.deserializing.custom.objects.from.subject");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception deserializing object. ", new Object[]{exception});
            }
            throw exception;
        }
        finally {
            try {
                wsObjectInputStream.close();
                byteArrayInputStream.close();
            }
            catch (Exception exception) {}
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getForwardableTokensFromSubject(Subject subject) throws WSLoginFailedException {
        if (subject == null) {
            Tr.debug(tc, "Null Subject passed in.");
            return null;
        }
        try {
            Subject subject2 = subject;
            synchronized (subject2) {
                ArrayList<TokenHolder> arrayList = new ArrayList<TokenHolder>();
                Set<Object> set = subject.getPrivateCredentials();
                Set<Object> set2 = subject.getPublicCredentials();
                for (Object iterator : set) {
                    Object object;
                    if (iterator instanceof KRBAuthnToken) {
                        object = (AuthenticationToken)iterator;
                        if (((KRBAuthnToken)iterator).isTokenForwardable()) {
                            if (!((KRBAuthnToken)iterator).isTokenValid()) {
                                Tr.debug(tc, "Token with name " + object.getName() + " is expired.");
                                throw new WSLoginFailedException("Token with name " + object.getName() + " is expired.");
                            }
                            if (object.getBytes() != null && object.getName() != null && object.getVersion() != 0) {
                                arrayList.add(new TokenHolder(object.getBytes(), object.getName(), object.getVersion()));
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Did not add token " + object.getName() + ":" + object.getVersion() + " to opaque token, bytes null? " + object.getBytes());
                            continue;
                        }
                        Tr.debug(tc, "Token with name " + object.getName() + " is not forwardable.");
                        continue;
                    }
                    if (!(iterator instanceof Token)) continue;
                    object = (Token)iterator;
                    if (object.isForwardable()) {
                        if (!object.isValid()) {
                            Tr.debug(tc, "Token with name " + object.getName() + " is expired.");
                            throw new WSLoginFailedException("Token with name " + object.getName() + " is expired.");
                        }
                        if (object.getBytes() != null && object.getName() != null && object.getVersion() != 0) {
                            arrayList.add(new TokenHolder(object.getBytes(), object.getName(), object.getVersion()));
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Did not add token " + object.getName() + ":" + object.getVersion() + " to opaque token, bytes null? " + object.getBytes());
                        continue;
                    }
                    Tr.debug(tc, "Token with name " + object.getName() + " is not forwardable.");
                }
                for (Object object : set2) {
                    Token token;
                    if (!(object instanceof Token) || !(token = (Token)object).isForwardable() || !token.isValid()) continue;
                    if (token.getBytes() != null && token.getName() != null && token.getVersion() != 0) {
                        arrayList.add(new TokenHolder(token.getBytes(), token.getName(), token.getVersion()));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Did not add token " + token.getName() + ":" + token.getVersion() + " to opaque token, bytes null? " + token.getBytes());
                }
                if (arrayList != null && arrayList.size() > 0) {
                    return arrayList;
                }
                return null;
            }
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Manager.Ffdc.log((Throwable)wSLoginFailedException, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.getForwardableAuthzTokensFromSubject", "1359", new Object[]{this});
            Tr.debug(tc, "WSLoginFailedException getting forwardable tokens from Subject.", new Object[]{wSLoginFailedException});
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.getForwardableAuthzTokensFromSubject", "1365", new Object[]{this});
            Tr.debug(tc, "Exception getting forwardable tokens from Subject.", new Object[]{exception});
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    private boolean isExcluded(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isExcluded");
        }
        try {
            Object object2;
            if (excludeList == null) {
                String string;
                object2 = ContextManagerFactory.getInstance();
                String string2 = object2.getProperty("com.ibm.ws.security.propagationExcludeList");
                excludeList = new ArrayList();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (string.endsWith("*")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding entry to exclude list: " + string);
                    }
                    excludeList.add(string);
                }
                string = WSSMarkerObject.class.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding entry to exclude list: " + string);
                }
                excludeList.add(string);
            }
            object2 = object.getClass().getName();
            for (int i = 0; i < excludeList.size(); ++i) {
                if (((String)object2).equals((String)excludeList.get(i))) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, (String)object2 + " isExcluded (true), list rule -> " + excludeList.get(i));
                    }
                    return true;
                }
                if (((String)object2).startsWith((String)excludeList.get(i))) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, (String)object2 + " isExcluded (true), list rule -> " + excludeList.get(i));
                    }
                    return true;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, (String)object2 + " isExcluded (false)");
            }
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.ws.security.token.WSOpaqueTokenHelper.isExcluded", "1418", new Object[]{this});
            Tr.debug(tc, "Exception checking if class is excluded from propagation.", new Object[]{exception});
        }
        return false;
    }
}

