/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.pmi.factory;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.ws.pmi.factory.StatsFactoryUtil;
import com.ibm.ws.pmi.factory.StatsGroupImpl;
import com.ibm.ws.pmi.factory.StatsInstanceImpl;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.factory.StatsTemplateLookup;
import javax.management.ObjectName;

public class StatsFactory {
    private static final TraceComponent tc = Tr.register(StatsFactory.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.pmi.properties.PMIMessages");

    public static boolean isPMIEnabled() {
        return !PmiRegistry.isDisabled();
    }

    public static StatsGroup createStatsGroup(String string, String string2, ObjectName objectName) throws StatsFactoryException {
        StatsGroup statsGroup;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsGroup:name=").append(string).append(";template=").append(string2).append(";mBean=").append(objectName == null ? null : objectName.toString()).toString());
        }
        StatsFactory.checkPMIService(string);
        try {
            statsGroup = StatsGroupImpl.createGroup((String)string, (String)string2, (ObjectName)objectName, (boolean)false);
        }
        catch (StatsFactoryException statsFactoryException) {
            if (tc.isDebugEnabled()) {
                statsFactoryException.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsGroup");
            }
            throw statsFactoryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsGroup");
        }
        return statsGroup;
    }

    public static StatsGroup createStatsGroup(String string, String string2, StatsGroup statsGroup, ObjectName objectName) throws StatsFactoryException {
        StatsGroup statsGroup2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsGroup:name=").append(string).append(";parent group=").append(statsGroup.getName()).append(";template=").append(string2).append(";mBean=").append(objectName == null ? null : objectName.toString()).toString());
        }
        StatsFactory.checkPMIService(string);
        try {
            statsGroup2 = StatsGroupImpl.createGroup((String)string, (StatsGroup)statsGroup, (String)string2, (ObjectName)objectName, (boolean)false);
        }
        catch (StatsFactoryException statsFactoryException) {
            if (tc.isDebugEnabled()) {
                statsFactoryException.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsGroup");
            }
            throw statsFactoryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsGroup");
        }
        return statsGroup2;
    }

    public static StatsGroup createStatsGroup(String string, String string2, StatsInstance statsInstance, ObjectName objectName) throws StatsFactoryException {
        StatsGroup statsGroup;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsGroup:name=").append(string).append(";parent instance=").append(statsInstance.getName()).append(";template=").append(string2).append(";mBean=").append(objectName == null ? null : objectName.toString()).toString());
        }
        StatsFactory.checkPMIService(string);
        try {
            statsGroup = StatsGroupImpl.createGroup((String)string, (StatsInstance)statsInstance, (String)string2, (ObjectName)objectName, (boolean)false);
        }
        catch (StatsFactoryException statsFactoryException) {
            if (tc.isDebugEnabled()) {
                statsFactoryException.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsGroup");
            }
            throw statsFactoryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsGroup");
        }
        return statsGroup;
    }

    public static StatsInstance createStatsInstance(String string, String string2, ObjectName objectName, StatisticActionListener statisticActionListener) throws StatsFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsInstance:name=").append(string).append(";template=").append(string2).append(";mBean=").append(objectName == null ? null : objectName.toString()).toString());
        }
        StatsInstance statsInstance = StatsFactory.createStatsInstance(string, string2, objectName, new StatisticActions(statisticActionListener));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return statsInstance;
    }

    public static StatsInstance createStatsInstance(String string, String string2, ObjectName objectName, StatisticActions statisticActions) throws StatsFactoryException {
        StatsInstanceImpl statsInstanceImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsInstance:name=").append(string).append(";template=").append(string2).append(";mBean=").append(objectName == null ? null : objectName.toString()).toString());
        }
        StatsFactory.checkPMIService(string);
        try {
            statsInstanceImpl = StatsInstanceImpl.createInstance((String)string, (String)string2, (ObjectName)objectName, (boolean)false, (StatisticActions)statisticActions);
        }
        catch (StatsFactoryException statsFactoryException) {
            if (tc.isDebugEnabled()) {
                statsFactoryException.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsInstance");
            }
            throw statsFactoryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return statsInstanceImpl;
    }

    public static StatsInstance createStatsInstance(String string, StatsGroup statsGroup, ObjectName objectName, StatisticActionListener statisticActionListener) throws StatsFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsInstance:name=").append(string).append(";parent name=").append(statsGroup.getName()).append(";mBean=").append(objectName == null ? null : objectName.toString()).toString());
        }
        StatsInstance statsInstance = StatsFactory.createStatsInstance(string, statsGroup, objectName, new StatisticActions(statisticActionListener));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return statsInstance;
    }

    public static StatsInstance createStatsInstance(String string, StatsGroup statsGroup, ObjectName objectName, StatisticActions statisticActions) throws StatsFactoryException {
        StatsInstanceImpl statsInstanceImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsInstance:name=").append(string).append(";parent name=").append(statsGroup.getName()).append(";mBean=").append(objectName == null ? null : objectName.toString()).toString());
        }
        StatsFactory.checkPMIService(string);
        try {
            statsInstanceImpl = StatsInstanceImpl.createGroupInstance((String)string, (StatsGroup)statsGroup, (ObjectName)objectName, (boolean)false, (StatisticActions)statisticActions);
        }
        catch (StatsFactoryException statsFactoryException) {
            if (tc.isDebugEnabled()) {
                statsFactoryException.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsInstance");
            }
            throw statsFactoryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return statsInstanceImpl;
    }

    public static StatsInstance createStatsInstance(String string, String string2, StatsGroup statsGroup, ObjectName objectName, StatisticActionListener statisticActionListener) throws StatsFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsInstance:name=").append(string).append(";template=").append(string2).append(";parent name=").append(statsGroup.getName()).append(";mBean=").append(objectName == null ? null : objectName.toString()).toString());
        }
        StatsInstance statsInstance = StatsFactory.createStatsInstance(string, string2, statsGroup, objectName, new StatisticActions(statisticActionListener));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return statsInstance;
    }

    public static StatsInstance createStatsInstance(String string, String string2, StatsGroup statsGroup, ObjectName objectName, StatisticActions statisticActions) throws StatsFactoryException {
        StatsInstanceImpl statsInstanceImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("createStatsInstance:name=").append(string).append(";template=").append(string2).append(";parent name=").append(statsGroup.getName()).append(";mBean=").append(objectName == null ? null : objectName.toString()).toString());
        }
        StatsFactory.checkPMIService(string);
        try {
            statsInstanceImpl = StatsInstanceImpl.createGroupInstance((String)string, (StatsGroup)statsGroup, (String)string2, (ObjectName)objectName, (boolean)false, (StatisticActions)statisticActions);
        }
        catch (StatsFactoryException statsFactoryException) {
            if (tc.isDebugEnabled()) {
                statsFactoryException.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsInstance");
            }
            throw statsFactoryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return statsInstanceImpl;
    }

    public static void removeStatsInstance(StatsInstance statsInstance) throws StatsFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("removeStatsInstance:name=").append(statsInstance.getName()).toString());
        }
        StatsFactoryUtil.unRegisterStats((PmiModule)((PmiModule)statsInstance), (ObjectName)statsInstance.getMBean());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeStatsInstance");
        }
    }

    public static void removeStatsGroup(StatsGroup statsGroup) throws StatsFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("removeStatsGroup:name=").append(statsGroup.getName()).toString());
        }
        StatsFactoryUtil.unRegisterStats((PmiModule)((PmiModule)statsGroup), (ObjectName)statsGroup.getMBean());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeStatsGroup");
        }
    }

    public static void registerStatsTemplateLookup(StatsTemplateLookup statsTemplateLookup) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new StringBuffer("registerStatsTemplateLookup: ").append(statsTemplateLookup.getClass().getName()).toString());
        }
        PerfModules.registerTemplateLookupClass((StatsTemplateLookup)statsTemplateLookup);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerStatsTemplateLookup");
        }
    }

    public static StatsGroup getStatsGroup(String[] stringArray) {
        StatsGroup statsGroup = null;
        if (stringArray != null) {
            PmiModule pmiModule;
            ModuleItem moduleItem;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getStatsGroup: " + StatsFactory._arrayToString(stringArray));
            }
            if ((moduleItem = PmiRegistry.findModuleItem((String[])stringArray)) != null && (pmiModule = moduleItem.getInstance()) instanceof StatsGroupImpl) {
                statsGroup = (StatsGroup)pmiModule;
            }
        } else if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsGroup: path is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsGroup");
        }
        return statsGroup;
    }

    public static StatsInstance getStatsInstance(String[] stringArray) {
        StatsInstance statsInstance = null;
        if (stringArray != null) {
            PmiModule pmiModule;
            ModuleItem moduleItem;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getStatsInstance: " + StatsFactory._arrayToString(stringArray));
            }
            if ((moduleItem = PmiRegistry.findModuleItem((String[])stringArray)) != null && (pmiModule = moduleItem.getInstance()) instanceof StatsInstanceImpl) {
                statsInstance = (StatsInstance)pmiModule;
            }
        } else if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsInstance: path is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsInstance");
        }
        return statsInstance;
    }

    private static String _arrayToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append("/").append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private static void checkPMIService(String string) throws StatsFactoryException {
        if (!StatsFactory.isPMIEnabled()) {
            Tr.warning(tc, "PMI0107W", string);
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0107W", new Object[]{string}, "PMI0107W: Unable to register custom PMI module since the PMI service is not enabled: {0}"));
        }
    }
}

