/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.provisioning;

import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.provisioning.ComponentInfo;
import com.ibm.wsspi.runtime.provisioning.ComponentInfoFactory;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdminServerActivationHelper {
    private static String serverType;
    private static String processType;
    public static final String MANAGED_PROCESS = "managed";
    public static final String UNMANAGED_PROCESS = "unmanaged";

    public static String getProcessType() throws RuntimeError {
        if (processType == null) {
            AdminServerActivationHelper.retrieveProcessType();
        }
        return processType;
    }

    public static String getServerType() throws RuntimeError {
        if (serverType == null) {
            AdminServerActivationHelper.retrieveServerType();
        }
        return serverType;
    }

    public static void retrieveServerType() throws RuntimeError {
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("Begin Admin ServerActivationHelper.retrieveServerType()");
        }
        try {
            ConfigService configService = (ConfigService)WsServiceRegistry.getService(AdminServerActivationHelper.class, ConfigService.class);
            String currentServerName = configService.getServerName();
            List list = configService.getDocumentObjects(configService.getScope(3), "serverindex.xml");
            ConfigObject configObject = (ConfigObject)list.get(0);
            List serverEntries = configObject.getObjectList("serverEntries");
            if (serverEntries == null) {
                throw new RuntimeError("No serverEntries in serverindex.xml");
            }
            for (ConfigObject serverEntry : serverEntries) {
                String serverName = serverEntry.getString("serverName", "__null__");
                if (!serverName.equals(currentServerName)) continue;
                serverType = serverEntry.getString("serverType", "__null__");
            }
            if (serverType == null) {
                throw new RuntimeError("No serverType found for current server");
            }
        }
        catch (Exception e) {
            throw new RuntimeError("Exception caught while retrieving server type", e);
        }
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("Exit AdminServerActivationHelper.retrieveServerType()");
        }
    }

    public static String retrieveProcessType() throws RuntimeError {
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("Begin AdminServerActivationHelper.retrieveProcessType()");
        }
        try {
            ConfigService configService = (ConfigService)WsServiceRegistry.getService(AdminServerActivationHelper.class, ConfigService.class);
            List list = configService.getDocumentObjects(configService.getScope(4), "server.xml");
            ConfigObject serverObject = (ConfigObject)list.get(0);
            List services = serverObject.getObjectList("services");
            for (ConfigObject service : services) {
                if (!service.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "AdminService")) continue;
                if (LoggingServices.debugEnabled) {
                    LoggingServices.out.println("found AdminService");
                }
                boolean standalone = service.getBoolean("standalone", true);
                if (LoggingServices.debugEnabled) {
                    LoggingServices.out.println("standalone - " + standalone);
                }
                processType = standalone ? UNMANAGED_PROCESS : MANAGED_PROCESS;
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeError("Exception received while retrieving process type", e);
        }
        if (processType == null) {
            throw new RuntimeError("Unable to retrieve process type");
        }
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("Exit AdminServerActivationHelper.retrieveProcessType()");
        }
        return processType;
    }

    public static List<ComponentInfo> getComponents(String extensionPointId) throws RuntimeError {
        IExtensionRegistry registry;
        IExtensionPoint extensionPoint;
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("Begin AdminServerActivationHelper.getComponents() for " + extensionPointId);
        }
        String currentProcessType = AdminServerActivationHelper.getProcessType();
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("currentProcessType - " + currentProcessType);
        }
        if ((extensionPoint = (registry = ExtensionRegistryFactory.instance().getExtensionRegistry()).getExtensionPoint(extensionPointId)) == null) {
            throw new RuntimeError("Unable to find extension point " + extensionPointId);
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions != null) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("Processing extension point " + extensionPointId);
                LoggingServices.out.println("   found " + extensions.length + " extensions");
            }
        } else {
            return null;
        }
        ArrayList<ComponentInfo> componentList = new ArrayList<ComponentInfo>();
        for (int i = 0; i < extensions.length; ++i) {
            IExtension extension2 = extensions[i];
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("extension found for extension id - " + extension2.getUniqueIdentifier());
            }
            IConfigurationElement[] componentsElements = extension2.getConfigurationElements();
            LoggingServices.out.println("extension found  length = " + componentsElements.length);
            if (componentsElements.length != 1) {
                throw new RuntimeError("Invalid number of <components> elements found - " + componentsElements.length);
            }
            IConfigurationElement componentsElement = componentsElements[0];
            IConfigurationElement[] componentElements = componentsElement.getChildren();
            LoggingServices.out.println("list of components: " + componentElements.length);
            for (int j = 0; j < componentElements.length; ++j) {
                IConfigurationElement componentElement = componentElements[j];
                String processType = componentElement.getAttribute("processType");
                if (processType != null && !processType.equalsIgnoreCase(MANAGED_PROCESS) && !processType.equalsIgnoreCase(UNMANAGED_PROCESS)) {
                    throw new RuntimeError("Invalid value for processType - " + processType);
                }
                if (processType != null && !processType.equalsIgnoreCase(currentProcessType)) continue;
                String componentId = componentElement.getAttribute("id");
                if (componentId == null) {
                    throw new RuntimeError("missing attribute - id");
                }
                String componentVersion2 = componentElement.getAttribute("version");
                if (LoggingServices.debugEnabled) {
                    LoggingServices.out.println("Adding component with componentId " + componentId + " and version " + componentVersion2);
                }
                ComponentInfo component2 = componentVersion2 == null ? ComponentInfoFactory.createComponentInfo((String)componentId) : ComponentInfoFactory.createComponentInfo((String)componentId, (String)componentVersion2);
                componentList.add(component2);
            }
        }
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("Exit AdminServerActivationHelper.getComponents()");
        }
        return componentList;
    }
}

